package com.mmc.oms.entity.ware;

import com.mmc.oms.model.dto.ware.AppletWareInfoDTO;
import com.mmc.oms.model.dto.ware.WareInfoDTO;
import com.mmc.oms.model.dto.ware.WareInfoFirstPageDTO;
import com.mmc.oms.model.dto.ware.WareInfoItemDTO;
import com.mmc.oms.model.vo.ware.WareInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/26 11:31 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WareInfoDO implements Serializable {
    private static final long serialVersionUID = 5530961803742843304L;
    private Integer id;
    private String wareNo;
    private String wareTitle;
    private Integer wareTypeId;
    private Integer wareStatus;
    private Integer payStatus;
    private BigDecimal minDeposit;
    private BigDecimal maxDeposit;
    private BigDecimal minRent;
    private BigDecimal maxRent;
    private Integer totalStock;
    private Integer totalSale;
    private Integer skuNum;
    private String tags;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer pid;

    /**
     * 辅助字段-start
     */
    private List<WareImgDO> wareImgs;
    // private List<WareVideoDO> wareVideos;
    private WarePropDO warePropDO;
    private String wareDetailContent;
    // private WareDetailDO wareDetailDO;
    // private List<SkuInfoDO> skuInfoDOList;

    /**
     * 辅助字段-end
     */
    public WareInfoDTO buildWareInfoDTO() {
        return WareInfoDTO.builder()
                .id(this.id)
                .wareNo(this.wareNo)
                .wareTitle(this.wareTitle)
                .wareTypeId(this.wareTypeId)
                .wareStatus(this.wareStatus)
                .payStatus(this.payStatus)
                .minDeposit(this.minDeposit)
                .maxDeposit(this.maxDeposit)
                .minRent(this.minRent)
                .maxRent(this.maxRent)
                .totalStock(this.totalStock)
                .totalSale(this.totalSale)
                .skuNum(this.skuNum)
                .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
                .wareImgs(
                        CollectionUtils.isEmpty(this.wareImgs)
                                ? null
                                : this.wareImgs.stream()
                                .map(
                                        d -> {
                                            return d.buildWareImgDTO();
                                        })
                                .collect(Collectors.toList()))
                .warePropDTO(this.warePropDO == null ? null : warePropDO.buildWarePropDTO())
                .wareDetailContent(this.wareDetailContent)
                .build();
    }

    public WareInfoItemDTO buildWareInfoItemDTO() {
        return WareInfoItemDTO.builder()
                .id(this.id)
                .wareNo(this.wareNo)
                .wareTitle(this.wareTitle)
                .wareTypeId(this.wareTypeId)
                .wareStatus(this.wareStatus)
                .minDeposit(this.minDeposit)
                .minRent(this.minRent)
                .totalStock(this.totalStock)
                .totalSale(this.totalSale)
                .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
                .wareImgs(
                        CollectionUtils.isEmpty(this.wareImgs)
                                ? null
                                : this.wareImgs.stream()
                                .map(
                                        d -> {
                                            return d.buildWareImgDTO();
                                        })
                                .collect(Collectors.toList()))
                .propInfoId(this.warePropDO.getPropInfoId())
                .createTime(this.createTime)
                .build();
    }

    public AppletWareInfoDTO buildAppletWareInfoDTO() {
        return AppletWareInfoDTO.builder()
                .id(this.id)
                .wareNo(this.wareNo)
                .wareTitle(this.wareTitle)
                .wareTypeId(this.wareTypeId)
                .wareStatus(this.wareStatus)
                .payStatus(this.payStatus)
                .minDeposit(this.minDeposit)
                .minRent(this.minRent)
                .totalStock(this.totalStock)
                .totalSale(this.totalSale)
                .skuNum(this.skuNum)
                .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
                .wareImgs(
                        CollectionUtils.isEmpty(this.wareImgs)
                                ? null
                                : this.wareImgs.stream()
                                .map(
                                        d -> {
                                            return d.buildWareImgDTO();
                                        })
                                .collect(Collectors.toList()))
                .build();
    }

    public WareInfoFirstPageDTO buildWareInfoFirstPageDTO() {
        return WareInfoFirstPageDTO.builder()
                .id(this.id)
                .wareNo(this.wareNo)
                .wareTitle(this.wareTitle)
                .wareTypeId(this.wareTypeId)
                .wareStatus(this.wareStatus)
                .minDeposit(this.minDeposit)
                .minRent(this.minRent)
                .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
                .wareImgs(
                        CollectionUtils.isEmpty(this.wareImgs)
                                ? null
                                : this.wareImgs.stream()
                                .map(WareImgDO::buildWareImgDTO)
                                .collect(Collectors.toList()))
                .warePropDTO(this.warePropDO == null ? null : warePropDO.buildWarePropDTO())
                .build();
    }

    public WareInfoDO(WareInfoVO wareInfoVO) {
        this.id = wareInfoVO.getId();
        this.wareTitle = wareInfoVO.getWareTitle();
        this.wareTypeId = wareInfoVO.getWareTypeId();
        this.wareStatus = wareInfoVO.getWareStatus();
        this.payStatus = wareInfoVO.getPayStatus();
        this.minDeposit = wareInfoVO.getMinDeposit();
        this.minRent = wareInfoVO.getMinRent();
        this.minRent = wareInfoVO.getMinRent();
        this.totalStock = wareInfoVO.getTotalStock();
        this.skuNum = wareInfoVO.getSkuNum();
        this.tags = wareInfoVO.getTags();
    }
}
