package com.mmc.oms.model.dto.data;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/9/16 14:15
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OrderReportDTO {
    @ApiModelProperty(value = "商城售卖订单总数")
    private Integer saleOrderCount;
    @ApiModelProperty(value = "商品租赁订单总数")
    private Integer leaseOrderCount;
    @ApiModelProperty(value = "服务订单订单总数")
    private Integer serviceOrderCount;
    @ApiModelProperty(value = "商城售卖交易总额")
    private BigDecimal saleGMV;
    @ApiModelProperty(value = "商品租赁交易总额")
    private BigDecimal leaseGMV;
    @ApiModelProperty(value = "服务订单交易总额")
    private BigDecimal serviceGMV;
    @ApiModelProperty(value = "交易总额")
    private BigDecimal totalGMV;
}
