package com.mmc.oms.model.vo.uav;

import com.mmc.oms.model.dto.uav.UavCartCompanyDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/9/20 9:46
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AddUavOrderByCartQO implements Serializable {
    private static final long serialVersionUID = 2749055915328197141L;
    @ApiModelProperty("收货地址")
    private Integer userAddressId;

    @ApiModelProperty("订单类型，0正常直接支付订单，1意向沟通订单")
    private Integer orderType;

    @ApiModelProperty("用户备注")
    private String userRemark;

    @ApiModelProperty("每家商户对应的规格")
    private List<UavCartCompanyDTO> cartCompanyDTOS;
}
