package com.mmc.oms.model.dto.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 14:06
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="CouponList对象", description="小程序优惠券表")
public class CouponListDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "优惠券ID")
    private Integer id;

    @ApiModelProperty(value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(value = "优惠券面值")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "优惠券折扣")
    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "是否限量, 默认0不限量， 1限量")
    private Boolean isLimited;

    @ApiModelProperty(value = "每人限制领取张数")
    private Integer restrictedAccess;


    @ApiModelProperty(value = "剩余数量")
    private Integer lastTotal;

    @ApiModelProperty(value = "优惠券类型 1打折卷, 2减免券 3无门槛")
    private Integer couponType;

    @ApiModelProperty(value = "优惠券使用类型 1vip券, 2品牌券")
    private Integer useType;

    @ApiModelProperty(value = "最低消费")
    private BigDecimal minPrice;

    @ApiModelProperty(value = "所属 品牌范围id")
    private String primaryKey;

    @ApiModelProperty(value = "有效期时间方式：0 固定使用时间, 1领取当日起 2领取次日起")
    private Integer isFixedTime;

    @ApiModelProperty(value = "有效期时间范围 开始时间")
    private Date useStartTime;

    @ApiModelProperty(value = "有效期时间范围 结束时间")
    private Date useEndTime;

    @ApiModelProperty(value = "有效期时间天数")
    private Integer couponDay;

    @ApiModelProperty(value = "优惠券类型 1 手动领取 2 系统发放 3 批量导入用户 4活动领取")
    private Integer getType;

    @ApiModelProperty(value = "用户标签")
    private Integer userTag;

    @ApiModelProperty(value = "最多优惠")
    private BigDecimal preferentialLimit;

    @ApiModelProperty(value = "是否已领取未使用")
    private Boolean isUse = false;

    @ApiModelProperty(value = "已经领取数量")
    private Integer receivedCount = 0;

}
