package com.mmc.oms.model.vo.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 13:34
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="CouponInfoActivityVO对象", description="裂变优惠券表添加/修改VO")
public class CouponInfoActivityVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "优惠券名称", required = true)
    @NotBlank(message = "请填写优惠券名称")
    @Length(max = 64, message = "优惠券名称长度不能超过64个字符")
    private String couponName;

    @ApiModelProperty(value = "分享者-优惠券使用类型 1vip,2品牌券", required = true)
    @Range(min = 1, max = 2, message = "请选择优惠券使用类型")
    private Integer useType;

    @ApiModelProperty(value = "分享者-所属 品牌范围id  例：5,9... ", required = true)
    private String primaryKey;

    @ApiModelProperty(value = "分享者-可使用时间范围 开始时间 yyyy-MM-dd HH:mm:ss", required = true)
    private Date useStartTime;

    @ApiModelProperty(value = "分享者-可使用时间范围 结束时间 yyyy-MM-dd HH:mm:ss", required = true)
    private Date useEndTime;

    @ApiModelProperty(value = "分享者-兑换的优惠券面值", required = true)
    @NotNull(message = "请填写优惠券兑换的优惠券面值")
    @DecimalMax(value = "99999.99", message = "优惠券面值不能大于99999.99")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "分享者-最低消费 0为无门槛", required = true)
    private BigDecimal minPrice;

    @ApiModelProperty(value = "分享者-优惠券类型 1打折卷, 2减免券 3无门槛", required = true)
    @Range(min = 1, max = 3, message = "请选择优惠券类型")
    private Integer couponType;

    @ApiModelProperty(value = "分享者-优惠券折扣")
    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "分享者-是否多次核销 0单次核销 1多次核销", required = true)
    private Boolean verificationType;

    @ApiModelProperty(value = "分享者-发放总数", required = true)
    private Integer couponTotal;

    @ApiModelProperty(value = "分享者-每人限制领取张数", required = true)
    private Integer restrictedAccess;

    @ApiModelProperty(value = "被分享用户标签  1新人 2实名认证 3企业认证 4 无")
    private Integer userTag;

    @ApiModelProperty(value = "分享者-分享人数")
    private Integer peopleNumber;

    @ApiModelProperty(value = "分享者-最多优惠")
    private BigDecimal preferentialLimit;


    @ApiModelProperty(value = "被分享者-优惠券使用类型 1vip,2品牌券", required = true)
    @Range(min = 1, max = 2, message = "请选择优惠券使用类型")
    private Integer beSharedUseType;

    @ApiModelProperty(value = "被分享者-所属 品牌范围id  例：5,9... ", required = true)
    private String beSharedPrimaryKey;

    @ApiModelProperty(value = "被分享者-兑换的优惠券面值", required = true)
    @NotNull(message = "请填写优惠券兑换的优惠券面值")
    @DecimalMax(value = "99999.99", message = "优惠券面值不能大于99999.99")
    private BigDecimal beSharedCouponMoney;

    @ApiModelProperty(value = "被分享者-最低消费 0为无门槛", required = true)
    private BigDecimal beSharedMinPrice;

    @ApiModelProperty(value = "被分享者-优惠券类型 1打折卷, 2减免券 3无门槛", required = true)
    @Range(min = 1, max = 3, message = "请选择优惠券类型")
    private Integer beSharedCouponType;

    @ApiModelProperty(value = "分享者-发放总数", required = true)
    private Integer beSharedCouponTotal;

    @ApiModelProperty(value = "被分享者-优惠券折扣")
    private BigDecimal beSharedCouponDiscount;

    @ApiModelProperty(value = "被分享者-是否多次核销 0单次核销 1多次核销", required = true)
    private Boolean beSharedVerificationType;

    @ApiModelProperty(value = "被分享者-最多优惠")
    private BigDecimal beSharedPreferentialLimit;


}
