package com.mmc.oms.controller.uav;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.ContractInfoDTO;
import com.mmc.oms.model.dto.uav.UavOrderDTO;
import com.mmc.oms.model.dto.uav.UavOrderStatusDTO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.uav.*;
import com.mmc.oms.service.uav.UavOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/9/4 13:29
 */
@Api(tags = { "最新版-订单接口" })
@RestController
@RequestMapping("/uav-order/")
public class UavOrderController extends BaseController {
    @Autowired
    private UavOrderService uavOrderService;

    @ApiOperation(value = "提交订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavOrderDTO.class)})
    @PostMapping("addOrder")
    public ResultBody<UavOrderDTO> addOrder(@RequestBody AddUavOrderVO param, HttpServletRequest request) {
        return uavOrderService.addOrder(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavOrderDTO.class)})
    @GetMapping("detail")
    public ResultBody<UavOrderDTO> detail(@RequestParam Integer id, HttpServletRequest request) throws Exception {
        return uavOrderService.detail(id, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "关闭")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("close")
    public ResultBody close(@RequestParam Integer id, HttpServletRequest request) {
        return uavOrderService.close(id, this.getCurrentAccount(request).getToken());
    }

    @ApiOperation(value = "后台订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavOrderDTO.class)})
    @PostMapping("list")
    public ResultBody<UavOrderDTO> list(@RequestBody UavOrderQO uavOrderQO, HttpServletRequest request) {
        return uavOrderService.list(uavOrderQO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "个人订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavOrderDTO.class)})
    @PostMapping("listByUid")
    public ResultBody<UavOrderDTO> listByUid(@RequestBody UavOrderQO uavOrderQO, HttpServletRequest request) {
        return uavOrderService.listByUid(uavOrderQO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "支付", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("pay")
    public ResultBody pay(@RequestParam Integer id, HttpServletRequest request) {
        return uavOrderService.pay(id, this.getCurrentAccount(request), request);
    }

    @ApiOperation(value = "上传付款凭证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("upLoadPay")
    public ResultBody upLoadPay(@RequestBody UavOrderPayVO uavOrderPayVO) {
        return uavOrderService.upLoadPay(uavOrderPayVO);
    }

    @ApiOperation(value = "审核付款凭证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("checkPay")
    public ResultBody checkPay(@RequestBody UavOrderPayVO uavOrderPayVO) {
        return uavOrderService.checkPay(uavOrderPayVO);
    }

    @ApiOperation(value = "发货")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("send")
    public ResultBody send(@RequestBody UavOrderExpressVO param) {
        return uavOrderService.send(param);
    }

    @ApiOperation(value = "收货")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("receive")
    public ResultBody receive(@RequestParam Integer id, HttpServletRequest request) {
        return uavOrderService.receive(id, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "评价订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("remarkOrder")
    public ResultBody remarkOrder(@RequestBody UavOrderRemarkVO uavOrderRemarkVO) {
        return uavOrderService.remarkOrder(uavOrderRemarkVO);
    }

    @ApiOperation(value = "卖家备注")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("sellerRemark")
    public ResultBody sellerRemark(@RequestParam Integer id, @RequestParam(required = false) String content) {
        return uavOrderService.sellerRemark(id, content);
    }

    @ApiOperation(value = "订单状态列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavOrderStatusDTO.class)})
    @GetMapping("statusList")
    public ResultBody statusList() {
        return uavOrderService.statusList();
    }

    @ApiOperation(value = "平台确认订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("confirmOrder")
    public ResultBody confirmOrder(@RequestBody UavOrderVO uavOrderVO, HttpServletRequest request) {
        return uavOrderService.confirmOrder(uavOrderVO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "用户删除订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeUavOrder")
    public ResultBody removeUavOrder(@RequestParam Integer id) {
        return uavOrderService.removeUavOrder(id);
    }

    // 设置订单抽成比例

    // 微信完成回调-修改订单状态
}
