package com.mmc.oms.service.mall.impl;

import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.mall.PointsMallDao;
import com.mmc.oms.dao.mall.PointsOrderDao;
import com.mmc.oms.entity.mall.PointsMallDO;
import com.mmc.oms.entity.mall.PointsOrderDO;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.qo.GeneralQO;
import com.mmc.oms.model.qo.PointsMallOrderQO;
import com.mmc.oms.model.vo.mall.PointsOrderVO;
import com.mmc.oms.model.vo.mall.StatisticsBuyGoodsVO;
import com.mmc.oms.service.mall.PointMallService;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author Admin
 */
@Service
@Slf4j
@Transactional(rollbackFor = Exception.class)
@AllArgsConstructor
public class PointsMallServiceImpl implements PointMallService {
    private PointsMallDao pointsMallDao;
    private PointsOrderDao pointsOrderDao;

    private UserAppApi userAppApi;

    @Override
    public ResultBody insertMall(PointsMallDO pointsMallDO) {
        pointsMallDao.insert(pointsMallDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteMall(Integer id) {
        pointsMallDao.deleteByPrimaryKey(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateMall(PointsMallDO pointsMallDO) {
        pointsMallDao.updateByPrimaryKeySelective(pointsMallDO);
        return ResultBody.success();
    }

    /**
     * 获取积分商品详情
     *
     * @param id
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody getMallInfo(Integer id) {
        PointsMallDO pointsMallDO = pointsMallDao.selectByPrimaryKey(id);
        return ResultBody.success(pointsMallDO);
    }

    /**
     * 获取积分商品列表
     *
     * @param qo 参数
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody getMallList(GeneralQO qo) {
        int count = pointsMallDao.count();
        Integer pageNo = qo.getPageNo();
        if(count == 0){
            return ResultBody.success(PageResult.buildPage(pageNo,qo.getPageSize(),count,null));
        }
        qo.buildCurrentPage();
        List<PointsMallDO> pointsMallDOS = pointsMallDao.selectAll(qo);
        return ResultBody.success(PageResult.buildPage(pageNo,qo.getPageSize(),count,pointsMallDOS));
    }

    @Override
    public ResultBody insertPointsOrder(PointsOrderDO pointsOrderDO, HttpServletRequest request) {
        PointsMallDO pointsMallDO = pointsMallDao.selectByPrimaryKey(pointsOrderDO.getPointsMallId());
        int changePoint = -pointsMallDO.getNeedPoints();
        ResultBody resultBody = userAppApi.feignChangeUserPoints(request.getHeader("token"), request, changePoint, "购买积分商品");
        if(!"200".equals(resultBody.getCode())){
            return resultBody;
        }
        pointsOrderDao.insert(pointsOrderDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody getOrderList(PointsMallOrderQO qo) {

        int count = pointsOrderDao.countOrderList(qo);

        if(count == 0){
            return ResultBody.success(PageResult.buildPage(qo.getPageNo(),qo.getPageSize(),count,null));
        }
        Integer pageNo = qo.getPageNo();
        qo.buildCurrentPage();
        List<PointsOrderVO> orderList = pointsOrderDao.getOrderList(qo);

        return ResultBody.success(PageResult.buildPage(pageNo,qo.getPageSize(),count,orderList));
    }

    @Override
    public ResultBody updateGoodsOrder(PointsOrderDO param) {
        int i = pointsOrderDao.updateByPrimaryKeySelective(param);
        if(i == 0){
            return ResultBody.error("更新失败");
        }
        return ResultBody.success();
    }

    /**
     * 统计每个积分商品兑换次数
     *
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody getCountMall() {
        List<StatisticsBuyGoodsVO> countMall = pointsOrderDao.getCountMall();
        return ResultBody.success(countMall);
    }
}
