package com.mmc.oms.model.vo.uav;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author: zj
 * @Date: 2023/9/4 16:31
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UavOrderSkuVO implements Serializable {
    private static final long serialVersionUID = 6034392498890957390L;
    @ApiModelProperty("商品规格id")
    @NotNull(message = "商品规格id必传")
    private Integer priceStockId;
    @ApiModelProperty("商品规格")
    @NotNull(message = "商品规格必传")
    private String productSpec;
    @ApiModelProperty("购买数量")
    @NotNull(message = "购买数量图片必传")
    private Integer orderNum;
    @ApiModelProperty(value = "单价", hidden = true)
    private BigDecimal unitPrice;
    @ApiModelProperty("商品规格图片")
    @NotNull(message = "商品规格图片必传")
    private String skuImage;
    @ApiModelProperty("商品规格编号")
    private String skuNo;
    @ApiModelProperty("客户提交订单的单价")
    @NotNull(message = "价格必传")
    private BigDecimal salePrice;
}
