package com.mmc.oms.service.lease;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.dto.lease.LeaseOrderDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.lease.AddLeaseOrderVO;
import com.mmc.oms.model.vo.lease.LeaseOrderRefundVO;
import com.mmc.oms.model.vo.uav.UavOrderExpressVO;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/9/21 16:38
 * 概要：
 */
public interface LeaseOrderService {

    ResultBody<LeaseOrderDTO> addLeaseOrder(AddLeaseOrderVO param, BaseAccountDTO currentAccount);

    ResultBody detail(Integer id, BaseAccountDTO currentAccount) throws Exception;

    ResultBody close(LeaseOrderRefundVO leaseOrderRefundVO, String token);

    ResultBody<LeaseOrderDTO> list(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount);

    ResultBody<LeaseOrderDTO> listByUid(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount);

    ResultBody pay(Integer id, BaseAccountDTO currentAccount, HttpServletRequest request);

    ResultBody send(UavOrderExpressVO param);

    ResultBody receive(LeaseOrderRefundVO leaseOrderRefundVO, BaseAccountDTO currentAccount);

    ResultBody statusList();

    ResultBody removeLeaseOrder(Integer id);

    ResultBody giveBack(LeaseOrderRefundVO leaseOrderRefundVO, BaseAccountDTO currentAccount);

    ResultBody pfConfirmOrderWare(BaseAccountDTO currentAccount, LeaseOrderRefundVO param);
}
