package com.mmc.oms.model.dto.mall;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * author:zhenjie
 * Date:2022/11/23
 * time:16:10
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.dto.MallOrderPageDTO", description = "无人机城PC订单列表DTO")
public class MallOrderPageDTO implements Serializable {
    private static final long serialVersionUID = 56353980620113181L;
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单图片-第一个商品的主图")
    private String orderMainImg;

    @ApiModelProperty("订单名称-第一个商品的名称")
    private String orderName;

    @ApiModelProperty("商品总数量")
    private Integer totalBuyNum;

    @ApiModelProperty("订单金额")
    private BigDecimal orderAmount;

    @ApiModelProperty("订单状态码")
    private Integer statusCode;

    @ApiModelProperty("合同状态状态：状态:（0:等待用户签署、1：用户签署失败、2：等待甲方签署(用户签署成功) 3：用户签署失败、4：甲方签署成功、5：已完成")
    private Integer signStatus;

    @ApiModelProperty(value = "运营人员")
    private String operationName;

    @ApiModelProperty("运营id")
    private Integer operationId;

    @ApiModelProperty("订单交期")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone ="GMT+8")
    private Date deliveryTime;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("userAccountId")
    private Integer userAccountId;

    @ApiModelProperty("买家uid")
    private String uid;

    @ApiModelProperty("买家姓名")
    private String userName;

    @ApiModelProperty("买家手机号")
    private String phoneNum;

    @ApiModelProperty("0全款购买 1分期付款")
    private Integer payMethod;

    @ApiModelProperty(value = "合同签署方式,1:线上,0:线下")
    private Integer contractSignedWay;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    private Date createTime;

    @ApiModelProperty(value = "推荐人")
    private String recMallUserName;

    @ApiModelProperty(value = "所选规格")
    private List<OGSkuSpecDTO> ogSkuSpecDTOList;

    @ApiModelProperty(value = "订单备注,字符不超过600")
    private String remark;

    @ApiModelProperty(value = "管理员专用备注")
    private String mRemark;

    @ApiModelProperty(value = "付款期限")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    private Date creditPeriod;

    @ApiModelProperty(value = "买家认证企业")
    private String entName;

    @ApiModelProperty(value = "销售id")
    private Integer saleId;

    @ApiModelProperty(value = "销售名称")
    private String saleName;

    @ApiModelProperty(value = "分销商等级")
    private String tagName;

    @ApiModelProperty(value = "是否完成实名认证和法人认证")
    private Integer realNameAuth;

    @ApiModelProperty(value = "实际付款")
    private BigDecimal realPayAmount;

    @ApiModelProperty(value = "补贴金额")
    private BigDecimal subAmount;

    @ApiModelProperty(value = "共享人id")
    private Integer shareId;

    @ApiModelProperty(value = "共享状态  0是起始状态 100接受共享中 200已共享 300其他状态")
    private Integer shareStatus;

    @ApiModelProperty("减免金额")
    private BigDecimal deductAmount;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("实付金额")
    private BigDecimal realityAmount;

    @ApiModelProperty("订单关闭原因")
    private String shutReason;

    @ApiModelProperty("产品清单")
    private List<MallOrderProdListDTO> mallOrderProdListDTOList;
}
