package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavPurchaseOrderDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/9/11 13:23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-采购订单")
public class UavPurchaseOrderDO implements Serializable {
    private static final long serialVersionUID = -2874411492914226394L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "采购方id")
    private Integer backUserAccountId;
    @ApiModelProperty(value = "第三方商家用户id")
    private Integer thirdUserAccountId;
    @ApiModelProperty(value = "被关联订单id")
    private Integer uavOrderId;
    @ApiModelProperty(value = "订单金额")
    private BigDecimal orderAmount;
    @ApiModelProperty(value = "订单状态")
    private Integer statusCode;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "买家备注")
    private String userRemark;
    @ApiModelProperty(value = "卖家备注")
    private String sellerRemark;
    @ApiModelProperty("规格列表")
    private List<UavOrderSkuDO> skuDOS;

    public UavPurchaseOrderDTO buildUavPurchaseOrderDTO() {
        return UavPurchaseOrderDTO.builder().id(this.id).orderNo(this.orderNo).statusCode(this.statusCode).backUserAccountId(this.backUserAccountId)
                .thirdUserAccountId(this.thirdUserAccountId).uavOrderId(this.uavOrderId).orderAmount(this.orderAmount).statusCode(this.statusCode)
                .createTime(this.createTime).userRemark(this.userRemark).sellerRemark(this.sellerRemark).skuDTOList(CollectionUtils.isNotEmpty(skuDOS) ?
                       this.skuDOS.stream().map(UavOrderSkuDO::buildUavOrderSkuDTO).collect(Collectors.toList()) : null).build();
    }
}
