package com.mmc.oms.controller;

import com.mmc.oms.common.publicinterface.Insert;
import com.mmc.oms.common.publicinterface.Update;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.dto.mall.UserAddressDTO;
import com.mmc.oms.model.qo.mall.UserAddressQO;
import com.mmc.oms.model.vo.mall.UserAddressVO;
import com.mmc.oms.service.UserAddressService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/7 10:11
 */
@RestController
@RequestMapping("/user-address/")
@Api(tags = {"地址管理"})
public class UserAddressController extends BaseController {
    @Autowired
    private UserAddressService userAddressService;

    /**
     * 添加地址
     *
     * @param request
     * @param param
     * @return
     */
    @ApiOperation(value = "新增用户地址")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insert")
    public ResultBody insert(HttpServletRequest request, @RequestBody @Validated(Insert.class) UserAddressVO param) {
        return userAddressService.insert(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "编辑用户地址")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody update(@RequestBody @Validated(Update.class) UserAddressVO param, HttpServletRequest request) {
        return userAddressService.update(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "删除用户地址-根据id")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteById")
    public ResultBody deleteById(Integer id) {
        return userAddressService.deleteById(id);
    }

    @ApiOperation(value = "根据id查询地址")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAddressDTO.class)})
    @GetMapping("getUserAddressInfo")
    public ResultBody getUserAddressInfo(@RequestParam Integer userAddressId) {
        return ResultBody.success(userAddressService.getUserAddressInfo(userAddressId));
    }

    @ApiOperation(value = "查询用户地址列表-条件查询")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserAddressDTO.class)})
    @PostMapping("selectList")
    public ResultBody<List<UserAddressDTO>> selectList(@RequestBody UserAddressQO param, HttpServletRequest request) {
        return userAddressService.selectList(param, this.getCurrentAccount(request));
    }
}
