package com.mmc.oms.model.dto.user;

import com.mmc.oms.model.vo.CompanyInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 14:56
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BaseAccountDTO implements Serializable {
    private static final long serialVersionUID = -2979712090903806216L;

    @ApiModelProperty(value = "token")
    private String token;
    @ApiModelProperty(value = "当前账号id")
    private Integer userAccountId;
    @ApiModelProperty(value = "账号")
    private String accountNo;
    @ApiModelProperty(value = "账号uid")
    private String uid;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "0是后台管理 100客户端 小程序")
    private Integer portType;
    @ApiModelProperty(value = "后台账号单位信息")
    private CompanyInfoVO companyInfoVO;
    @ApiModelProperty(value = "角色信息")
    private RoleInfoDTO roleInfo;
    @ApiModelProperty(value = "小程序登录id")
    private Integer appUserAccountId;

}
