package com.mmc.oms.controller.lease;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.lease.LeaseOrderDTO;
import com.mmc.oms.model.dto.transtatus.TranStatusDicDTO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.lease.AddLeaseOrderVO;
import com.mmc.oms.model.vo.lease.LeaseOrderRefundVO;
import com.mmc.oms.model.vo.uav.UavOrderExpressVO;
import com.mmc.oms.service.lease.LeaseOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author: lw
 * @Date: 2023/9/21 16:29
 */
@Api(tags = {"最新版--租赁订单接口"})
@RestController
@RequestMapping("/lease/order/")
public class LeaseOrderController extends BaseController {

    @Resource
    private LeaseOrderService leaseOrderService;

    @ApiOperation(value = "提交订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @PostMapping("addLeaseOrder")
    public ResultBody<LeaseOrderDTO> addLeaseOrder(@RequestBody AddLeaseOrderVO param, HttpServletRequest request) {
        return leaseOrderService.addLeaseOrder(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @GetMapping("detail")
    public ResultBody<LeaseOrderDTO> detail(@RequestParam Integer id, HttpServletRequest request) throws Exception {
        return leaseOrderService.detail(id, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "买家申请退款（取消订单）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("close")
    public ResultBody close(@RequestBody LeaseOrderRefundVO leaseOrderRefundVO, HttpServletRequest request) {
        return leaseOrderService.close(leaseOrderRefundVO, this.getCurrentAccount(request).getToken());
    }

    @ApiOperation(value = "后台订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @PostMapping("list")
    public ResultBody<LeaseOrderDTO> list(@RequestBody UavOrderQO uavOrderQO, HttpServletRequest request) {
        return leaseOrderService.list(uavOrderQO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "个人订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseOrderDTO.class)})
    @PostMapping("listByUid")
    public ResultBody<LeaseOrderDTO> listByUid(@RequestBody UavOrderQO uavOrderQO, HttpServletRequest request) {
        return leaseOrderService.listByUid(uavOrderQO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "支付", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("pay")
    public ResultBody pay(@RequestParam Integer id, HttpServletRequest request) {
        return leaseOrderService.pay(id, this.getCurrentAccount(request), request);
    }

    @ApiOperation(value = "发货")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("send")
    public ResultBody send(@RequestBody UavOrderExpressVO param) {
        return leaseOrderService.send(param);
    }

    @ApiOperation(value = "用户收货")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("receive")
    public ResultBody receive(@RequestBody LeaseOrderRefundVO leaseOrderRefundVO, HttpServletRequest request) {
        return leaseOrderService.receive(leaseOrderRefundVO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "归还商品")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("giveBack")
    public ResultBody giveBack(@RequestBody LeaseOrderRefundVO leaseOrderRefundVO, HttpServletRequest request) {
        return leaseOrderService.giveBack(leaseOrderRefundVO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "平台确认归还")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("pfConfirmOrderWare")
    public ResultBody pfConfirmOrderWare(HttpServletRequest request, @RequestBody LeaseOrderRefundVO param) {
        return leaseOrderService.pfConfirmOrderWare(this.getCurrentAccount(request), param);
    }

    @ApiOperation(value = "订单状态列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TranStatusDicDTO.class)})
    @GetMapping("statusList")
    public ResultBody statusList() {
        return leaseOrderService.statusList();
    }

    @ApiOperation(value = "用户删除订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeLeaseOrder")
    public ResultBody removeLeaseOrder(@RequestParam Integer id) {
        return leaseOrderService.removeLeaseOrder(id);
    }

}
