package com.mmc.oms.model.dto.uav;

import com.mmc.oms.entity.uav.UavPurchaseOrderPayDO;
import com.mmc.oms.model.dto.ContractInfoDTO;
import com.mmc.oms.model.dto.kdn.KdnExpDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/9/11 13:30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "采购订单")
public class UavPurchaseOrderDTO implements Serializable {
    private static final long serialVersionUID = -4512219777300057765L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "用户订单编号")
    private String uavOrderNo;
    @ApiModelProperty(value = "采购方id")
    private Integer backUserAccountId;
    @ApiModelProperty(value = "第三方商家用户id")
    private Integer thirdUserAccountId;
    @ApiModelProperty(value = "第三方商家公司名称")
    private String companyName;
    @ApiModelProperty(value = "第三方商家公司电话")
    private String thirdPhoneNum;
    @ApiModelProperty(value = "被关联订单id")
    private Integer uavOrderId;
    @ApiModelProperty(value = "订单金额")
    private BigDecimal orderAmount;
    @ApiModelProperty(value = "订单状态")
    private Integer statusCode;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "买家备注")
    private String userRemark;
    @ApiModelProperty(value = "卖家备注")
    private String sellerRemark;

    @ApiModelProperty("订单规格列表")
    private List<UavOrderSkuDTO> skuDTOList;
    @ApiModelProperty("用户收货地址信息")
    private UavOrderExpressDTO uavOrderExpressDTO;
    @ApiModelProperty("付款凭证")
    private List<UavOrderPayDTO> uavOrderPayDTOS;
    @ApiModelProperty("合同签署信息")
    private ContractInfoDTO contractInfoDTO;
    @ApiModelProperty("支付凭证列表")
    private List<UavOrderPayDTO> payDTOS;
    @ApiModelProperty("支付凭证列表")
    private KdnExpDTO kdnExpDTO;

}
