package com.mmc.oms.service.mall.impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.client.PmsClient;
import com.mmc.oms.client.UserClient;
import com.mmc.oms.common.*;
import com.mmc.oms.common.publicinterface.Publicsher;
import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.CodeUtil;
import com.mmc.oms.dao.mall.AppMallOrderDao;
import com.mmc.oms.dao.mall.MallOrderDao;
import com.mmc.oms.dao.mall.ShoppingTrolleyDao;
import com.mmc.oms.entity.mall.*;
import com.mmc.oms.enums.OrderStatus;
import com.mmc.oms.model.dto.coupon.CouponUserDTO;
import com.mmc.oms.model.dto.coupon.CouponUserOrderDTO;
import com.mmc.oms.model.dto.mall.*;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.mall.MallOrderGoodsInfoQO;
import com.mmc.oms.model.qo.mall.MallShopCarQO;
import com.mmc.oms.model.vo.mall.ConfirmMallOrderVO;
import com.mmc.oms.model.vo.mall.ConfirmShopVO;
import com.mmc.oms.model.vo.coupon.CouponUserVO;
import com.mmc.oms.model.vo.mall.MallConfirmOrderVO;
import com.mmc.oms.service.UserAddressService;
import com.mmc.oms.service.mall.AppMallOrderService;
import com.mmc.oms.service.mall.MallOrderService;
import com.mmc.oms.util.SnowFlake;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * author:zhenjie
 * Date:2022/10/18
 * time:16:07
 */
@Service
@Slf4j
public class AppMallOrderServiceImpl implements AppMallOrderService {
    @Autowired
    private AppMallOrderDao appMallOrderDao;

    @Autowired
    private ShoppingTrolleyDao shoppingTrolleyDao;
//
//    @Autowired
//    private MallGoodsClient mallGoodsClient;

    @Autowired
    private MallOrderDao mallOrderDao;

    @Autowired
    private Publicsher publicsher;

    @Autowired
    private MallOrderService mallOrderService;

//    @Autowired
//    private MallUserPayClient mallUserPayClient;

//    @Autowired
//    private FddServletClient fddServletClient;

//    @Autowired
//    private UserAppApi userAppApi;

    @Autowired
    private UserClient userClient;

    @Autowired
    private UserAddressService userAddressService;
//
//    @Autowired
//    private PayAppApi payAppApi;
//
//    @Autowired
//    private PmsAppApi pmsAppApi;

    @Autowired
    private PmsClient pmsClient;

    @Override
    @Transactional
    public ResultBody addMallOrder(ConfirmMallOrderVO param, BaseAccountDTO cuser) throws Exception {
        //校验商品信息是否有改动
        //查找购物车信息
        //查询用户信息、渠道等级信息
        //根据购物车信息查询商品信息
        //校验商品有效性
        //根据购物车信息计算订单金额
        //添加总订单信息
        //添加订单sku信息
        //添加用户收货地址
        //修改购物车信息
        //订单金额精度
        if (CollectionUtils.isEmpty(param.getShopCarList())) {
            return ResultBody.error(ResultEnum.PARAM_DEFECT);
        }
        //查询用户信息
        //MallUserDTO muser = mallUserClient.feignGetSimpleUserInfo(cuser.getId());
        UserAccountSimpleDTO userAccountSimpleDTO = userClient.feignGetUserSimpleInfo(cuser.getUserAccountId(), null);
        if (StringUtils.isEmpty(userAccountSimpleDTO.getPhoneNum())) {
            return ResultBody.error(ResultEnum.AUTH_ACCOUNT_ERROR);
        }

        //对购物车id进行分类，产品或行业
        Set<Integer> prodIds = new HashSet<>();
        Set<Integer> indstIds = new HashSet<>();
        for (ConfirmShopVO confirmShopVO : param.getShopCarList() ){
            if (confirmShopVO.getDirectoryId().toString().equals("1")){
                prodIds.add(confirmShopVO.getShopCarId());
            }
            if (confirmShopVO.getDirectoryId().toString().equals("2")){
                indstIds.add(confirmShopVO.getShopCarId());
            }
        }
        if(indstIds.size() > 1){
            return ResultBody.error(ResultEnum.SHOP_CAR_SIZE_MORE_2);
        }
        List<MallProdShopCarDO> mallProdShopCarDOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(prodIds)){
            MallShopCarQO prodMallShopCarQO = new MallShopCarQO();
            prodMallShopCarQO.setUserAccountId(cuser.getUserAccountId());
            prodMallShopCarQO.setCarIds(prodIds);
            mallProdShopCarDOS = shoppingTrolleyDao.listMallProdShopCar(prodMallShopCarQO);
            log.info("购物车参数mallProdShopCarDOS==>[{}]", JSONObject.toJSONString(mallProdShopCarDOS));
        }
        List<MallIndstShopCarDO> mallIndstShopCarDOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(indstIds)){
            MallShopCarQO indstMallShopCarQO = new MallShopCarQO();
            indstMallShopCarQO.setUserAccountId(cuser.getUserAccountId());
            indstMallShopCarQO.setCarIds(indstIds);
            mallIndstShopCarDOS = shoppingTrolleyDao.listMallIndstShopCar(indstMallShopCarQO);
            log.info("购物车参数mallIndstShopCarDOS==>[{}]", JSONObject.toJSONString(mallIndstShopCarDOS));
        }
        if(CollectionUtils.isEmpty(mallProdShopCarDOS) && CollectionUtils.isEmpty(mallIndstShopCarDOS)){
            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
        }
        return this.confirmMallOrder(mallProdShopCarDOS, mallIndstShopCarDOS, param, userAccountSimpleDTO);
    }

    @Override
    public ResultBody<ConfirmGoodsInfoDTO> confirmShop(List<MallProdShopCarDO> mallProdShopCarDOS, List<MallIndstShopCarDO> mallIndstShopCarDOS, UserAccountSimpleDTO userAccountSimpleDTO) {

        //返回的结果
        ConfirmGoodsInfoDTO confirmGoodsInfoDTO = new ConfirmGoodsInfoDTO();

        //查询商品信息，价格信息
        MallOrderGoodsInfoQO mallOrderGoodsInfoQO = new MallOrderGoodsInfoQO();
        mallOrderGoodsInfoQO.setUserAccountId(userAccountSimpleDTO.getId());
        mallOrderGoodsInfoQO.setCooperationTagId(userAccountSimpleDTO.getCooperationTagId());
        //订单金额
        BigDecimal orderAmount = BigDecimal.ZERO;
        //产品sku信息
        List<OrderGoodsProdDTO> orderGoodsProdDTOList = new ArrayList<>();
        //行业sku信息
        List<OrderGoodsIndstDTO> orderGoodsIndstDTOList = new ArrayList<>();

        //处理产品商品
        if(!CollectionUtils.isEmpty(mallProdShopCarDOS)){
            confirmGoodsInfoDTO.setDirectoryId(1);
            //设置查询商品信息的参数，mallProdSkuInfoSpecId
            mallOrderGoodsInfoQO.setMallProdSkuSpecIds(new HashSet<>());
            for(MallProdShopCarDO mallProdShopCarDO : mallProdShopCarDOS){
                mallOrderGoodsInfoQO.getMallProdSkuSpecIds().addAll(mallProdShopCarDO.getShopCarDetailDOS().stream().map(d -> d.getMallProdSkuInfoSpecId()).collect(Collectors.toSet()));
            }
            //设置mallProdSkuInfoSpecId对应的购物车详情id
            Map<Integer, Integer> prodSkuSpecIdCarMap = new HashMap<>();
            for (MallProdShopCarDO mallProdShopCarDO : mallProdShopCarDOS) {
                for (MallProdShopCarDetailDO mallProdShopCarDetailDO : mallProdShopCarDO.getShopCarDetailDOS()){
                    //设置产品商品小规格对应的购物车详情id
                    prodSkuSpecIdCarMap.put(mallProdShopCarDetailDO.getMallProdSkuInfoSpecId(), mallProdShopCarDetailDO.getId());
                }
            }
            //查询商品详细信息
            orderGoodsProdDTOList = pmsClient.feignListProdGoodsSkuInfo(mallOrderGoodsInfoQO, null);

            //----------------------判空
            if(CollectionUtils.isEmpty(orderGoodsProdDTOList)){
                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
            }
            //判断是否有无效的产品商品
            for (OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
                if(orderGoodsProdDTO.getDeleted() == 0 && orderGoodsProdDTO.getShelfStatus() == 1){
                    for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : orderGoodsProdDTO.getOrderGoodsProdDetailDTOS()){
                        if( !(orderGoodsProdDetailDTO.getSpecDeleted() == 0 && orderGoodsProdDetailDTO.getSkuInfoDeleted() == 0 && orderGoodsProdDetailDTO.getSkuSpecDeleted() == 0)){
                            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                        }
                    }
                }else {
                    return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                }
            }
            List<OrderGoodsProdDO> orderGoodsProdDOS = this.generatedProdOrder(mallProdShopCarDOS, orderGoodsProdDTOList);
            if(orderGoodsProdDOS == null){
                return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
            }
            //把每个商品所有规格金额加起来，订单金额
            for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOS){
                orderAmount = orderAmount.add(orderGoodsProdDO.getGoodsAmount());
            }

            //根据品牌id，查询个人拥有的优惠券并做处理
//            List<CouponUserOrderDTO> couponUserOrderDTOList = this.findUserCoupon(orderGoodsProdDOS, muser.getId(), orderAmount);
//            List<CouponUserOrderDTO> usable = couponUserOrderDTOList.stream().filter(d->"usable".equals(d.getValidStr())).collect(Collectors.toList());
//            List<CouponUserOrderDTO> unusable = couponUserOrderDTOList.stream().filter(d->"unusable".equals(d.getValidStr())).collect(Collectors.toList());
//            confirmGoodsInfoDTO.setUsableCoupon(usable);
//            confirmGoodsInfoDTO.setDisableCoupon(unusable);

            List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList = new ArrayList<>();
            for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOS){
                if(!CollectionUtils.isEmpty(orderGoodsProdDO.getOrderGoodsProdDetailDOList())){
                    for (OrderGoodsProdDetailDO orderGoodsProdDetailDO : orderGoodsProdDO.getOrderGoodsProdDetailDOList()){
                        //设置商品订单id
                        orderGoodsProdDetailDO.setOrderGoodsProdId(orderGoodsProdDO.getId());
                        orderGoodsProdDetailDO.setMallProdShopCarDetailId(prodSkuSpecIdCarMap.get(orderGoodsProdDetailDO.getMallProdSkuInfoSpecId()));
                        orderGoodsProdDetailDOList.add(orderGoodsProdDetailDO);
                    }
                }
            }
            List<OrderGoodsProdDetailDTO> collect = orderGoodsProdDetailDOList.stream().map(d -> d.buildOrderGoodsProdDetailDTO()).collect(Collectors.toList());
            confirmGoodsInfoDTO.setOrderGoodsProdDetailDTOS(collect);
        }

        //处理行业商品，过程类似产品商品
        if(!CollectionUtils.isEmpty(mallIndstShopCarDOS)){
            confirmGoodsInfoDTO.setDirectoryId(2);
            mallOrderGoodsInfoQO.setMallIndstSkuSpecIds(new HashSet<>());
            for (MallIndstShopCarDO mallIndstShopCarDO : mallIndstShopCarDOS){
                mallOrderGoodsInfoQO.getMallIndstSkuSpecIds().addAll(mallIndstShopCarDO.getShopCarDetailDOS().stream().map(d->d.getMallIndstSkuInfoSpecId()).collect(Collectors.toSet()));
            }
            Map<Integer, Integer> indstSkuSpecIdCarMap = new HashMap<>();
            for (MallIndstShopCarDO mallIndstShopCarDO : mallIndstShopCarDOS) {
                for (MallIndstShopCarDetailDO mallIndstShopCarDetailDO : mallIndstShopCarDO.getShopCarDetailDOS()){
                    //设置行业小规格对应的购物车详情id
                    indstSkuSpecIdCarMap.put(mallIndstShopCarDetailDO.getMallIndstSkuInfoSpecId(), mallIndstShopCarDetailDO.getId());
                }
            }
            orderGoodsIndstDTOList = pmsClient.feignListIndstGoodsSkuInfo(mallOrderGoodsInfoQO, null);
            if(CollectionUtils.isEmpty(orderGoodsIndstDTOList)){
                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
            }
            //判断是否有无效的行业商品
            for (OrderGoodsIndstDTO orderGoodsIndstDTO : orderGoodsIndstDTOList){
                if(orderGoodsIndstDTO.getValid()){
                    for (OrderGoodsIndstDetailDTO orderGoodsIndstDetailDTO : orderGoodsIndstDTO.getOrderGoodsIndstDetailDTOS()){
                        if(!orderGoodsIndstDetailDTO.getValid()){
                            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                        }
                    }
                }else {
                    return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                }
            }
            List<OrderGoodsIndstDO> orderGoodsIndstDOS = this.generatedIndstOrder(mallIndstShopCarDOS, orderGoodsIndstDTOList);
            if(orderGoodsIndstDOS == null){
                return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
            }
            //订单金额
            for (OrderGoodsIndstDO orderGoodsIndstDO : orderGoodsIndstDOS){
                orderAmount = orderAmount.add(orderGoodsIndstDO.getGoodsAmount());
            }
            //处理方案对应的产品清单
            List<OrderGoodsIndstProdListDO> industryProductList = new ArrayList<>();
            for (OrderGoodsIndstDO orderGoodsIndstDO : orderGoodsIndstDOS){
                if(!CollectionUtils.isEmpty(orderGoodsIndstDO.getOrderGoodsIndstDetailDOS())){
                    for (OrderGoodsIndstDetailDO orderGoodsIndstDetailDO : orderGoodsIndstDO.getOrderGoodsIndstDetailDOS()){
                        orderGoodsIndstDetailDO.setOrderGoodsIndstId(orderGoodsIndstDO.getId());
                        orderGoodsIndstDetailDO.setMallIndstShopCarDetailId(indstSkuSpecIdCarMap.get(orderGoodsIndstDetailDO.getMallIndstSkuInfoSpecId()));
                    }
                    for (OrderGoodsIndstDetailDO orderGoodsIndstDetailDO : orderGoodsIndstDO.getOrderGoodsIndstDetailDOS()){
                        if(!CollectionUtils.isEmpty(orderGoodsIndstDetailDO.getOrderGoodsIndstProdListDOS())){
                            for (OrderGoodsIndstProdListDO orderGoodsIndstProdListDO : orderGoodsIndstDetailDO.getOrderGoodsIndstProdListDOS()){
                                orderGoodsIndstProdListDO.setOrderGoodsIndstDetailId(orderGoodsIndstDetailDO.getMallIndstShopCarDetailId());
                                industryProductList.add(orderGoodsIndstProdListDO);
                            }
                        }
                    }
                }
            }
            List<OrderGoodsIndstProdListDTO> collect = industryProductList.stream().map(d -> d.buildOrderGoodsIndstProdListDTO()).collect(Collectors.toList());
            confirmGoodsInfoDTO.setOrderGoodsIndstProdListDTOS(collect);
        }
        confirmGoodsInfoDTO.setOrderAmount(orderAmount);
        UUID uuid = UUID.randomUUID();
        log.info("线程id[{}],muser==>[{}],mallProdShopCarDOS==>[{}],orderGoodsIndstDTOList==>[{}],confirmGoodsInfoDTO==>[{}]",uuid, JSONObject.toJSONString(userAccountSimpleDTO), JSONObject.toJSONString(mallProdShopCarDOS), JSONObject.toJSONString(orderGoodsIndstDTOList), JSONObject.toJSONString(confirmGoodsInfoDTO));
        return ResultBody.success(confirmGoodsInfoDTO);
    }

    private List<CouponUserOrderDTO> findUserCoupon(List<OrderGoodsProdDO> orderGoodsProdDOList, Integer userAccountId, BigDecimal orderAmount) {
        /**
         * 非VIP规则
         * A.多张非活动券，使用优惠最高的一张；
         * B.多张活动券，最多叠加2张；*******暂时不做*******，需要把优惠均摊到每个
         * C.活动券和非活动券都有，使用优惠最高的一张；
         *
         * VIP规则？
         * 可以多张叠加，在订单总价格优惠
         */
        Set<Integer> brandIds = new HashSet<>();
        Map<Integer, BigDecimal> brandPriceMap = new HashMap<>();
        for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOList) {
            for (OrderGoodsProdDetailDO orderGoodsProdDetailDO : orderGoodsProdDO.getOrderGoodsProdDetailDOList()) {
                if ( orderGoodsProdDetailDO.getBrandInfoId() == null ){
                    continue;
                }
                //获取规格的品牌id
                brandIds.add(orderGoodsProdDetailDO.getBrandInfoId());
                //计算各品牌总价格
                if(brandPriceMap.get(orderGoodsProdDetailDO.getBrandInfoId()) == null){
                    System.out.println("brandPrice1----->" + JSONObject.toJSON(orderGoodsProdDetailDO.getSkuSpecAmount()));
                    brandPriceMap.put(orderGoodsProdDetailDO.getBrandInfoId(), orderGoodsProdDetailDO.getSkuSpecAmount());
                }else {
                    System.out.println("brandPrice2----->" + JSONObject.toJSON(orderGoodsProdDetailDO.getSkuSpecAmount()));
                    brandPriceMap.put(orderGoodsProdDetailDO.getBrandInfoId(), brandPriceMap.get(orderGoodsProdDetailDO.getBrandInfoId()).add(orderGoodsProdDetailDO.getSkuSpecAmount()));
                    //brandPriceMap.get(orderGoodsProdDetailDO.getBrandInfoId()).add(orderGoodsProdDetailDO.getSkuSpecAmount());
                }
            }
        }

        System.out.println("brandPriceMap----->" + JSONObject.toJSON(brandPriceMap));
        System.out.println("brandIds----->" + JSONObject.toJSON(brandIds));

        List<Integer> listBrandIds = new ArrayList<>(brandIds);
        //获取用户所有优惠券
//        List<CouponUserOrderDTO> couponUserOrderDTOList = mallUserPayClient.feignCoupons(listBrandIds, userAccountId);
        List<CouponUserOrderDTO> couponUserOrderDTOList = null;
        couponUserOrderDTOList.removeIf(d->d.getStatus() == 1);
        //遍历每张可用的优惠券
        for (CouponUserOrderDTO couponUserOrderDTO : couponUserOrderDTOList) {
            couponUserOrderDTO.setMinPrice(couponUserOrderDTO.getMinPrice() == null ? BigDecimal.ZERO : couponUserOrderDTO.getMinPrice());
            System.out.println(couponUserOrderDTO.toString());
            if(couponUserOrderDTO.getValidStr().equals("usable")){
                //处理品牌券
                if (couponUserOrderDTO.getPrimaryKey() != null && couponUserOrderDTO.getPrimaryKey().length() > 0){
                    System.out.println("PrimaryKey:" + couponUserOrderDTO.getPrimaryKey());
                    couponUserOrderDTO.setBrandIds(Arrays.asList(couponUserOrderDTO.getPrimaryKey().split(",")));
                    System.out.println("setBrandIds:" + couponUserOrderDTO.getBrandIds());
                    BigDecimal discountPrice = BigDecimal.ZERO;
                    //判断有效的
                    //按照优惠券包含的品牌，计算这个优惠券可以打折多少(这个券可以打折的金额)
//                    brandPriceMap.forEach((key, value)->{
//                        System.out.println("key:" + key);
//                        if(couponUserOrderDTO.getBrandIds().contains(key.toString()) && couponUserOrderDTO.getUseType().equals(2)){
//                            System.out.println("add value:" + value);
//                            discountPrice.add(value);
//                            System.out.println("discountPrice:" + discountPrice);
//                        }
//                    });
                    for (Integer key : brandPriceMap.keySet()){
                        if (key == null){
                            continue;
                        }
                        if (couponUserOrderDTO.getBrandIds().contains(key.toString()) && couponUserOrderDTO.getUseType().equals(2)){
                            discountPrice = discountPrice.add(brandPriceMap.get(key));
                        }
                    }
                    System.out.println("discountPrice:" + discountPrice);
                    //说明这个券是品牌券（这张券可以对多少金额进行打折）
                    if (discountPrice.compareTo(BigDecimal.ZERO) > 0){

                        if(couponUserOrderDTO.getCouponType().equals(1)){
                            //折扣券
                            //根据优惠规则进行优惠
                            if (couponUserOrderDTO.getMinPrice().compareTo(discountPrice) <= 0) {
                                //折扣的金额
                                BigDecimal discountMoney = BigDecimal.ONE.subtract(couponUserOrderDTO.getCouponDiscount().multiply(BigDecimal.valueOf(0.1))).multiply(discountPrice);
                                //看是否有折扣限制
                                if (couponUserOrderDTO.getPreferentialLimit() == null){
                                    couponUserOrderDTO.setDiscountCouponPrice(discountMoney);
                                }else {
                                    //不能超过最高优惠
                                    couponUserOrderDTO.setDiscountCouponPrice(discountMoney.compareTo(couponUserOrderDTO.getPreferentialLimit()) > 0 ? couponUserOrderDTO.getPreferentialLimit() : discountMoney);
                                }
                            }
                        }else if (couponUserOrderDTO.getCouponType().equals(2)){
                            //满减券
                            if (couponUserOrderDTO.getMinPrice().compareTo(discountPrice) <= 0) {
                                couponUserOrderDTO.setDiscountCouponPrice(couponUserOrderDTO.getCouponMoney());
                            }
                        }else if (couponUserOrderDTO.getCouponType().equals(3)){
                            //无门槛券，分为未使用和使用中
                            if (couponUserOrderDTO.getStatus().equals(0)){
                                //未使用的优惠券
                                if (couponUserOrderDTO.getCouponMoney().compareTo(discountPrice) > 0){
                                    couponUserOrderDTO.setDiscountCouponPrice(discountPrice);
                                }else {
                                    couponUserOrderDTO.setDiscountCouponPrice(couponUserOrderDTO.getCouponMoney());
                                }
                            }else {
                                //使用中的优惠券，使用中的优惠券判断剩余余额就好
                                if (couponUserOrderDTO.getRemainingBalance().compareTo(discountPrice) > 0){
                                    couponUserOrderDTO.setDiscountCouponPrice(discountPrice);
                                }else {
                                    couponUserOrderDTO.setDiscountCouponPrice(couponUserOrderDTO.getRemainingBalance());
                                }
                            }
                        }
                    }
                }

                //VIP券可以直接减总价格
                if(couponUserOrderDTO.getUseType().equals(1)){
                    if (couponUserOrderDTO.getStatus().equals(0)){
                        couponUserOrderDTO.setDiscountCouponPrice(couponUserOrderDTO.getCouponMoney());
                    }else {
                        couponUserOrderDTO.setDiscountCouponPrice(couponUserOrderDTO.getRemainingBalance());
                    }
                }

            }
        }

        //把打折金额为0的优惠券设置为不可用unusable，无门槛只显示剩余金额
        couponUserOrderDTOList.forEach(d->{
            if (d.getDiscountCouponPrice() == null || d.getDiscountCouponPrice().compareTo(BigDecimal.ZERO) == 0){
                d.setDiscountCouponPrice(BigDecimal.ZERO);
                d.setValidStr("unusable");
            }
            if (d.getUseType().equals(1) || d.getUseType().equals(2) && d.getCouponType().equals(3) ){
                if (d.getStatus().equals(4)){
                    d.setCouponMoney(d.getRemainingBalance());
                }
            }
        });
        BigDecimal finalDiscount = BigDecimal.ZERO;
        //设置最高优惠的券
        if (couponUserOrderDTOList.size() > 0){
            couponUserOrderDTOList.sort(Comparator.comparing(CouponUserOrderDTO::getDiscountCouponPrice).reversed());
            for (CouponUserOrderDTO couponUserOrderDTO : couponUserOrderDTOList) {
                if (couponUserOrderDTO.getUseType().equals(2) && couponUserOrderDTO.getValidStr().equals("usable")){
                    couponUserOrderDTO.setRecommend(1);
                    finalDiscount = finalDiscount.add(couponUserOrderDTO.getDiscountCouponPrice());
                    break;
                }
            }
        }
        for (CouponUserOrderDTO couponUserOrderDTO : couponUserOrderDTOList) {
            if (couponUserOrderDTO.getUseType().equals(1) && couponUserOrderDTO.getValidStr().equals("usable")){
                if (finalDiscount.compareTo(orderAmount) >= 0){
                    break;
                }
                finalDiscount = finalDiscount.add(couponUserOrderDTO.getDiscountCouponPrice());
                couponUserOrderDTO.setRecommend(1);
            }
        }
        return couponUserOrderDTOList;
    }

    @Override
    public PageResult listAPPPage(Integer pageNo, Integer pageSize, String keyword, Integer showType, String orderType, BaseAccountDTO currentAccount, String token) {
        List<Integer> statusCodes = this.getOrderStatusByShowType(showType);
        int count = mallOrderDao.countAppPageOrder(keyword, orderType, statusCodes, currentAccount.getUserAccountId());
        if (count == 0) {
            return PageResult.buildPage(pageNo, pageSize, count);
        }
        List<MallOrderDO> orders = mallOrderDao.listAppPageAmOrder((pageNo - 1) * pageSize, pageSize, keyword, orderType, statusCodes, currentAccount.getUserAccountId());
        List<MallOrderPageDTO> mallOrderPageDTOList = mallOrderService.buildMallOrderPageDTO(orders, token);
        //需要处理所选规格
        List<Integer> orderIds = orders.stream().map(MallOrderDO::getId).collect(Collectors.toList());
        List<MallOrderSimpleDO> mallOrderSimpleDOList = appMallOrderDao.listMallOrderSkuSpec(orderIds);
        List<MallOrderPageDTO> collect = mallOrderPageDTOList.stream().map(d -> {
            for (MallOrderSimpleDO mallOrderSimpleDO : mallOrderSimpleDOList) {
                if (!CollectionUtils.isEmpty(mallOrderSimpleDO.getOgSkuSpecDOList()) && mallOrderSimpleDO.getId().equals(d.getId())) {
                    List<OGSkuSpecDTO> ogSkuSpecDTOList = mallOrderSimpleDO.getOgSkuSpecDOList().stream().map(OGSkuSpecDO::buildOGSkuSpecDTO).collect(Collectors.toList());
                    d.setOgSkuSpecDTOList(ogSkuSpecDTOList);
                    break;
                }
            }
            return d;
        }).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, pageSize, count, collect);
    }

    @Transactional
    public ResultBody confirmMallOrder(List<MallProdShopCarDO> mallProdShopCarDOS, List<MallIndstShopCarDO> mallIndstShopCarDOS, ConfirmMallOrderVO param, UserAccountSimpleDTO user) throws Exception {
        //查询收货地址
        UserAddressDTO userAddressDTO = userAddressService.getUserAddressInfo(param.getUserAddressId());

        //查询商品信息，价格信息
        MallOrderGoodsInfoQO mallOrderGoodsInfoQO = new MallOrderGoodsInfoQO();
        mallOrderGoodsInfoQO.setUserAccountId(user.getId());
        mallOrderGoodsInfoQO.setCooperationTagId(user.getCooperationTagId());
        //订单金额
        BigDecimal orderAmount = BigDecimal.ZERO;
        //推荐人订单总价
        BigDecimal rcdOrderAmount = BigDecimal.ZERO;
        //产品sku信息
        List<OrderGoodsProdDTO> orderGoodsProdDTOList = new ArrayList<>();
        //行业sku信息
        List<OrderGoodsIndstDTO> orderGoodsIndstDTOList = new ArrayList<>();
        //生成总订单id
        SnowFlake snowFlake = new SnowFlake(2, 3);
        Integer orderId = null;
        String orderNo = CodeUtil.uavOrderCode();
        BigDecimal couponDiscount = BigDecimal.ZERO;
        // 多个购物车只取最后一个，有则有，没有则没有
        Integer recMallUserId = null;

        //查询推荐人信息
        //Integer rcdMallUserId = mallUserPayClient.feignGetSuperiorRef(user.getId());


        //处理产品商品
        if(!CollectionUtils.isEmpty(mallProdShopCarDOS)){
            recMallUserId = mallProdShopCarDOS.get(mallProdShopCarDOS.size()-1).getRecMallUserId();
            //设置查询商品信息的参数，mallProdSkuInfoSpecId
            mallOrderGoodsInfoQO.setMallProdSkuSpecIds(new HashSet<>());
            for(MallProdShopCarDO mallProdShopCarDO : mallProdShopCarDOS){
                mallOrderGoodsInfoQO.getMallProdSkuSpecIds().addAll(mallProdShopCarDO.getShopCarDetailDOS().stream().map(d -> d.getMallProdSkuInfoSpecId()).collect(Collectors.toSet()));
            }
            //设置mallProdSkuInfoSpecId对应的购物车详情id
            Map<Integer, Integer> prodSkuSpecIdCarMap = new HashMap<>();
            for (MallProdShopCarDO mallProdShopCarDO : mallProdShopCarDOS) {
                for (MallProdShopCarDetailDO mallProdShopCarDetailDO : mallProdShopCarDO.getShopCarDetailDOS()){
                    //设置产品商品小规格对应的购物车详情id
                    prodSkuSpecIdCarMap.put(mallProdShopCarDetailDO.getMallProdSkuInfoSpecId(), mallProdShopCarDetailDO.getId());
                }
            }
            //查询商品详细信息
            orderGoodsProdDTOList = pmsClient.feignListProdGoodsSkuInfo(mallOrderGoodsInfoQO, null);
            //----------------------判空
            if(CollectionUtils.isEmpty(orderGoodsProdDTOList)){
                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
            }
            //判断是否有无效的产品商品
            for (OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
                if(orderGoodsProdDTO.getDeleted() == 0 && orderGoodsProdDTO.getShelfStatus() == 1){
                    for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : orderGoodsProdDTO.getOrderGoodsProdDetailDTOS()){
                        if( !(orderGoodsProdDetailDTO.getSpecDeleted() == 0 && orderGoodsProdDetailDTO.getSkuInfoDeleted() == 0 && orderGoodsProdDetailDTO.getSkuSpecDeleted() == 0)){
                            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                        }
                    }
                }else {
                    return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                }
            }
            List<OrderGoodsProdDO> orderGoodsProdDOS = this.generatedProdOrder(mallProdShopCarDOS, orderGoodsProdDTOList);
            if(orderGoodsProdDOS == null){
                return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
            }
            //把每个商品所有规格金额加起来，订单金额
            for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOS){
                orderAmount = orderAmount.add(orderGoodsProdDO.getGoodsAmount());
            }

//            //查询推荐人订单金额
//            if (rcdMallUserId != null){
//                rcdOrderAmount = this.getRcdMallOrderAmount(1, mallProdShopCarDOS, null, rcdMallUserId, mallOrderGoodsInfoQO);
//            }

            List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList = new ArrayList<>();
            for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOS){
                //设置订单id
                orderGoodsProdDO.setOrderId(orderId);
            }

            //插入产品商品
            appMallOrderDao.batchInsertOrderGoodsProdDO(orderGoodsProdDOS);
            for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOS){
                if(!CollectionUtils.isEmpty(orderGoodsProdDO.getOrderGoodsProdDetailDOList())){
                    for (OrderGoodsProdDetailDO orderGoodsProdDetailDO : orderGoodsProdDO.getOrderGoodsProdDetailDOList()){
                        //设置商品订单id
                        orderGoodsProdDetailDO.setOrderGoodsProdId(orderGoodsProdDO.getId());
                        orderGoodsProdDetailDO.setMallProdShopCarDetailId(prodSkuSpecIdCarMap.get(orderGoodsProdDetailDO.getMallProdSkuInfoSpecId()));
                        orderGoodsProdDetailDOList.add(orderGoodsProdDetailDO);
                    }
                }
            }
            //couponDiscount = discountProduct(orderGoodsProdDetailDOList, param.getCouponIds(), orderId, orderNo, orderAmount);

//            if (!CollectionUtils.isEmpty(param.getCouponIds())){
//                MallDiscountInfoDTO mallDiscountInfoDTO = discountProduct(orderGoodsProdDetailDOList, param.getCouponIds(), orderId, orderNo, orderAmount);
//                couponDiscount = mallDiscountInfoDTO.getAllDiscount();
//                //插入使用优惠券信息
//                if (mallDiscountInfoDTO.getCouponUserVOS() != null){
//                    List<MallOrderCouponDO> orderCouponDOS = new ArrayList<>();
//                    for (CouponUserVO couponUserVO : mallDiscountInfoDTO.getCouponUserVOS()) {
//                        MallOrderCouponDO orderCouponDO = new MallOrderCouponDO(couponUserVO);
//                        orderCouponDOS.add(orderCouponDO);
//                    }
//                    log.info("提交用户使用优惠券couponUserVOS------>", JSONObject.toJSON(mallDiscountInfoDTO.getCouponUserVOS()));
//                    //抵扣优惠券
//                    Boolean aBoolean = mallUserPayClient.feignUpMine(mallDiscountInfoDTO.getCouponUserVOS());
//                    if (!aBoolean){
//                        throw new BizException("抵消优惠券报错！");
//                    }
//                    appMallOrderDao.batchInsertOrderCoupon(orderCouponDOS);
//                }
//            }

            //批量插入产品商品规格
            appMallOrderDao.batchInsertOrderGoodsProdDetailDO(orderGoodsProdDetailDOList);
            //修改购物车状态
            shoppingTrolleyDao.updateProductShopCarStatus(mallProdShopCarDOS);
        }

        //处理行业商品，过程类似产品商品
        if(!CollectionUtils.isEmpty(mallIndstShopCarDOS)){
            recMallUserId = mallIndstShopCarDOS.get(mallIndstShopCarDOS.size()-1).getRecMallUserId();
            mallOrderGoodsInfoQO.setMallIndstSkuSpecIds(new HashSet<>());
            for (MallIndstShopCarDO mallIndstShopCarDO : mallIndstShopCarDOS){
                mallOrderGoodsInfoQO.getMallIndstSkuSpecIds().addAll(mallIndstShopCarDO.getShopCarDetailDOS().stream().map(d->d.getMallIndstSkuInfoSpecId()).collect(Collectors.toSet()));
            }
            Map<Integer, Integer> indstSkuSpecIdCarMap = new HashMap<>();
            for (MallIndstShopCarDO mallIndstShopCarDO : mallIndstShopCarDOS) {
                for (MallIndstShopCarDetailDO mallIndstShopCarDetailDO : mallIndstShopCarDO.getShopCarDetailDOS()){
                    //设置行业小规格对应的购物车详情id
                    indstSkuSpecIdCarMap.put(mallIndstShopCarDetailDO.getMallIndstSkuInfoSpecId(), mallIndstShopCarDetailDO.getId());
                }
            }
            orderGoodsIndstDTOList = pmsClient.feignListIndstGoodsSkuInfo(mallOrderGoodsInfoQO, null);
            if(CollectionUtils.isEmpty(orderGoodsIndstDTOList)){
                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
            }
            //判断是否有无效的行业商品
            for (OrderGoodsIndstDTO orderGoodsIndstDTO : orderGoodsIndstDTOList){
                if(orderGoodsIndstDTO.getValid()){
                    for (OrderGoodsIndstDetailDTO orderGoodsIndstDetailDTO : orderGoodsIndstDTO.getOrderGoodsIndstDetailDTOS()){
                        if(!orderGoodsIndstDetailDTO.getValid()){
                            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                        }
                    }
                }else {
                    return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                }
            }
            List<OrderGoodsIndstDO> orderGoodsIndstDOS = this.generatedIndstOrder(mallIndstShopCarDOS, orderGoodsIndstDTOList);
            if(orderGoodsIndstDOS == null){
                return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
            }
            //订单金额
            for (OrderGoodsIndstDO orderGoodsIndstDO : orderGoodsIndstDOS){
                orderAmount = orderAmount.add(orderGoodsIndstDO.getGoodsAmount());
            }

            //查询推荐人订单金额
//            if (rcdMallUserId != null){
//                rcdOrderAmount = this.getRcdMallOrderAmount(2, null, mallIndstShopCarDOS, rcdMallUserId, mallOrderGoodsInfoQO);
//            }

            //插入行业商品
            for (OrderGoodsIndstDO orderGoodsIndstDO : orderGoodsIndstDOS){
                //设置订单id
                orderGoodsIndstDO.setOrderId(orderId);
            }
            appMallOrderDao.batchInsertOrderGoodsIndstDO(orderGoodsIndstDOS);
            //处理方案对应的产品清单
            List<OrderGoodsIndstProdListDO> industryProductList = new ArrayList<>();
            for (OrderGoodsIndstDO orderGoodsIndstDO : orderGoodsIndstDOS){
                if(!CollectionUtils.isEmpty(orderGoodsIndstDO.getOrderGoodsIndstDetailDOS())){
                    for (OrderGoodsIndstDetailDO orderGoodsIndstDetailDO : orderGoodsIndstDO.getOrderGoodsIndstDetailDOS()){
                        orderGoodsIndstDetailDO.setOrderGoodsIndstId(orderGoodsIndstDO.getId());
                        orderGoodsIndstDetailDO.setMallIndstShopCarDetailId(indstSkuSpecIdCarMap.get(orderGoodsIndstDetailDO.getMallIndstSkuInfoSpecId()));
                    }
                    //分批次插入行业商品规格
                    appMallOrderDao.batchInsertOrderGoodsIndstDetailDO(orderGoodsIndstDO.getOrderGoodsIndstDetailDOS());
                    for (OrderGoodsIndstDetailDO orderGoodsIndstDetailDO : orderGoodsIndstDO.getOrderGoodsIndstDetailDOS()){
                        if(!CollectionUtils.isEmpty(orderGoodsIndstDetailDO.getOrderGoodsIndstProdListDOS())){
                            for (OrderGoodsIndstProdListDO orderGoodsIndstProdListDO : orderGoodsIndstDetailDO.getOrderGoodsIndstProdListDOS()){
                                orderGoodsIndstProdListDO.setOrderGoodsIndstDetailId(orderGoodsIndstDetailDO.getId());
                                industryProductList.add(orderGoodsIndstProdListDO);
                            }
                        }
                    }
                }
            }
            //插入行业商品规格对应产品清单
            appMallOrderDao.batchInsertOrderGoodsIndstProdListDO(industryProductList);
            //修改购物车状态
            shoppingTrolleyDao.updateIndustryShopCarStatus(mallIndstShopCarDOS);
        }
        //查询销售用户信息
//        UserAccountSimpleDTO saleUser = null;
//        if(user.getSaleId()!=null){
//            //saleUser = mallUserClient.feignGetSimpleUserInfo(user.getSaleId());
//            saleUser = userAppApi.feignGetUserSimpleInfo(user.getSaleId(), null);
//        }
        //插入总订单信息
        Date cdate = new Date();
        MallOrderDO order = new MallOrderDO();
        order.setId(orderId);
        order.setOrderNo(orderNo);
        order.setPid(0);
        order.setStatusCode(OrderStatus.PENDING_ASSIGNMENT.getCode());
        order.setUserAccountId(user.getId());
        order.setUid(user.getUid());
        order.setUserName(user.getNickName());
        order.setPhoneNum(user.getPhoneNum());
        order.setCreateTime(cdate);
        order.setUserAddressId(param.getUserAddressId());
//        log.info("相关推荐人[{}]",rcdMallUserId);
//        order.setRecMallUserId(rcdMallUserId==null?0:rcdMallUserId);
        order.setOrderAmount(orderAmount);
        order.setRealityAmount(orderAmount.subtract(couponDiscount));
        order.setRemark(param.getRemark());
//        order.setOperationId(user.getOperateId());
        order.setCouponDiscountAmount(couponDiscount);
        order.setRcdOrderAmount(rcdOrderAmount);
//        if(user.getSaleId()!=null){
//            List<UserAccountDTO> userAccountDTOS = userServletClient.feignListUserAccountByIds(Arrays.asList(user.getSaleId()));
//            if(!CollectionUtils.isEmpty(userAccountDTOS)){
//                order.setSaleId(user.getSaleId());
//                order.setSaleName(userAccountDTOS.get(0).getUserName());
//            }
//        }
        mallOrderDao.insertMallOrder(order);
        //订单服务
        List<OrderServiceDO> orderServiceDOS = this.getOrderServiceDO(orderGoodsProdDTOList, orderGoodsIndstDTOList, orderId);
        if (!CollectionUtils.isEmpty(orderServiceDOS)) {
            mallOrderDao.batchInsertOrderService(orderServiceDOS);
        }
        MallOrderExpressDO orderExpressDO = new MallOrderExpressDO(userAddressDTO);
        orderExpressDO.setOrderId(orderId);
        //插入订单收货地址
        mallOrderDao.insertOrderExpress(orderExpressDO);
        MallOrderDTO morder = order.buildMallOrderDTO();
        morder.setExp(orderExpressDO.buildOrderExpressDTO());
        //publicsher.sendInitMallOrder(morder);
        return ResultBody.success(morder);
    }

    private MallDiscountInfoDTO discountProduct(List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList, List<Integer> couponIds, Long orderId, String orderNo, BigDecimal orderAmount) throws Exception {
        MallDiscountInfoDTO mallDiscountInfoDTO = new MallDiscountInfoDTO();
        //用户选择的优惠券
        //List<CouponUserOrderDTO> userChooseCoupons = mallUserPayClient.feignListUserCouponsByIds(couponIds);
//        List<CouponUserDTO> couponUserDTOS = mallUserPayClient.feignMyCoupons(couponIds);
        List<CouponUserDTO> couponUserDTOS = null;
        List<CouponUserDTO> userChooseVIPCoupons = new ArrayList<>();
        BigDecimal allDiscount = BigDecimal.ZERO;
        BigDecimal notVipDiscount = BigDecimal.ZERO;

        //真正需要使用的优惠券
        List<CouponUserVO> couponUserVOS = new ArrayList<>();

        //对符合的优惠券进行打折
        for (CouponUserDTO userChooseCoupon : couponUserDTOS) {
            userChooseCoupon.setMinPrice(userChooseCoupon.getMinPrice() == null ? BigDecimal.ZERO : userChooseCoupon.getMinPrice());
            if (userChooseCoupon.getUseType().toString().equals("1")){
                //VIP券后面算，优先使用非VIP券
                userChooseVIPCoupons.add(userChooseCoupon);
            }else {
                userChooseCoupon.setBrandIds(Arrays.asList(userChooseCoupon.getPrimaryKey().split(",")));
                //非VIP优惠券只有一张
                //Map<Integer, BigDecimal> brandPrice = orderGoodsProdDetailDOList.stream().collect(Collectors.toMap(OrderGoodsProdDetailDO::getBrandInfoId, OrderGoodsProdDetailDO::getSkuSpecAmount, BigDecimal::add));
                Map<Integer, BigDecimal> brandPrice = new HashMap<>();
                for (OrderGoodsProdDetailDO prodDetailDO : orderGoodsProdDetailDOList) {
                    if(brandPrice.get(prodDetailDO.getBrandInfoId()) == null){
                        brandPrice.put(prodDetailDO.getBrandInfoId(), prodDetailDO.getSkuSpecAmount());
                    }else {
                        brandPrice.put(prodDetailDO.getBrandInfoId(), brandPrice.get(prodDetailDO.getBrandInfoId()).add(prodDetailDO.getSkuSpecAmount()));
                        //brandPriceMap.get(orderGoodsProdDetailDO.getBrandInfoId()).add(orderGoodsProdDetailDO.getSkuSpecAmount());
                    }
                }
                //这张优惠券可以对多少金额进行打折
                BigDecimal singleCouponDiscount = BigDecimal.ZERO;
                for (Integer k : brandPrice.keySet()){
                    if (k == null){
                        continue;
                    }
                    if(userChooseCoupon.getBrandIds().contains(k.toString())){
                        singleCouponDiscount = singleCouponDiscount.add(brandPrice.get(k));
                    }
                }
                //可以打折
                if (singleCouponDiscount.compareTo(BigDecimal.ZERO) > 0){
                    CouponUserVO couponUserVO = new CouponUserVO();
                    couponUserVO.setId(userChooseCoupon.getId());
                    couponUserVO.setCid(orderId);
                    couponUserVO.setOrderNo(orderNo);
                    couponUserVO.setUseType(userChooseCoupon.getUseType());
                    couponUserVO.setCouponType(userChooseCoupon.getCouponType());
                    //判断是哪种打折类型
                    if (userChooseCoupon.getCouponType().equals(1)){
                        if (userChooseCoupon.getMinPrice().compareTo(singleCouponDiscount) <= 0) {
                            //折扣的金额
                            BigDecimal discountMoney = BigDecimal.ONE.subtract(userChooseCoupon.getCouponDiscount().multiply(BigDecimal.valueOf(0.1))).multiply(singleCouponDiscount);
                            //不能超过最高优惠
                            //看是否有折扣限制
                            if (userChooseCoupon.getPreferentialLimit() == null){
                                userChooseCoupon.setDiscountCouponPrice(discountMoney);
                            }else {
                                //不能超过最高优惠
                                userChooseCoupon.setDiscountCouponPrice(discountMoney.compareTo(userChooseCoupon.getPreferentialLimit()) > 0 ? userChooseCoupon.getPreferentialLimit() : discountMoney);
                            }
                            couponUserVO.setStatus(1);
                            couponUserVO.setRemainingBalance(BigDecimal.ZERO);
                            couponUserVO.setUseAmount(userChooseCoupon.getDiscountCouponPrice());
                            couponUserVOS.add(couponUserVO);
                        }
                    } else if (userChooseCoupon.getCouponType().equals(2)) {
                        //满减券
                        if (userChooseCoupon.getMinPrice().compareTo(singleCouponDiscount) <= 0) {
                            userChooseCoupon.setDiscountCouponPrice(userChooseCoupon.getCouponMoney());
                            couponUserVO.setStatus(1);
                            couponUserVO.setRemainingBalance(BigDecimal.ZERO);
                            couponUserVO.setUseAmount(userChooseCoupon.getCouponMoney());
                            couponUserVOS.add(couponUserVO);
                        }
                    } else if (userChooseCoupon.getCouponType().equals(3)) {
                        log.info("计算非VIP券无门槛userChooseCoupon------>{}", JSONObject.toJSON(userChooseCoupon));
                        //优惠券剩余金额
                        BigDecimal couponRemainAmount = BigDecimal.ZERO;
                        if (userChooseCoupon.getStatus().equals(0)){
                            couponRemainAmount = userChooseCoupon.getCouponMoney();
                        }else {
                            couponRemainAmount = userChooseCoupon.getRemainingBalance();
                        }
                        log.info("非VIP券无门槛剩余------>{}", JSONObject.toJSON(couponRemainAmount));
                        //无门槛券
                        if (couponRemainAmount.compareTo(singleCouponDiscount) > 0){
                            //此券可以进行拆分
                            if (userChooseCoupon.getVerificationType().equals(true)){
                                //多次
                                couponUserVO.setStatus(4);
                                couponUserVO.setRemainingBalance(couponRemainAmount.subtract(singleCouponDiscount));
                                couponUserVO.setUseAmount(singleCouponDiscount);
                            }else {
                                couponUserVO.setStatus(1);
                                couponUserVO.setUseAmount(singleCouponDiscount);
                                couponUserVO.setRemainingBalance(BigDecimal.ZERO);
                            }
                            userChooseCoupon.setDiscountCouponPrice(singleCouponDiscount);
                        }else {
                            couponUserVO.setStatus(1);
                            couponUserVO.setRemainingBalance(BigDecimal.ZERO);
                            couponUserVO.setUseAmount(couponRemainAmount);
                            userChooseCoupon.setDiscountCouponPrice(couponRemainAmount);
                        }
                        log.info("最后使用：计算非VIP券无门槛userChooseCoupon------>{}", JSONObject.toJSON(couponUserVO));
                        couponUserVOS.add(couponUserVO);
                    }
                    allDiscount = allDiscount.add(userChooseCoupon.getDiscountCouponPrice());
                    notVipDiscount = notVipDiscount.add(userChooseCoupon.getDiscountCouponPrice());
                    log.info("用户使用优惠券notVipDiscount------>{}", notVipDiscount);
                }
            }
        }

        //计算VIP券
        if (userChooseVIPCoupons.size() > 0){
            //优惠券进行排序
            userChooseVIPCoupons.sort((v1, v2) -> {return v1.getCouponMoney().compareTo(v2.getCouponMoney());});
            //多张VIP，选出最合适的几张进行打折，先用小的
            BigDecimal temp = BigDecimal.ZERO.add(notVipDiscount);
            for (CouponUserDTO userChooseVIPCoupon : userChooseVIPCoupons) {
                CouponUserVO couponUserVO = new CouponUserVO();
                couponUserVO.setId(userChooseVIPCoupon.getId());
                couponUserVO.setCid(orderId);
                couponUserVO.setOrderNo(orderNo);
                couponUserVO.setUseType(userChooseVIPCoupon.getUseType());
                couponUserVO.setCouponType(userChooseVIPCoupon.getCouponType());

                //优惠券剩余金额
                BigDecimal couponRemainAmount = BigDecimal.ZERO;
                if (userChooseVIPCoupon.getStatus().equals(0)){
                    couponRemainAmount = userChooseVIPCoupon.getCouponMoney();
                }else {
                    couponRemainAmount = userChooseVIPCoupon.getRemainingBalance();
                }
                temp = temp.add(couponRemainAmount);

                //当使用的优惠券金额大于订单的金额时，需要对此优惠券进行拆分
                if (temp.compareTo(orderAmount) > 0){
                    //超出多少，即剩余多少
                    BigDecimal moreThan = temp.subtract(orderAmount);
                    if (moreThan.compareTo(couponRemainAmount) == 0){
                        //超出恰好等于这张券的时候，就直接退出，不需要再添加
                        break;
                    }
                    couponUserVO.setStatus(4);
                    couponUserVO.setRemainingBalance(moreThan);
                    couponUserVO.setUseAmount(couponRemainAmount.subtract(moreThan));
                    couponUserVOS.add(couponUserVO);
                    allDiscount = allDiscount.add(couponRemainAmount.subtract(moreThan));
                    break;
                }
                //添加到使用里面
                couponUserVO.setStatus(1);
                couponUserVO.setRemainingBalance(BigDecimal.ZERO);
                couponUserVO.setUseAmount(couponRemainAmount);
                couponUserVOS.add(couponUserVO);
                allDiscount = allDiscount.add(couponRemainAmount);
            }
        }

        //调用使用优惠券
        if (couponUserVOS.size() > 0){
            mallDiscountInfoDTO.setCouponUserVOS(couponUserVOS);
        }
        mallDiscountInfoDTO.setAllDiscount(allDiscount);
        return mallDiscountInfoDTO;
    }

    private List<OrderServiceDO> getOrderServiceDO(List<OrderGoodsProdDTO> orderGoodsProdDTOList, List<OrderGoodsIndstDTO> orderGoodsIndstDTOList, Integer orderId){
        List<OrderServiceDO> orderServiceDOS = new ArrayList<>();
        Date cDate = new Date();
        for ( OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
            if(!CollectionUtils.isEmpty(orderGoodsProdDTO.getServices())){
                for (GoodsServiceDTO goodsServiceDTO : orderGoodsProdDTO.getServices()){
                    OrderServiceDO orderServiceDO = new OrderServiceDO();
                    orderServiceDO.setOrderId(orderId);
                    orderServiceDO.setGoodsInfoId(goodsServiceDTO.getGoodsInfoId());
                    orderServiceDO.setServiceName(goodsServiceDTO.getServiceName());
                    orderServiceDO.setCreateTime(cDate);
                    orderServiceDOS.add(orderServiceDO);
                }
            }
        }
//        for ( OrderGoodsIndstDTO orderGoodsIndstDTO : orderGoodsIndstDTOList){
//            if(!CollectionUtils.isEmpty(orderGoodsIndstDTO.getServices())){
//                for (GoodsServiceDTO goodsServiceDTO : orderGoodsIndstDTO.getServices()){
//                    OrderServiceDO orderServiceDO = new OrderServiceDO();
//                    orderServiceDO.setOrderId(orderId);
//                    orderServiceDO.setGoodsInfoId(goodsServiceDTO.getGoodsInfoId());
//                    orderServiceDO.setServiceName(goodsServiceDTO.getServiceName());
//                    orderServiceDO.setCreateTime(cDate);
//                    orderServiceDOS.add(orderServiceDO);
//                }
//            }
//        }
        return orderServiceDOS;
    }

    private List<OrderGoodsProdDO> generatedProdOrder(List<MallProdShopCarDO> mallProdShopCarDOS, List<OrderGoodsProdDTO> orderGoodsProdDTOList){
        List<OrderGoodsProdDO> orderGoodsProdDOS = new ArrayList<>();
        UUID uuid = UUID.randomUUID();
        for (MallProdShopCarDO mallProdShopCarDO : mallProdShopCarDOS){
            //找出此商品的具体规格id
            List<Integer> goodsInfoSpecIds = mallProdShopCarDO.getShopCarDetailDOS().stream().map(d->d.getMallProdSkuInfoSpecId()).collect(Collectors.toList());
            //找出对应的商品
            for (OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
                //找到了对应的
                if(mallProdShopCarDO.getGoodsInfoId().toString().equals(orderGoodsProdDTO.getGoodsInfoId().toString())){
                    OrderGoodsProdDO orderGoodsProdDO = new OrderGoodsProdDO(orderGoodsProdDTO);
                    orderGoodsProdDO.setBuyNum(mallProdShopCarDO.getBuyNum());
                    orderGoodsProdDO.setMallProdShopCarId(mallProdShopCarDO.getId());
                    //商品下对应的产品规格清单
                    if(!CollectionUtils.isEmpty(orderGoodsProdDTO.getOrderGoodsProdDetailDTOS())){
                        List<OrderGoodsProdDetailDO> orderGoodsProdDetailDTOS = new ArrayList<>();
                        BigDecimal prodSpecAmount = BigDecimal.ZERO;
                        for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : orderGoodsProdDTO.getOrderGoodsProdDetailDTOS()){
                            //规格没有配置价格就返回提示
                            if(orderGoodsProdDetailDTO.getUnitPrice() == null){
                                return null;
                            }
                            //找到属于对应购物车的规格信息
                            if (goodsInfoSpecIds.contains(orderGoodsProdDetailDTO.getMallProdSkuInfoSpecId())){
                                OrderGoodsProdDetailDO orderGoodsProdDetailDO = new OrderGoodsProdDetailDO(orderGoodsProdDetailDTO);
                                orderGoodsProdDetailDO.setBuyNum(orderGoodsProdDO.getBuyNum());
                                orderGoodsProdDetailDO.setSkuSpecAmount(orderGoodsProdDetailDO.getUnitPrice().multiply(BigDecimal.valueOf(orderGoodsProdDetailDO.getBuyNum())));
                                orderGoodsProdDetailDTOS.add(orderGoodsProdDetailDO);
                                //全部规格  单价*数量
                                prodSpecAmount = prodSpecAmount.add(orderGoodsProdDetailDO.getSkuSpecAmount());
                            }
                        }
                        //设置此商品所有规格金额
                        orderGoodsProdDO.setGoodsAmount(prodSpecAmount);
                        orderGoodsProdDO.setOrderGoodsProdDetailDOList(orderGoodsProdDetailDTOS);
                    }
                    orderGoodsProdDOS.add(orderGoodsProdDO);
                    break;
                }

            }
        }
        log.info("线程id[{}],mallProdShopCarDOS==>[{}],orderGoodsProdDTOList==>[{}],orderGoodsProdDOS==>[{}]",uuid, JSONObject.toJSONString(mallProdShopCarDOS), JSONObject.toJSONString(orderGoodsProdDTOList), JSONObject.toJSONString(orderGoodsProdDOS));
        return orderGoodsProdDOS;
    }


    /**
     * v1.0.0生成对应的订单信息
     * @param mallConfirmOrderVO
     * @param orderGoodsProdDTOList
     * @return
     */
    private List<OrderGoodsProdDO> generatedMallProdOrder(MallConfirmOrderVO mallConfirmOrderVO, List<OrderGoodsProdDTO> orderGoodsProdDTOList){
        List<OrderGoodsProdDO> orderGoodsProdDOS = new ArrayList<>();
        UUID uuid = UUID.randomUUID();
        //找出此商品的具体规格id
        Set<Integer> goodsInfoSpecIds = mallConfirmOrderVO.getMallSpecIds();
        //找出对应的商品
        for (OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
            //找到了对应的
            if(mallConfirmOrderVO.getGoodsInfoId().toString().equals(orderGoodsProdDTO.getGoodsInfoId().toString())){
                OrderGoodsProdDO orderGoodsProdDO = new OrderGoodsProdDO(orderGoodsProdDTO);
                orderGoodsProdDO.setBuyNum(mallConfirmOrderVO.getBuyNum());
                //商品下对应的产品规格清单
                if(!CollectionUtils.isEmpty(orderGoodsProdDTO.getOrderGoodsProdDetailDTOS())){
                    List<OrderGoodsProdDetailDO> orderGoodsProdDetailDTOS = new ArrayList<>();
                    BigDecimal prodSpecAmount = BigDecimal.ZERO;
                    for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : orderGoodsProdDTO.getOrderGoodsProdDetailDTOS()){
                        //规格没有配置价格就返回提示
                        if(orderGoodsProdDetailDTO.getUnitPrice() == null){
                            return null;
                        }
                        //找到属于对应购物车的规格信息
                        if (goodsInfoSpecIds.contains(orderGoodsProdDetailDTO.getMallProdSkuInfoSpecId())){
                            OrderGoodsProdDetailDO orderGoodsProdDetailDO = new OrderGoodsProdDetailDO(orderGoodsProdDetailDTO);
                            orderGoodsProdDetailDO.setBuyNum(orderGoodsProdDO.getBuyNum());
                            orderGoodsProdDetailDO.setSkuSpecAmount(orderGoodsProdDetailDO.getUnitPrice().multiply(BigDecimal.valueOf(orderGoodsProdDetailDO.getBuyNum())));
                            orderGoodsProdDetailDTOS.add(orderGoodsProdDetailDO);
                            //全部规格  单价*数量
                            prodSpecAmount = prodSpecAmount.add(orderGoodsProdDetailDO.getSkuSpecAmount());
                        }
                    }
                    //设置此商品所有规格金额
                    orderGoodsProdDO.setGoodsAmount(prodSpecAmount);
                    orderGoodsProdDO.setOrderGoodsProdDetailDOList(orderGoodsProdDetailDTOS);
                }
                orderGoodsProdDOS.add(orderGoodsProdDO);
                break;
            }
        }
        log.info("线程id[{}],mallProdShopCarDOS==>[{}],orderGoodsProdDTOList==>[{}],orderGoodsProdDOS==>[{}]",uuid, JSONObject.toJSONString(mallConfirmOrderVO), JSONObject.toJSONString(orderGoodsProdDTOList), JSONObject.toJSONString(orderGoodsProdDOS));
        return orderGoodsProdDOS;
    }

    private List<OrderGoodsIndstDO> generatedIndstOrder(List<MallIndstShopCarDO> mallIndstShopCarDOS, List<OrderGoodsIndstDTO> orderGoodsIndstDTOList){
        //生成id
        List<OrderGoodsIndstDO> orderGoodsIndstDOS = new ArrayList<>();
        for (MallIndstShopCarDO mallIndstShopCarDO : mallIndstShopCarDOS){
            List<Integer> goodsInfoIndstSkuSpecIds = mallIndstShopCarDO.getShopCarDetailDOS().stream().map(d->d.getMallIndstSkuInfoSpecId()).collect(Collectors.toList());
            for (OrderGoodsIndstDTO orderGoodsIndstDTO : orderGoodsIndstDTOList){
                if (mallIndstShopCarDO.getGoodsInfoId().toString().equals(orderGoodsIndstDTO.getGoodsInfoId().toString())){
                    //找到对应商品信息
                    OrderGoodsIndstDO orderGoodsIndstDO = new OrderGoodsIndstDO(orderGoodsIndstDTO);
                    orderGoodsIndstDO.setBuyNum(mallIndstShopCarDO.getBuyNum());
                    orderGoodsIndstDO.setMallIndstShopCarId(mallIndstShopCarDO.getId());
                    if(!CollectionUtils.isEmpty(orderGoodsIndstDTO.getOrderGoodsIndstDetailDTOS())){
                        List<OrderGoodsIndstDetailDO> orderGoodsIndstDetailDOS = new ArrayList<>();
                        BigDecimal indstSpecAmount = BigDecimal.ZERO;
                        for (OrderGoodsIndstDetailDTO orderGoodsIndstDetailDTO : orderGoodsIndstDTO.getOrderGoodsIndstDetailDTOS()){
                            //判断有规格没有配置价格则提醒
                            if(orderGoodsIndstDetailDTO.getUnitPrice() == null){
                                return null;
                            }
                            //找出对应的行业规格
                            if(goodsInfoIndstSkuSpecIds.contains(orderGoodsIndstDetailDTO.getMallIndstSkuInfoSpecId())){
                                OrderGoodsIndstDetailDO orderGoodsIndstDetailDO = new OrderGoodsIndstDetailDO(orderGoodsIndstDetailDTO);
                                orderGoodsIndstDetailDO.setBuyNum(orderGoodsIndstDO.getBuyNum());
                                orderGoodsIndstDetailDO.setSkuSpecAmount(orderGoodsIndstDetailDO.getUnitPrice().multiply(BigDecimal.valueOf(orderGoodsIndstDetailDO.getBuyNum())));
                                indstSpecAmount = indstSpecAmount.add(orderGoodsIndstDetailDO.getSkuSpecAmount());
                                if(!CollectionUtils.isEmpty(orderGoodsIndstDetailDTO.getOrderGoodsIndstProdListDTOS())){
                                    List<OrderGoodsIndstProdListDO> orderGoodsIndstProdListDOS = new ArrayList<>();
                                    for (OrderGoodsIndstProdListDTO orderGoodsIndstProdListDTO : orderGoodsIndstDetailDTO.getOrderGoodsIndstProdListDTOS()){
                                        OrderGoodsIndstProdListDO orderGoodsIndstProdListDO = new OrderGoodsIndstProdListDO(orderGoodsIndstProdListDTO);
                                        orderGoodsIndstProdListDO.setBuyNum(orderGoodsIndstDetailDO.getBuyNum());
                                        //设置产品单位，导出用到
                                        orderGoodsIndstProdListDO.setUnitName(orderGoodsIndstDetailDO.getUnitName());
                                        orderGoodsIndstProdListDOS.add(orderGoodsIndstProdListDO);
                                    }
                                    orderGoodsIndstDetailDO.setOrderGoodsIndstProdListDOS(orderGoodsIndstProdListDOS);
                                }
                                orderGoodsIndstDetailDOS.add(orderGoodsIndstDetailDO);
                            }
                        }
                        orderGoodsIndstDO.setGoodsAmount(indstSpecAmount);
                        orderGoodsIndstDO.setOrderGoodsIndstDetailDOS(orderGoodsIndstDetailDOS);
                    }
                    orderGoodsIndstDOS.add(orderGoodsIndstDO);
                    break;
                }
            }
        }
        return orderGoodsIndstDOS;
    }

    /**
     * 订单分成相关
     * @param skuType
     * @param mallProdShopCarDOS
     * @param mallIndstShopCarDOS
     * @param rcdMallUserId
     * @param mallOrderGoodsInfoQO
     * @return
     */
    private BigDecimal getRcdMallOrderAmount(Integer skuType, List<MallProdShopCarDO> mallProdShopCarDOS, List<MallIndstShopCarDO> mallIndstShopCarDOS, Integer rcdMallUserId, MallOrderGoodsInfoQO mallOrderGoodsInfoQO){
        //MallUserDTO rcdMallUser = mallUserClient.feignGetSimpleUserInfo(rcdMallUserId);
        UserAccountSimpleDTO rcdUser = userClient.feignGetUserSimpleInfo(rcdMallUserId, null);
        BigDecimal dcrMallOrderAmount = BigDecimal.ZERO;
        //查询商品信息，价格信息
        mallOrderGoodsInfoQO.setUserAccountId(rcdMallUserId);
        mallOrderGoodsInfoQO.setCooperationTagId(rcdUser.getCooperationTagId());

        //产品sku信息
        List<OrderGoodsProdDTO> orderGoodsProdDTOList = new ArrayList<>();
        //行业sku信息
        List<OrderGoodsIndstDTO> orderGoodsIndstDTOList = new ArrayList<>();

        if (skuType.equals(1)){
            //查询商品详细信息
            orderGoodsProdDTOList = pmsClient.feignListProdGoodsSkuInfo(mallOrderGoodsInfoQO, null);
            List<OrderGoodsProdDO> orderGoodsProdDOS = this.generatedProdOrder(mallProdShopCarDOS, orderGoodsProdDTOList);
            if(orderGoodsProdDOS == null){
                return dcrMallOrderAmount;
            }
            //把每个商品所有规格金额加起来，订单金额
            for (OrderGoodsProdDO orderGoodsProdDO : orderGoodsProdDOS){
                dcrMallOrderAmount = dcrMallOrderAmount.add(orderGoodsProdDO.getGoodsAmount());
            }
        }else {
            orderGoodsIndstDTOList = pmsClient.feignListIndstGoodsSkuInfo(mallOrderGoodsInfoQO, null);
            if(CollectionUtils.isEmpty(orderGoodsIndstDTOList)){
                return dcrMallOrderAmount;
            }
            List<OrderGoodsIndstDO> orderGoodsIndstDOS = this.generatedIndstOrder(mallIndstShopCarDOS, orderGoodsIndstDTOList);
            //订单金额
            for (OrderGoodsIndstDO orderGoodsIndstDO : orderGoodsIndstDOS){
                dcrMallOrderAmount = dcrMallOrderAmount.add(orderGoodsIndstDO.getGoodsAmount());
            }
        }
        return dcrMallOrderAmount;
    }


    /**
     * 得到分享订单状态
     *
     * @param orderId 订单id
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody getShareOrderStatus(Integer orderId) {
        // 将此订单id的分享状态进行变更
        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(orderId);
        return ResultBody.success(mallOrderInfo.buildMallOrderDTO());
    }

    /**
     * 接受分享
     *
     * @param orderId 订单id
     * @param shareId 共享id
     * @return {@link ResultBody}
     */
    @Override
    public ResultBody acceptShare(Integer orderId, Integer shareId) {
        // 根据订单id判断此订单是否已经有人接受共享了
        MallOrderDO mallOrderInfo = mallOrderDao.getMallOrderInfo(orderId);
        if (mallOrderInfo.getShareStatus().equals(200)) {
            ResultBody.error("已存在接受共享人");
        }
        // 将分享人信息保存到数据库
        appMallOrderDao.updateOrderShareInfo(orderId,shareId);
        return ResultBody.success();
    }

    @Override
    public CountShowTypeDTO countListPage(BaseAccountDTO currentAccount) {
        List<Integer> statusCodes0 = this.getOrderStatusByShowType(0);
        List<Integer> statusCodes1 = this.getOrderStatusByShowType(1);
        List<Integer> statusCodes2 = this.getOrderStatusByShowType(2);
        List<Integer> statusCodes3 = this.getOrderStatusByShowType(3);
        List<Integer> statusCodes4 = this.getOrderStatusByShowType(4);
        int showType0 = mallOrderDao.countAppPageOrder(null, null, statusCodes0, currentAccount.getUserAccountId());
        int showType1 = mallOrderDao.countAppPageOrder(null, null, statusCodes1, currentAccount.getUserAccountId());
        int showType2 = mallOrderDao.countAppPageOrder(null, null, statusCodes2, currentAccount.getUserAccountId());
        int showType3 = mallOrderDao.countAppPageOrder(null, null, statusCodes3, currentAccount.getUserAccountId());
        int showType4 = mallOrderDao.countAppPageOrder(null, null, statusCodes4, currentAccount.getUserAccountId());
        return CountShowTypeDTO.builder().showType0(showType0).showType1(showType1).showType2(showType2).showType3(showType3).showType4(showType4).build();
    }

    @Transactional
    @Override
    public ResultBody returnContractById(Integer orderId) {
        //订单状态退回到 待确认订单，手动折扣改为0，相关字段设置为空
        MallOrderDO order = mallOrderDao.getMallOrderInfo(orderId);
        order.setStatusCode(OrderStatus.PLACE_ORDER.getCode());
        //原实付价格+手动折扣
        order.setRealityAmount(order.getRealityAmount().add(order.getManualDiscountAmount()));
        order.setManualDiscountAmount(BigDecimal.ZERO);
        order.setSignStatus(null);
        order.setCreditPeriodDays(null);
        order.setDeliveryTime(null);
        order.setContractSignedWay(null);
        order.setCreditPeriod(null);
        mallOrderDao.rollbackMallOrder(order);
        //删除原来的合同
//        ResultBody resultBody = fddServletClient.feignRemoveContractByOrderId(orderId);
//        if (resultBody == null){
//            throw new BizException("退回合同失败，请重试");
//        }
        return ResultBody.success();
    }

    @Override
    public ResultBody<ConfirmGoodsInfoDTO> confirmMallOrder(MallConfirmOrderVO param, BaseAccountDTO cuser, String token) {
        UserAccountSimpleDTO userAccountSimpleDTO = userClient.feignGetUserSimpleInfo(cuser.getUserAccountId(), token);
        if (StringUtils.isEmpty(userAccountSimpleDTO.getPhoneNum())) {
            return ResultBody.error(ResultEnum.AUTH_ACCOUNT_ERROR);
        }

        //返回的结果
        ConfirmGoodsInfoDTO confirmGoodsInfoDTO = new ConfirmGoodsInfoDTO();

        //查询商品信息，价格信息
        MallOrderGoodsInfoQO mallOrderGoodsInfoQO = new MallOrderGoodsInfoQO();
        mallOrderGoodsInfoQO.setUserAccountId(userAccountSimpleDTO.getId());
        mallOrderGoodsInfoQO.setCooperationTagId(userAccountSimpleDTO.getCooperationTagId());
        //订单金额
        BigDecimal orderAmount = BigDecimal.ZERO;
        //产品sku信息
        List<OrderGoodsProdDTO> orderGoodsProdDTOList = new ArrayList<>();
        //处理产品商品
        if(!CollectionUtils.isEmpty(param.getMallSpecIds()) && !param.getDirectoryId().equals(2)){
            confirmGoodsInfoDTO.setDirectoryId(1);
            //设置查询商品信息的参数，mallProdSkuInfoSpecId
            mallOrderGoodsInfoQO.setMallProdSkuSpecIds(new HashSet<>());
            mallOrderGoodsInfoQO.getMallProdSkuSpecIds().addAll(param.getMallSpecIds());
            //查询商品详细信息
            orderGoodsProdDTOList = pmsClient.feignListProdGoodsSkuInfo(mallOrderGoodsInfoQO, token);

            //----------------------判空
            if(CollectionUtils.isEmpty(orderGoodsProdDTOList)){
                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
            }
            //判断是否有无效的产品商品
            for (OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
                if(orderGoodsProdDTO.getDeleted() == 0 && orderGoodsProdDTO.getShelfStatus() == 1){
                    for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : orderGoodsProdDTO.getOrderGoodsProdDetailDTOS()){
                        if( !(orderGoodsProdDetailDTO.getSpecDeleted() == 0 && orderGoodsProdDetailDTO.getSkuInfoDeleted() == 0 && orderGoodsProdDetailDTO.getSkuSpecDeleted() == 0)){
                            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                        }
                    }
                }else {
                    return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                }
            }
            /**
             * 待写
             */
            List<OrderGoodsProdDO> orderGoodsProdDOS = this.generatedMallProdOrder(param, orderGoodsProdDTOList);
            if(orderGoodsProdDOS == null){
                return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
            }
            //把每个商品所有规格金额加起来，订单金额
            BigDecimal prodOrderAmount = orderGoodsProdDOS.stream().map(OrderGoodsProdDO::getGoodsAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList = new ArrayList<>();
            orderGoodsProdDOS.stream().forEach(orderGoodsProdDO -> {
                if(!CollectionUtils.isEmpty(orderGoodsProdDO.getOrderGoodsProdDetailDOList())){
                    orderGoodsProdDO.getOrderGoodsProdDetailDOList().stream().forEach(prodDetail -> {
                        prodDetail.setOrderGoodsProdId(orderGoodsProdDO.getId());
                        orderGoodsProdDetailDOList.add(prodDetail);
                    });
                }
            });
            List<OrderGoodsProdDetailDTO> collect = orderGoodsProdDetailDOList.stream().map(d -> d.buildOrderGoodsProdDetailDTO()).collect(Collectors.toList());
            confirmGoodsInfoDTO.setOrderGoodsProdDetailDTOS(collect);
            confirmGoodsInfoDTO.setOrderAmount(prodOrderAmount);
        }
        return ResultBody.success(confirmGoodsInfoDTO);
    }

    @Transactional
    @Override
    public ResultBody commitMallOrder(MallConfirmOrderVO param, BaseAccountDTO currentAccount, String token) {
        //查询收货地址
        UserAddressDTO userAddressDTO = userAddressService.getUserAddressInfo(param.getUserAddressId());
        //查询商品信息，价格信息
        MallOrderGoodsInfoQO mallOrderGoodsInfoQO = new MallOrderGoodsInfoQO();
        mallOrderGoodsInfoQO.setUserAccountId(currentAccount.getUserAccountId());
        mallOrderGoodsInfoQO.setCooperationTagId(currentAccount.getUserAccountId());
        //订单金额
        BigDecimal orderAmount = BigDecimal.ZERO;
        //推荐人订单总价
        BigDecimal rcdOrderAmount = BigDecimal.ZERO;
        //产品sku信息
        List<OrderGoodsProdDTO> orderGoodsProdDTOList = new ArrayList<>();
        //生成总订单id
        SnowFlake snowFlake = new SnowFlake(2, 3);
        //Long orderId = snowFlake.nextId();
        String orderNo = CodeUtil.uavOrderCode();
        BigDecimal couponDiscount = BigDecimal.ZERO;

        //处理产品商品
        if(!CollectionUtils.isEmpty(param.getMallSpecIds()) && !param.getDirectoryId().equals(2)){
            //设置查询商品信息的参数，mallProdSkuInfoSpecId
            mallOrderGoodsInfoQO.setMallProdSkuSpecIds(new HashSet<>());
            mallOrderGoodsInfoQO.getMallProdSkuSpecIds().addAll(param.getMallSpecIds());
            //查询商品详细信息
            orderGoodsProdDTOList = pmsClient.feignListProdGoodsSkuInfo(mallOrderGoodsInfoQO, token);
            //----------------------判空
            if(CollectionUtils.isEmpty(orderGoodsProdDTOList)){
                return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
            }
            //判断是否有无效的产品商品
            for (OrderGoodsProdDTO orderGoodsProdDTO : orderGoodsProdDTOList){
                if(orderGoodsProdDTO.getDeleted() == 0 && orderGoodsProdDTO.getShelfStatus() == 1){
                    for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : orderGoodsProdDTO.getOrderGoodsProdDetailDTOS()){
                        if( !(orderGoodsProdDetailDTO.getSpecDeleted() == 0 && orderGoodsProdDetailDTO.getSkuInfoDeleted() == 0 && orderGoodsProdDetailDTO.getSkuSpecDeleted() == 0)){
                            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                        }
                    }
                }else {
                    return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
                }
            }
            List<OrderGoodsProdDO> orderGoodsProdDOS = this.generatedMallProdOrder(param, orderGoodsProdDTOList);
            if(orderGoodsProdDOS == null){
                return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
            }
            //把每个商品所有规格金额加起来，订单金额；
            BigDecimal prodOrderAmount = orderGoodsProdDOS.stream().map(OrderGoodsProdDO::getGoodsAmount).reduce(BigDecimal.ZERO, BigDecimal::add);

            //插入订单主订单
            //插入总订单信息
            Date cdate = new Date();
            MallOrderDO order = new MallOrderDO();
            //order.setId(orderId);
            order.setOrderNo(orderNo);
            order.setPid(0);
            order.setStatusCode(OrderStatus.PENDING_ASSIGNMENT.getCode());
            order.setUserAccountId(currentAccount.getUserAccountId());
            order.setUid(currentAccount.getUid());
            order.setUserName(currentAccount.getUserName());
            order.setPhoneNum(currentAccount.getPhoneNum());
            order.setCreateTime(cdate);
            order.setUserAddressId(param.getUserAddressId());
            order.setOrderAmount(prodOrderAmount);
            order.setRealityAmount(prodOrderAmount.subtract(couponDiscount));
            order.setRemark(param.getRemark());
            order.setCouponDiscountAmount(couponDiscount);
            order.setRcdOrderAmount(rcdOrderAmount);
            mallOrderDao.insertMallOrder(order);

            List<OrderGoodsProdDO> orderGoodsProdDOList = orderGoodsProdDOS.stream().map(d -> {
                d.setOrderId(order.getId());
                return d;
            }).collect(Collectors.toList());
            List<OrderGoodsProdDetailDO> orderGoodsProdDetailDOList = new ArrayList<>();
            //插入产品商品
            appMallOrderDao.batchInsertOrderGoodsProdDO(orderGoodsProdDOS);
            List<OrderGoodsProdDO> goodsProdDOList = orderGoodsProdDOList.stream().map(d -> {
                if (!CollectionUtils.isEmpty(d.getOrderGoodsProdDetailDOList())) {
                    d.getOrderGoodsProdDetailDOList().stream().map(dd -> {
                        //设置商品订单id
                        dd.setOrderGoodsProdId(d.getId());
                        orderGoodsProdDetailDOList.add(dd);
                        return dd;
                    }).collect(Collectors.toList());
                }
                return d;
            }).collect(Collectors.toList());

            //批量插入产品商品规格
            appMallOrderDao.batchInsertOrderGoodsProdDetailDO(orderGoodsProdDetailDOList);

            //订单服务
            List<OrderServiceDO> orderServiceDOS = this.getOrderServiceDO(orderGoodsProdDTOList, null, order.getId());
            if (!CollectionUtils.isEmpty(orderServiceDOS)) {
                mallOrderDao.batchInsertOrderService(orderServiceDOS);
            }
            MallOrderExpressDO orderExpressDO = new MallOrderExpressDO(userAddressDTO);
            orderExpressDO.setOrderId(order.getId());
            //插入订单收货地址
            mallOrderDao.insertOrderExpress(orderExpressDO);
            MallOrderDTO morder = order.buildMallOrderDTO();
            morder.setExp(orderExpressDO.buildOrderExpressDTO());
            return ResultBody.success(morder);
        }
        return ResultBody.success();
    }

    @Override
    public MallOrderDTO getMallOrderDetailById(Integer orderId, BaseAccountDTO currentAccount) {

        return null;
    }

    public List<Integer> getOrderStatusByShowType(Integer showType){
        List<Integer> statusCodes = new ArrayList<>();
        if (showType == null){
            return null;
        }
        if(showType.equals(0)){
            statusCodes.add(50);
            statusCodes.add(100);
        } else if (showType.equals(1)) {
            statusCodes.add(200);
            statusCodes.add(300);
            statusCodes.add(350);
            statusCodes.add(650);
            statusCodes.add(660);
            statusCodes.add(670);
        } else if (showType.equals(2)) {
            statusCodes.add(710);
        } else if (showType.equals(3)) {
            statusCodes.add(720);
        } else if (showType.equals(4)) {
            statusCodes.add(800);
        } else if (showType.equals(5)) {
            statusCodes.add(999);
        }
        return statusCodes;
    }
}
