package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavOrderPayDTO;
import com.mmc.oms.model.vo.uav.UavOrderPayVO;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/11 16:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-采购订单凭证")
public class UavPurchaseOrderPayDO implements Serializable {
    private static final long serialVersionUID = -287998124979696397L;
    private Integer id;
    private Integer uavPOrderId;
    private String payImgList;
    private Integer checkStatus;
    private String payRemark;
    private String refuseReason;
    private Date createTime;
    private Date checkTime;

    public UavPurchaseOrderPayDO(UavOrderPayVO uavOrderPayVO) {
        this.id = uavOrderPayVO.getId();
        this.payImgList = uavOrderPayVO.getPayImgList();
        this.checkStatus = uavOrderPayVO.getCheckStatus();
        this.payRemark = uavOrderPayVO.getPayRemark();
        this.refuseReason = uavOrderPayVO.getRefuseReason();
    }

    public UavOrderPayDTO buildUavOrderPayDTO(){
        return UavOrderPayDTO.builder().id(this.id).uavOrderId(this.uavPOrderId).payImgList(this.payImgList).checkStatus(this.checkStatus)
                .payRemark(this.payRemark).refuseReason(this.refuseReason).createTime(this.createTime).build();
    }
}
