package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavOrderPayDTO;
import com.mmc.oms.model.vo.uav.UavOrderPayVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/4 13:56
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-订单支付信息")
public class UavOrderPayDO implements Serializable {
    private static final long serialVersionUID = -7440333696084228732L;
    private Integer id;
    private Integer uavOrderId;
    private String orderNo;
    private String payImgList;
    private Integer checkStatus;
    private Integer payType;
    private String payRemark;
    private String refuseReason;
    private Date createTime;
    private Date checkTime;
    private BigDecimal payAmount;

    public UavOrderPayDO(UavOrderPayVO uavOrderPayVO) {
        this.id = uavOrderPayVO.getId();
        this.payImgList = uavOrderPayVO.getPayImgList();
        this.checkStatus = uavOrderPayVO.getCheckStatus();
        this.payRemark = uavOrderPayVO.getPayRemark();
        this.refuseReason = uavOrderPayVO.getRefuseReason();
    }

    public UavOrderPayDTO buildUavOrderPayDTO(){
        return UavOrderPayDTO.builder().id(this.id).uavOrderId(this.uavOrderId).payImgList(this.payImgList).checkStatus(this.checkStatus)
                .payRemark(this.payRemark).refuseReason(this.refuseReason).createTime(this.createTime).payType(this.payType)
                .payAmount(this.payAmount).build();
    }

}
