package com.mmc.oms.entity.uav;

import com.mmc.oms.model.dto.uav.UavCartCompanyDTO;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/9/18 15:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("最新版-商城购物车-小程序")
public class UavCartCompanyDO implements Serializable {
    private static final long serialVersionUID = 1170859050008253153L;
    private Integer thirdBackUserAccountId;
    private Integer userAccountId;
    private String companyName;
    private List<UavCartDO> uavCartDOS;

    public UavCartCompanyDTO buildUavCartCompanyDTO(){
        return UavCartCompanyDTO.builder().thirdBackUserAccountId(this.thirdBackUserAccountId).companyName(this.companyName)
                .uavCartDOS(CollectionUtils.isNotEmpty(this.uavCartDOS) ?
                        this.uavCartDOS.stream().map(UavCartDO::buildUavCartDTO).collect(Collectors.toList()) : null).build();
    }
}
