package com.mmc.oms.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @Author small
 * @Date 2023/5/24 16:17
 * @Version 1.0
 */
@Component
public class FlyerSystemConstant {
    public static String AppletFlyerWxAppid;
    public static String AppletFlyerSecret;
    public static String WXSubAppId;// 微信公众服务号-appid
    public static String WXSubSecret;// 微信公众服务号-密钥
    public static String MIMIPROGRAMSTATE;
    public static String RABBITMQ_EXCHANGE;
    public static String WORK_FLYER_INFO_KEY;
    public final static String IS_ADMIN_ROLE = "1";// 为系统管理员类型角色

    public FlyerSystemConstant(@Value("${wechat.applet.appid}") String appletFlyerWxAppid,
                               @Value("${wechat.applet.secret}") String appletFlyerSecret,
                               @Value("${wechat.sub.appid}") String wXSubAppId, @Value("${wechat.sub.secret}") String wXSubSecret,
                               @Value("${wechat.applet.miniprogram-state}") String miniprogramState,
                               @Value("${rabbitmq.exchange}") String rabbitExchange,
                               @Value("${workFlyerInfoKey}") String workFlyerInfoKey) {
        AppletFlyerWxAppid = appletFlyerWxAppid;
        AppletFlyerSecret = appletFlyerSecret;
        WXSubAppId = wXSubAppId;
        WXSubSecret = wXSubSecret;
        MIMIPROGRAMSTATE = miniprogramState;
        RABBITMQ_EXCHANGE = rabbitExchange;
        WORK_FLYER_INFO_KEY = workFlyerInfoKey;
    }
}
