package com.mmc.oms.util;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

@Component
public class HttpUtil {


    @Value("${pms.url}")
    private String pmsAppUri;

    /**
     *
     * @param url 接口地址
     * @param headers 消息头
     * @param jsonParam 消息体
     * @return
     */
    public String sendPost(String url, Map<String, String> headers, String jsonParam) {
        String response = null;
        try {
            CloseableHttpClient httpclient = null;
            CloseableHttpResponse httpresponse = null;
            try {
                httpclient = HttpClients.createDefault();
                HttpPost httppost = new HttpPost(pmsAppUri+url);
                StringEntity stringentity = new StringEntity(jsonParam, ContentType.create("application/json", "UTF-8"));
                httppost.setEntity(stringentity);
                // 循环添加header
                if(headers!=null) {
                    Iterator headerIterator = headers.entrySet().iterator();
                    while (headerIterator.hasNext()) {
                        Map.Entry<String, String> elem = (Map.Entry<String, String>) headerIterator.next();
                        httppost.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                //发post请求
                httpresponse = httpclient.execute(httppost);
                //utf-8参数防止中文乱码
                response = EntityUtils.toString(httpresponse.getEntity(), "utf-8");
            } finally {
                if (httpclient != null) {
                    httpclient.close();
                }
                if (httpresponse != null) {
                    httpresponse.close();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    /**
     * get请求
     *
     * @param url
     * @param paramMap
     * @param headerMap
     * @return
     */
    public String sendGet(String url, Map<String, String> paramMap, Map<String, String> headerMap) {
        String jsonStr = null;
        // 获取连接客户端工具
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            /*
             * 由于GET请求的参数都是拼装在URL地址后方，所以我们要构建一个URL，带参数
             */
            URIBuilder uriBuilder = new URIBuilder(pmsAppUri+url);
            if(paramMap!=null) {
                for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }

            //拼接请求头参数
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            if(headerMap!=null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            // 执行请求
            response = httpClient.execute(httpGet);
            // 获得响应的实体对象
            HttpEntity entity = response.getEntity();
            // 使用Apache提供的工具类进行转换成字符串
            if (entity != null) {
                // 将返回结果处理成String对象
                return EntityUtils.toString(entity, "UTF-8");
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            // 释放连接
            if (null != response) {
                try {
                    response.close();
                    httpClient.close();
                } catch (IOException e) {
                    System.err.println("释放连接出错");
                    e.printStackTrace();
                }
            }
        }
        return jsonStr;
    }
}
