package com.mmc.oms.service.mall.impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.client.PmsClient;
import com.mmc.oms.client.UserClient;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.mall.ShoppingTrolleyDao;
import com.mmc.oms.entity.mall.MallIndstShopCarDO;
import com.mmc.oms.entity.mall.MallIndstShopCarDetailDO;
import com.mmc.oms.entity.mall.MallProdShopCarDO;
import com.mmc.oms.entity.mall.MallProdShopCarDetailDO;
import com.mmc.oms.model.dto.mall.ConfirmGoodsInfoDTO;
import com.mmc.oms.model.dto.mall.MallGoodsShopCarDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.mall.MallShopCarQO;
import com.mmc.oms.model.vo.mall.ConfirmMallOrderVO;
import com.mmc.oms.model.vo.mall.ConfirmShopVO;
import com.mmc.oms.model.vo.mall.MallShopCarVO;
import com.mmc.oms.model.vo.mall.ShopCarIdParamVO;
import com.mmc.oms.service.mall.AppMallOrderService;
import com.mmc.oms.service.mall.ShoppingTrolleyService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * author:zhenjie
 * Date:2022/10/11
 * time:10:30
 */
@Service
@Slf4j
public class ShoppingTrolleyServiceImpl implements ShoppingTrolleyService {
    @Autowired
    private ShoppingTrolleyDao shoppingTrolleyDao;

//    @Autowired
//    private MallGoodsClient mallGoodsClient;

//    @Autowired
//    private PmsAppApi pmsAppApi;

    @Autowired
    private AppMallOrderService appMallOrderService;

//    @Autowired
//    private UploadHandler uploadHandler;

//    @Autowired
//    private UserAppApi userAppApi;

    @Autowired
    private PmsClient pmsClient;

    @Autowired
    private UserClient userClient;

    @Override
    @Transactional
    public ResultBody addGoods(MallShopCarVO param, BaseAccountDTO cuser) {
        if (param.getBuyNum() <= 0) {
            return ResultBody.error(ResultEnum.BUY_NUM_ERROR);
        }
        // 获取用户信息
        //MallUserDTO muser = mallUserClient.feignGetSimpleUserInfo(cuser.getId());
        UserAccountSimpleDTO userAccountSimpleDTO = userClient.feignGetUserSimpleInfo(cuser.getUserAccountId(), null);
        if (StringUtils.isEmpty(userAccountSimpleDTO.getPhoneNum())) {
            return ResultBody.error(ResultEnum.AUTH_ACCOUNT_ERROR);
        }
        //每次添加只查看购物车是否存在规格一样的记录
        boolean flag = true;
        MallShopCarQO mallShopCarQO = new MallShopCarQO();
        mallShopCarQO.setGoodsInfoId(param.getGoodsInfoId());
        mallShopCarQO.setSaleStatus(0);
        mallShopCarQO.setUserAccountId(param.getUserAccountId());
        //判断是产品还是行业
        if(param.getDirectoryId().equals(1)){
            //同一个商品则先查购物车有几条记录，再看规格是否有相同的
            List<MallProdShopCarDO> mallProdShopCarDOS = shoppingTrolleyDao.listMallProdShopCar(mallShopCarQO);
            for (MallProdShopCarDO mallProdShopCarDO : mallProdShopCarDOS){
                Set<Integer> specIds = mallProdShopCarDO.getShopCarDetailDOS().stream().map(MallProdShopCarDetailDO::getMallProdSkuInfoSpecId).collect(Collectors.toSet());
                //看是否要加入购物车。查看要加入购物车的商品是否已存在，存在则不需要加入
                if(CollectionUtils.isEqualCollection(param.getMallSkuSpecIds(), specIds)){
                    //已存在购物车时，数量修改
                    shoppingTrolleyDao.addProdShopCarBuyNum(mallProdShopCarDO.getId(), param.getBuyNum());
                    flag = false;
                    break;
                }
            }
            if(flag){
                //需要加入购物车
                MallProdShopCarDO mallProdShopCarDO = new MallProdShopCarDO(param);
                shoppingTrolleyDao.insertMallProdShopCar(mallProdShopCarDO);
                shoppingTrolleyDao.batchInsertMallProdShopCarDetail(mallProdShopCarDO.getId(), param.getMallSkuSpecIds());
            }
//            else {
//                return ResultBody.error(ResultEnum.EXIST_THE_SAME_GOODS_ERROR);
//            }
        }else if((param.getDirectoryId().equals(2))){
            List<MallIndstShopCarDO> mallIndstShopCarDOS = shoppingTrolleyDao.listMallIndstShopCar(mallShopCarQO);
            for (MallIndstShopCarDO mallIndstShopCarDO : mallIndstShopCarDOS){
                Set<Integer> specIds = mallIndstShopCarDO.getShopCarDetailDOS().stream().map(MallIndstShopCarDetailDO::getMallIndstSkuInfoSpecId).collect(Collectors.toSet());
                //看是否要加入购物车。查看要加入购物车的商品是否已存在，存在则不需要加入
                if(CollectionUtils.isEqualCollection(param.getMallSkuSpecIds(), specIds)){
                    //已存在购物车时，数量修改
                    shoppingTrolleyDao.addIndstShopCarBuyNum(mallIndstShopCarDO.getId(), param.getBuyNum());
                    flag = false;
                    break;
                }
            }
            if(flag){
                //需要加入购物车
                MallIndstShopCarDO mallIndstShopCarDO = new MallIndstShopCarDO(param);
                shoppingTrolleyDao.insertMallIndstShopCar(mallIndstShopCarDO);
                shoppingTrolleyDao.batchInsertMallIndstShopCarDetail(mallIndstShopCarDO.getId(), param.getMallSkuSpecIds());
            }
//            else {
//                return ResultBody.error(ResultEnum.EXIST_THE_SAME_GOODS_ERROR);
//            }
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody batchRemove(Integer type, List<Integer> carIds, BaseAccountDTO currentAccount) {
        if (CollectionUtils.isEmpty(carIds)) {
            return ResultBody.error(ResultEnum.PARAM_DEFECT);
        }
        if(type.equals(1)){
            shoppingTrolleyDao.batchRemoveProd(currentAccount.getUserAccountId(), carIds);
        }else if((type.equals(2))){
            shoppingTrolleyDao.batchRemoveIndst(currentAccount.getUserAccountId(), carIds);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody listPage(Integer pageNo, Integer pageSize, BaseAccountDTO currentAccount) {

        MallShopCarQO mallShopCarQO = new MallShopCarQO();
        mallShopCarQO.setUserAccountId(currentAccount.getUserAccountId());
        mallShopCarQO.setSaleStatus(0);
        List<MallProdShopCarDO> mallProdShopCarDOS = shoppingTrolleyDao.listMallProdShopCar(mallShopCarQO);
        List<MallIndstShopCarDO> mallIndstShopCarDOS = shoppingTrolleyDao.listMallIndstShopCar(mallShopCarQO);

        List<MallGoodsShopCarDTO> mallGoodsShopCarDTOList = new ArrayList<MallGoodsShopCarDTO>();

        List<MallGoodsShopCarDTO> prodShopCarList = mallProdShopCarDOS.stream().map(MallProdShopCarDO::buildMallGoodsShopCarDTO).collect(Collectors.toList());
        List<MallGoodsShopCarDTO> indstShopCarList = mallIndstShopCarDOS.stream().map(MallIndstShopCarDO::buildMallGoodsShopCarDTO).collect(Collectors.toList());
        mallGoodsShopCarDTOList.addAll(prodShopCarList);
        mallGoodsShopCarDTOList.addAll(indstShopCarList);
        //调用商品信息和详细规格信息
        List<MallGoodsShopCarDTO> mallGoodsShopCarDTOList1 = pmsClient.fillGoodsInfo(mallGoodsShopCarDTOList, null);
        if(!CollectionUtils.isEmpty(mallGoodsShopCarDTOList1)){
            mallGoodsShopCarDTOList1.sort((d1, d2)->{
                return d2.getCreateTime().compareTo(d1.getCreateTime());
            });
        }
        return ResultBody.success(mallGoodsShopCarDTOList1);
    }

    @Override
    public ResultBody updateBuyNum(Integer directoryId, Integer mallShopCarId, Integer buyNum, BaseAccountDTO currentAccount) {
        if(directoryId.equals(1)){
            MallProdShopCarDO prodParam = new MallProdShopCarDO(mallShopCarId, buyNum);
            MallProdShopCarDO mallProdShopCarDO = shoppingTrolleyDao.getMallProdShopCar(prodParam);
            if(mallProdShopCarDO == null){
                return ResultBody.error(ResultEnum.SHOP_CAR_ERROR);
            }
            Integer changeNum = buyNum - mallProdShopCarDO.getBuyNum();
            if (changeNum < 0) {
                // 当数量为减少的时候，检测数量必须大于0
                if ((mallProdShopCarDO.getBuyNum() + changeNum) <= 0) {
                    return ResultBody.error(ResultEnum.BUY_NUM_ERROR);
                }
            }
            MallProdShopCarDO mallProdShopCarDO1 = new MallProdShopCarDO();
            mallProdShopCarDO1.setId(mallShopCarId);
            mallProdShopCarDO1.setBuyNum(changeNum);
            mallProdShopCarDO1.setUserAccountId(currentAccount.getUserAccountId());
            shoppingTrolleyDao.updateMallProdShopCar(mallProdShopCarDO1);
        }else if((directoryId.equals(2))){
            MallIndstShopCarDO indstParam = new MallIndstShopCarDO();
            indstParam.setId(mallShopCarId);
            MallIndstShopCarDO mallIndstShopCarDO = shoppingTrolleyDao.getMallIndstShopCar(indstParam);
            if(mallIndstShopCarDO == null){
                return ResultBody.error(ResultEnum.SHOP_CAR_ERROR);
            }
            Integer changeNum = buyNum - mallIndstShopCarDO.getBuyNum();
            if (changeNum < 0) {
                // 当数量为减少的时候，检测数量必须大于0
                if ((mallIndstShopCarDO.getBuyNum() + changeNum) <= 0) {
                    return ResultBody.error(ResultEnum.BUY_NUM_ERROR);
                }
            }
            MallIndstShopCarDO mallIndstShopCarDO1 = new MallIndstShopCarDO();
            mallIndstShopCarDO1.setId(mallShopCarId);
            mallIndstShopCarDO1.setBuyNum(changeNum);
            mallIndstShopCarDO1.setUserAccountId(currentAccount.getUserAccountId());
            shoppingTrolleyDao.updateMallIndstShopCar(mallIndstShopCarDO1);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody confirmShop(ConfirmMallOrderVO param, BaseAccountDTO cuser) {
        //查询用户信息
        //MallUserDTO muser = mallUserClient.feignGetSimpleUserInfo(cuser.getUserAccountId());
        UserAccountSimpleDTO userAccountSimpleDTO = userClient.feignGetUserSimpleInfo(cuser.getUserAccountId(), null);
        if (StringUtils.isEmpty(userAccountSimpleDTO.getPhoneNum())) {
            return ResultBody.error(ResultEnum.AUTH_ACCOUNT_ERROR);
        }
        ResultBody<ShopCarIdParamVO> shopCarIdParamVOResultBody = this.dealShopCarParam(param.getShopCarList(), cuser);
        if(!shopCarIdParamVOResultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())){
            return shopCarIdParamVOResultBody;
        }
        ShopCarIdParamVO shopCarIdParamVO = shopCarIdParamVOResultBody.getResult();
        ResultBody<ConfirmGoodsInfoDTO> confirmGoodsInfoDTOResultBody = appMallOrderService.confirmShop(shopCarIdParamVO.getMallProdShopCarDOS(), shopCarIdParamVO.getMallIndstShopCarDOS(), userAccountSimpleDTO);
        return confirmGoodsInfoDTOResultBody;
    }

//    @Override
//    public ResultBody listShoppingTrolleyExport(List<ConfirmShopVO> shopCarList, BaseAccountDTO currentAccount, HttpServletResponse response) throws IOException {
//        //查询用户信息
//        //MallUserDTO muser = mallUserClient.feignGetSimpleUserInfo(currentAccount.getId());
//        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(currentAccount.getUserAccountId(), null);
//        if (StringUtils.isEmpty(userAccountSimpleDTO.getPhoneNum())) {
//            return ResultBody.error(ResultEnum.AUTH_ACCOUNT_ERROR);
//        }
//        ResultBody<ShopCarIdParamVO> shopCarIdParamVOResultBody = this.dealShopCarParam(shopCarList, currentAccount);
//        if(!shopCarIdParamVOResultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())){
//            return ResultBody.error(ResultEnum.REQUEST_PARAM_ILLEGAL_ERROR);
//        }
//        ShopCarIdParamVO shopCarIdParamVO = shopCarIdParamVOResultBody.getResult();
//        ResultBody<ConfirmGoodsInfoDTO> confirmGoodsInfoDTOResultBody = appMallOrderService.confirmShop(shopCarIdParamVO.getMallProdShopCarDOS(), shopCarIdParamVO.getMallIndstShopCarDOS(), muser);
//
//        if(confirmGoodsInfoDTOResultBody.getCode().equals(ResultEnum.SPEC_NOT_CONFIG_PRICE.getResultCode())){
//            return ResultBody.error(ResultEnum.SPEC_NOT_CONFIG_PRICE);
//        }
//        List<ShoppingTrolleyProdExcel> shoppingTrolleyProdExcels = new ArrayList<>();
//        if(!CollectionUtils.isEmpty(confirmGoodsInfoDTOResultBody.getResult().getOrderGoodsProdDetailDTOS())){
//            ProductSpecPriceQO productSpecPriceQO = new ProductSpecPriceQO();
//            productSpecPriceQO.setMallUserId(currentAccount.getUserAccountId());
//            productSpecPriceQO.setChannelClass(currentAccount.getChannelClass());
//            List<Integer> productSpecIds = confirmGoodsInfoDTOResultBody.getResult().getOrderGoodsProdDetailDTOS().stream().map(d->d.getProductSpecId()).collect(Collectors.toList());
//            productSpecPriceQO.setProductSpecIds(productSpecIds);
//            //通过产品规格id查询对应的价格
//            List<MallProductSpecPriceDTO> mallProductSpecPriceDTOS = mallGoodsClient.feignListProductSpecPrice(productSpecPriceQO);
//            for (OrderGoodsProdDetailDTO orderGoodsProdDetailDTO : confirmGoodsInfoDTOResultBody.getResult().getOrderGoodsProdDetailDTOS()){
//                ShoppingTrolleyProdExcel shoppingTrolleyProdExcel = new ShoppingTrolleyProdExcel();
//                shoppingTrolleyProdExcel.setProductSpecId(orderGoodsProdDetailDTO.getProductSpecId());
//                shoppingTrolleyProdExcel.setProductName(orderGoodsProdDetailDTO.getProductName());
//                shoppingTrolleyProdExcel.setUnit(orderGoodsProdDetailDTO.getUnitName());
//                shoppingTrolleyProdExcel.setProductSpecImg(orderGoodsProdDetailDTO.getProdSkuSpecImage());
//                shoppingTrolleyProdExcel.setProductSpecName(orderGoodsProdDetailDTO.getSpecName());
//                shoppingTrolleyProdExcel.setBuyNum(orderGoodsProdDetailDTO.getBuyNum());
//                //找到对应的价格
//                for (MallProductSpecPriceDTO mallProductSpecPriceDTO : mallProductSpecPriceDTOS){
//                    if(orderGoodsProdDetailDTO.getProductSpecId().equals(mallProductSpecPriceDTO.getProductSpecId())){
//                        if(mallProductSpecPriceDTO.getOpPrice() == null){
//                            shoppingTrolleyProdExcel.setOpPrice(null);
//                        }else {
//                            shoppingTrolleyProdExcel.setOpPrice(mallProductSpecPriceDTO.getOpPrice().multiply(BigDecimal.valueOf(shoppingTrolleyProdExcel.getBuyNum())));
//                        }
//                        shoppingTrolleyProdExcel.setMkPrice(mallProductSpecPriceDTO.getMkPrice().multiply(BigDecimal.valueOf(shoppingTrolleyProdExcel.getBuyNum())));
//                        break;
//                    }
//                }
//                //统一放入待生成的list中
//                shoppingTrolleyProdExcels.add(shoppingTrolleyProdExcel);
//            }
//        }
//        if(!CollectionUtils.isEmpty(confirmGoodsInfoDTOResultBody.getResult().getOrderGoodsIndstProdListDTOS())){
//            for (OrderGoodsIndstProdListDTO orderGoodsIndstProdListDTO : confirmGoodsInfoDTOResultBody.getResult().getOrderGoodsIndstProdListDTOS()){
//                ShoppingTrolleyProdExcel shoppingTrolleyProdExcel = new ShoppingTrolleyProdExcel();
//                shoppingTrolleyProdExcel.setProductSpecId(orderGoodsIndstProdListDTO.getProductSpecId());
//                shoppingTrolleyProdExcel.setProductName(orderGoodsIndstProdListDTO.getProductName());
//                shoppingTrolleyProdExcel.setUnit(orderGoodsIndstProdListDTO.getUnitName());
//                shoppingTrolleyProdExcel.setProductSpecImg(orderGoodsIndstProdListDTO.getProdSkuSpecImage());
//                shoppingTrolleyProdExcel.setProductSpecName(orderGoodsIndstProdListDTO.getProdSkuSpecName());
//                shoppingTrolleyProdExcel.setBuyNum(orderGoodsIndstProdListDTO.getBuyNum());
//                //统一放入待生成的list中
//                shoppingTrolleyProdExcels.add(shoppingTrolleyProdExcel);
//            }
//        }
//
//        Collection<ShoppingTrolleyProdExcel> collection = shoppingTrolleyProdExcels;
//        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams("无人机城购物车数据", "购物车信息"), ShoppingTrolleyProdExcel.class, collection);
//        String fileName = "shopCart" + TDateUtil.getDateStr(new Date(), "yyyyMMddHHmmss");
//        return ResultBody.success(uploadHandler.uploadWorkBook(workbook, fileName));
//    }

    private ResultBody<ShopCarIdParamVO> dealShopCarParam(List<ConfirmShopVO> shopCarList, BaseAccountDTO cuser){
        UUID uuid = UUID.randomUUID();
        ShopCarIdParamVO shopCarIdParamVO = new ShopCarIdParamVO();
        if (org.springframework.util.CollectionUtils.isEmpty(shopCarList)) {
            return ResultBody.error(ResultEnum.PARAM_DEFECT);
        }
        //对购物车id进行分类，产品或行业
        Set<Integer> prodIds = new HashSet<>();
        Set<Integer> indstIds = new HashSet<>();
        for (ConfirmShopVO confirmShopVO : shopCarList ){
            if (confirmShopVO.getDirectoryId().toString().equals("1")){
                prodIds.add(confirmShopVO.getShopCarId());
            }
            if (confirmShopVO.getDirectoryId().toString().equals("2")){
                indstIds.add(confirmShopVO.getShopCarId());
            }
        }
        log.info("线程id[{}],prodIds==>[{}],indstIds==>[{}]",uuid, JSONObject.toJSONString(prodIds), JSONObject.toJSONString(indstIds));
        List<MallProdShopCarDO> mallProdShopCarDOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(prodIds)){
            MallShopCarQO prodMallShopCarQO = new MallShopCarQO();
            prodMallShopCarQO.setUserAccountId(cuser.getUserAccountId());
            prodMallShopCarQO.setCarIds(prodIds);
            mallProdShopCarDOS = shoppingTrolleyDao.listMallProdShopCar(prodMallShopCarQO);
            shopCarIdParamVO.setMallProdShopCarDOS(mallProdShopCarDOS);
        }
        List<MallIndstShopCarDO> mallIndstShopCarDOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(indstIds)){
            MallShopCarQO indstMallShopCarQO = new MallShopCarQO();
            indstMallShopCarQO.setUserAccountId(cuser.getUserAccountId());
            indstMallShopCarQO.setCarIds(indstIds);
            mallIndstShopCarDOS = shoppingTrolleyDao.listMallIndstShopCar(indstMallShopCarQO);
            shopCarIdParamVO.setMallIndstShopCarDOS(mallIndstShopCarDOS);
        }
        log.info("线程id[{}],mallProdShopCarDOS==>[{}],mallIndstShopCarDOS==>[{}]",uuid, JSONObject.toJSONString(mallProdShopCarDOS), JSONObject.toJSONString(mallIndstShopCarDOS));
        if(CollectionUtils.isEmpty(mallProdShopCarDOS) && CollectionUtils.isEmpty(mallIndstShopCarDOS)){
            return ResultBody.error(ResultEnum.GOODS_VERSION_ERROR);
        }
        return ResultBody.success(shopCarIdParamVO);
    }
}
