package com.mmc.oms.service.mall.impl;

import com.mmc.oms.common.RedisConstant;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.mall.OrderExpressDao;
import com.mmc.oms.entity.mall.MallOrderExpressDO;
import com.mmc.oms.model.dto.order.ExpressInfoDTO;
import com.mmc.oms.model.vo.mall.MallOrderExpressVO;
import com.mmc.oms.service.mall.OrderExpressService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 作者 geDuo
 * @version 创建时间：2022年3月23日 下午5:21:14
 * @explain 类说明
 */
@Service
public class OrderExpressServiceImpl implements OrderExpressService {

	@Autowired
	private OrderExpressDao orderExpressDao;

	@Resource
	private RedisTemplate<String, ExpressInfoDTO> redisTemplate;



	@Override
	public List<ExpressInfoDTO> listExpressInfo() {
		List<ExpressInfoDTO> list = redisTemplate.opsForList().range(RedisConstant.UAV_MALL_EXP_COM, 0, -1);
		if (CollectionUtils.isEmpty(list)) {
			list = orderExpressDao.listExpressInfo().stream().map(d -> {
				return d.buildExpressInfoDTO();
			}).collect(Collectors.toList());
			redisTemplate.opsForList().leftPushAll(RedisConstant.UAV_MALL_EXP_COM,list);
		}
		return list;
	}

	@Override
	public ResultBody updateOrderExpress(MallOrderExpressVO orderExpressVO) {
		MallOrderExpressDO orderExpressDO = new MallOrderExpressDO(orderExpressVO);
		orderExpressDao.updateOrderExpress(orderExpressDO);
		return ResultBody.success();
	}

}
