package com.mmc.oms.service.mall.impl;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.mall.OrderExpressDao;
import com.mmc.oms.model.vo.mall.OrderPayVO;
import com.mmc.oms.service.mall.MallOrderService;
import com.mmc.oms.service.mall.MallOrderServiceSub;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * author:zhenjie
 * Date:2023/2/13
 * time:14:31
 */
@Service
@Slf4j
public class MallOrderServiceSubImpl implements MallOrderServiceSub {

    @Autowired
    MallOrderService mallOrderService;

    @Autowired
    OrderExpressDao orderExpressDao;

    @Override
    public ResultBody feignAutoCompleteMOrder() {
        //查询需要自动完成的订单（签收超过3*24小时后的订单）
        List<Integer> orderIds = orderExpressDao.listReceivedOrderIds();
        //调用确认收货功能，但是没有上传验收单
        for (Integer orderId : orderIds){
            OrderPayVO orderPayVO = new OrderPayVO();
            orderPayVO.setOrderId(orderId);
            mallOrderService.confirmReceipt(orderPayVO, null);
        }
        return ResultBody.success();
    }
}
