package com.mmc.oms.service.mall.impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.*;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.KdnExpressUtil;
import com.mmc.oms.common.util.TDateUtil;
import com.mmc.oms.dao.mall.OrderExpressDao;
import com.mmc.oms.entity.mall.MallOrderExpressDO;
import com.mmc.oms.model.dto.kdn.KdnDicDTO;
import com.mmc.oms.service.mall.KdnExpService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author 作者 geDuo
 * @version 创建时间：2022年3月23日 下午6:13:56
 * @explain 类说明
 */
@Service
@Slf4j
public class KdnExpServiceImpl implements KdnExpService {

	@Autowired
	private OrderExpressDao orderExpressDao;

	@Resource
	private RedisTemplate<String, KdnDicDTO> redisTemplate;

	@Override
	public List<KdnDicDTO> listKdnDic() {
		List<KdnDicDTO> list = redisTemplate.opsForList().range(RedisConstant.UAV_MALL_EXP_STATUS, 0, -1);
		if (CollectionUtils.isEmpty(list)) {
			list = orderExpressDao.listKdnDic().stream().map(d -> {
				return d.buildKdnDicDTO();
			}).collect(Collectors.toList());
		}
		return list;
	}

	@Override
	public KDNCallBackResponse callbackExpressInfo(Map<String, Object> map) {
		log.info("--------------ExpressInfo----------------");
		log.info(map.toString());
		log.info("--------------ExpressInfo----------------");
		JSONObject requestDataObj = JSONObject.parseObject(map.get("RequestData").toString());
		log.info("--------------ExpressInfo-------直接---------》" + requestDataObj.toString());
		if( map.get("RequestData") != null ){
			log.info("--------------ExpressInfo-------DATA---------》" + requestDataObj.getJSONArray("Data").toString());
			for ( Object object : requestDataObj.getJSONArray("Data")){
				JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSON(object).toString());
				log.info("--------------ExpressInfo--准备签收--prepare----------------");
				if(jsonObject.getString("State").equals("3")){
					//快递已签收，进行订单状态修改
					String callBack = jsonObject.getString("CallBack");
					String[]orderTag = callBack.split("-");
					if(orderTag.length > 1 && orderTag[0].equals("UAV")){
						Integer orderId = Integer.parseInt(orderTag[1]);
						MallOrderExpressDO orderExpressDO = new MallOrderExpressDO();
						orderExpressDO.setOrderId(orderId);
						orderExpressDO.setReceiveTime(new Date());
						orderExpressDO.setReceive(1);
						log.info("--------------ExpressInfo--签收成功----------------");
						orderExpressDao.updateOrderExpress(orderExpressDO);
					}
				}
			}
		}
		return KDNCallBackResponse.builder().EBusinessID("1741818").Reason("").Success(true).UpdateTime(TDateUtil.getCurrentDateMidd()).build();
	}

	@Override
	public ResultBody testCallbackExpressInfo(String port, Integer orderId, String shipperCode, String logisticCode, String phone) throws Exception {
		String s = KdnExpressUtil.monitorPush(port, orderId, shipperCode, logisticCode, phone);
		if(!JSONObject.parseObject(s).getString("Success").equals("true")){
			throw new BizException("快递信息错误，请重新填写后发货！");
		}
		return ResultBody.success(s) ;
	}
}
