package com.mmc.oms.service.demand.Impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.RedisConstant;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.json.JsonUtil;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.demand.util.EmojiUtils;
import com.mmc.oms.dao.demand.DemandReleaseOrderDao;
import com.mmc.oms.entity.demand.DemandReleaseOrderDO;
import com.mmc.oms.model.dto.mall.ProductSpecPriceDTO;
import com.mmc.oms.model.dto.order.OrderInfoDTO;
import com.mmc.oms.model.vo.demand.CommonPaymentVO;
import com.mmc.oms.model.vo.demand.DemandReleaseOrderVO;
import com.mmc.oms.model.vo.demand.OrderRequestParamsVO;
import com.mmc.oms.model.vo.demand.UserPayInfoVO;
import com.mmc.oms.service.demand.DemandReleaseOrderService;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author small
 * @Date 2023/7/25 15:49
 * @Version 1.0
 */
@Service
public class DemandReleaseOrderServiceImpl implements DemandReleaseOrderService {

    @Autowired
    private DemandReleaseOrderDao releaseOrderDao;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${payment.url}")
    private String paymentUrl;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public ResultBody publish(DemandReleaseOrderVO demandReleaseOrderVO, HttpServletRequest request) {
        DemandReleaseOrderDO requirementsInfoDO = new DemandReleaseOrderDO(demandReleaseOrderVO);
        releaseOrderDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody orderPayment(CommonPaymentVO commonPaymentVO, HttpServletRequest request, Integer userAccountId) {
        String token = request.getHeader("token");

        if ("3".equals(commonPaymentVO.getOrderPort().toString())){
            DemandReleaseOrderDO demandReleaseOrderDO = releaseOrderDao.orderPayment(commonPaymentVO.getOrderNumber());
            BigDecimal paramMoney = demandReleaseOrderDO.getParamMoney();
            BigDecimal multiply = paramMoney.multiply(new BigDecimal(100));
            int i = multiply.intValue();
            OrderRequestParamsVO orderRequestParamsVO = demandReleaseOrderDO.buildOrderRequestParamsVO();
            orderRequestParamsVO.setAmount(i);
            BigDecimal practicalMoney = demandReleaseOrderDO.getPracticalMoney();
            if (practicalMoney!=null){
                return  ResultBody.error(ResultEnum.THE_CURRENT_DEMAND_IS_PAID);
            }
            if (i!=0){
              return releaseOrder(orderRequestParamsVO, token);
            }else if(i==0){
             return  ResultBody.error(ResultEnum.NO_PAYMENT_REQUIRED);
            }
        }
        return ResultBody.success();
    }


    @Override
    public ResultBody getPublishPhone(CommonPaymentVO commonPaymentVO, HttpServletRequest request, Integer userAccountId) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<UserPayInfoVO> exchange = restTemplate.exchange(paymentUrl + "/wechat/queryUserPayInfo" + "?orderNo=" + commonPaymentVO.getOrderNumber(), HttpMethod.GET, entity, UserPayInfoVO.class);

        UserPayInfoVO body = exchange.getBody();
        if ( body.getWxNotifyPayerTotal()!=null){
            BigDecimal divide = BigDecimal.valueOf(Long.valueOf(body.getWxNotifyPayerTotal())).divide(new BigDecimal(100));
            DemandReleaseOrderDO requirementsInfoDO = new DemandReleaseOrderDO(body,divide);
            releaseOrderDao.updateOrderDemand(requirementsInfoDO);
            DemandReleaseOrderDO demandReleaseOrderDO = releaseOrderDao.selectPhone(requirementsInfoDO.getOrderNumber());
            stringRedisTemplate.opsForValue().set(demandReleaseOrderDO.getRequirementsInfoId().toString(), JsonUtil.parseObjToJson(demandReleaseOrderDO));
           return ResultBody.success(demandReleaseOrderDO.getPublishPhone());
        }
        return ResultBody.success();
    }

    public ResultBody releaseOrder(OrderRequestParamsVO orderRequestParamsVO, String token) {
        boolean emoji  = EmojiUtils.containsEmoji(orderRequestParamsVO.getDescription());
        if (emoji==true){
            orderRequestParamsVO.setDescription(EmojiUtils.emojiConverter2Html(orderRequestParamsVO.getDescription()));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(orderRequestParamsVO), headers);
        ResponseEntity<Object> exchange = null;
        Map<String , Object> map = new HashMap<>();
        try {
            exchange = restTemplate.exchange(paymentUrl + "wechat/pay", HttpMethod.POST, entity, Object.class);
        map.put("Ok", exchange.getBody());
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THIRD_PARTY_ERRORS);
        }
        return ResultBody.success(map);
    }
}
