package com.mmc.oms.service.Impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.mmc.oms.common.MsgData;
import com.mmc.oms.common.WxMsgDataConfig;
import com.mmc.oms.common.coupon.CouponConstants;
import com.mmc.oms.common.coupon.CouponType;
import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.TDateUtil;
import com.mmc.oms.config.FlyerSystemConstant;
import com.mmc.oms.dao.CouponBackDao;
import com.mmc.oms.dao.CouponUserDao;
import com.mmc.oms.entity.coupon.CouponDO;
import com.mmc.oms.entity.coupon.CouponUsageDetailsDO;
import com.mmc.oms.entity.coupon.CouponUserDO;
import com.mmc.oms.entity.goods.GoodsInfoDO;
import com.mmc.oms.model.dto.coupon.CouponListDTO;
import com.mmc.oms.model.dto.coupon.CouponUsageDetailsDTO;
import com.mmc.oms.model.dto.coupon.CouponUserDTO;
import com.mmc.oms.model.dto.coupon.CouponUserOrderDTO;
import com.mmc.oms.model.dto.goods.AppGoodsInfoDTO;
import com.mmc.oms.model.dto.order.OrderCouponDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.MallUserDTO;
import com.mmc.oms.model.qo.CouponUserInfoQO;
import com.mmc.oms.model.vo.coupon.AppletMsgVO;
import com.mmc.oms.model.vo.coupon.CouponUserExchangeVO;
import com.mmc.oms.model.vo.coupon.CouponUserVO;
import com.mmc.oms.model.vo.wx.WxSendMsgVO;
import com.mmc.oms.service.CouponBackService;
import com.mmc.oms.service.CouponUserService;
import com.mmc.oms.wx.WxMsgTemplete;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/24 16:07
 * @Version 1.0
 */
@Service
@Slf4j
public class CouponUserServiceImpl extends ServiceImpl<CouponUserDao, CouponUserDO> implements CouponUserService {

    @Resource
    private CouponBackService couponBackService;

    @Autowired
    private TransactionTemplate transactionTemplate;

    // @Autowired
    //private MallUserClient mallUserClient;

    @Resource
    private CouponUserDao couponUserDao;

    @Resource
    private CouponBackDao couponBackDao;

    // @Autowired
    // private UserServletClient userServletClient;

    //VIP优惠券
    private final Integer VIPCOUPON = 1;
    private final Integer BRAND_COUPONS = 2;


    @Override
    public ResultBody getMyList(Integer status, Integer pageNo, Integer pageSize, BaseAccountDTO currentAccount) {
        Integer uid = currentAccount.getUserAccountId();
        LambdaQueryWrapper<CouponUserDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CouponUserDO::getUid, uid);
        if (status == null) {
            // 未使用及使用中
            queryWrapper.and(wq -> wq.eq(CouponUserDO::getStatus, CouponConstants.STORE_COUPON_USER_STATUS_USABLE)
                    .or().eq(CouponUserDO::getStatus, CouponConstants.STORE_COUPON_USER_STATUS_IN_USE));
        } else {
            queryWrapper.and(wq -> wq.eq(CouponUserDO::getStatus, status));
        }
        queryWrapper.orderByDesc(CouponUserDO::getCreateTime);
        Page<CouponUserDO> pages = new Page<>(pageNo, pageSize);
        Page<CouponUserDO> pageInfo = this.page(pages, queryWrapper);

        List<CouponUserDTO> collect = pageInfo.getRecords().stream().map(CouponUserDO::bilIdCouponDTO)
                .collect(Collectors.toList());

        PageResult pageResult = PageResult.buildPage(pageNo, pageSize, (int) pageInfo.getTotal(), collect);
        return ResultBody.success(pageResult);
    }


    @Override
    public ResultBody receiveCoupon(Integer id, BaseAccountDTO currentAccount) {
        //获取优惠券信息
        CouponDO couponDO = couponBackService.getById(id);
        if (couponDO == null) {
            return ResultBody.error("暂无该优惠券");
        }

        //查看优惠券状态 开启并且未删除
        if (!couponDO.getCouponStatus() || couponDO.getIsDel()) {
            return ResultBody.error("该优惠券已结束,不可领取");
        }
        //查看当前优惠券剩余量
        if (couponDO.getIsLimited() && couponDO.getLastTotal() < 1) {
            return ResultBody.error("当前剩余量不够领取");
        }

        //判定当前领取人 认证相关信息
//        if (couponDO.getUserTag() != null){
//            Integer useTag = couponDO.getUserTag();
//            MallUserDTO mallUserDTO = mallUserClient.feignGetSimpleUserInfo(currentAccount.getId());
//
//            if (CouponConstants.USER_LABEL_REAL_NAME_AUTHENTICATION.equals(useTag) && mallUserDTO.getRealAuthStatus() != 1 ){
//                return ResultBody.error("该用户实名认证未通过");
//            }
//            if (CouponConstants.USER_LABEL_ENTERPRISE_CERTIFICATION.equals(useTag) && mallUserDTO.getEntVerifyStatus() != 1){
//                return ResultBody.error("该用户企业认证未通过");
//            }
//        }

        if (!couponDO.getGetType().equals(CouponConstants.COUPON_USR_TYPE_ACTIVITY)) {
            //查看当前优惠券是否限制每人领取
            LambdaQueryWrapper<CouponUserDO> queryWrap = new LambdaQueryWrapper<>();
            queryWrap.eq(CouponUserDO::getUid, currentAccount.getUserAccountId()).eq(CouponUserDO::getCouponId, id);
            long count = this.count(queryWrap);
            if (count >= couponDO.getRestrictedAccess()) {
                return ResultBody.error("已领取,不可重复领取");
            }
        }

        //优惠券有效期使用时间
        Integer couponDay = couponDO.getCouponDay();
        DateTime date = DateUtil.date();
        if (CouponConstants.COUPON_USE_TIME_THE_DAY.equals(couponDO.getIsFixedTime())) {
            //领取当日起
            couponDO.setUseStartTime(date);
            couponDO.setUseEndTime(DateUtil.offsetDay(date, couponDay));
        } else if (CouponConstants.COUPON_USE_TIME_NEXT_DAY.equals(couponDO.getIsFixedTime())) {
            //领取次日起
            DateTime dateTime = DateUtil.offsetDay(date, 1);
            couponDO.setUseStartTime(dateTime);
            couponDO.setUseEndTime(DateUtil.offsetDay(dateTime, couponDay));
        }

        CouponUserDO couponUser = new CouponUserDO(couponDO);
        couponUser.setUid(currentAccount.getUserAccountId());
        couponUser.setUuid(currentAccount.getUid());
        couponUser.setUserPhone(currentAccount.getPhoneNum());
        //如果优惠券是活动券 则为活动领取
        if (CouponConstants.COUPON_USR_TYPE_ACTIVITY.equals(couponDO.getGetType())) {
            couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_ACTIVITY);
            //如果优惠券用户标签不为空 则为系统发放
        } else if (couponDO.getUserTag() != null) {
            couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_SEND);
        } else {
            couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_GET);
        }
        couponUser.setCreateTime(date);
        List<CouponUserDO> couponUserList = new ArrayList<>();
        //系统发放的同一张优惠券如果每人限领数量在多次以上 一次性领取多张
        if (CouponConstants.COUPON_ISSUE_TYPE_INITIATIVE.equals(couponDO.getGetType())) {
            Integer restrictedAccess = couponDO.getRestrictedAccess();
//            if (restrictedAccess > 1){
//                for (Integer integer = 0; integer < restrictedAccess; integer++) {
//                    couponUserList.add(couponUser);
//                }
//            }
            for (Integer integer = 0; integer < restrictedAccess; integer++) {
                couponUserList.add(couponUser);
            }
        } else {
            couponUserList.add(couponUser);
        }
        Boolean execute = transactionTemplate.execute(e -> {
            this.saveBatch(couponUserList);
            //扣减数量
            couponBackService.deduction(couponDO.getId(), couponUserList.size(), couponDO.getIsLimited());
            return Boolean.TRUE;
        });

        if (execute) {
            asynSendUserAppletMsg(currentAccount.getUserAccountId(), couponDO);
            return ResultBody.success();
        } else {
            return ResultBody.error("领取失败,请稍后再试");
        }

    }

    public void asynSendUserAppletMsg(Integer userId, CouponDO couponDO) {
        BigDecimal couponMoney = couponDO.getCouponMoney();
        MallUserDTO mallUserDTO = null;
        // mallUserClient.feignGetSimpleUserInfo(userId);
        if (Objects.nonNull(mallUserDTO)) {
            AppletMsgVO aMsg = new AppletMsgVO();
            aMsg.setTouser(mallUserDTO.getOpenId());
            aMsg.setTemplate_id(WxMsgTemplete.BOUNTY_ACCOUNT_INFORM);
            aMsg.setPage(WxMsgDataConfig.M_ORDER_STATUS_COUPON_DETAILS_PAGE);
            // 奖励类型
            JSONObject thing1 = new JSONObject();
            // 时间
            JSONObject time3 = new JSONObject();
            time3.put("value", DateUtils.format(new Date()));
            // 奖励金额
            JSONObject amount2 = new JSONObject();
            //备注
            JSONObject thing4 = new JSONObject();
            //打折券
            if (CouponType.DISCOUNT_COUPONS.equals(couponDO.getCouponType())) {
                //无门槛
                // 奖励类型
                thing1.put("value", "折扣优惠券奖励");
                // 奖励金额
                amount2.put("value", null);
                // 备注
                thing4.put("value", String.format("恭喜，%s折优惠券已到账", couponDO.getCouponDiscount()));
            } else if (CouponType.REDUCTION_ROLLS.equals(couponDO.getCouponType())) {
                //满减
                // 奖励类型
                thing1.put("value", "满减优惠券奖励");
                // 奖励金额
                amount2.put("value", null);
                // 备注
                thing4.put("value", String.format("恭喜，满%s减%s优惠券已到账", couponDO.getMinPrice(), couponDO.getCouponMoney()));
            } else if (CouponType.NO_THRESHOLD.equals(couponDO.getCouponType())) {
                //无门槛
                // 奖励类型
                thing1.put("value", "奖励到账通知");
                amount2.put("value", couponMoney);
                // 备注
                String format = String.format("恭喜，%s元平台优惠券已到账", couponMoney);
                thing4.put("value", format);
            }
            JSONObject data = new JSONObject();
            data.put("thing1", thing1);
            data.put("amount2", amount2);
            data.put("time3", time3);
            data.put("thing4", thing4);
            aMsg.setData(data);
            // mallUserClient.asynSendUserAppletMsg(aMsg);
        }
    }

    @Override
    public ResultBody receiveCouponList(List<Integer> id, BaseAccountDTO currentAccount) {
        //批量获取优惠券信息
        List<CouponDO> couponDOS = couponBackService.listByIds(id);
        Boolean execute = true;
        StringBuffer sb = new StringBuffer();
        List<Integer> list = new ArrayList<>();
        if (couponDOS.size() > 0) {
            for (CouponDO couponDO : couponDOS) {
                //查看优惠券状态 开启并且未删除
                if (!couponDO.getCouponStatus() || couponDO.getIsDel()) {
                    sb.append("优惠券名称:" + couponDO.getCouponName() + "-该优惠券已结束,不可领取;");
                    list.add(couponDO.getId());
                    continue;
                }
                //查看当前优惠券剩余量
                if (couponDO.getIsLimited() && couponDO.getLastTotal() < 1) {
                    sb.append("优惠券名称:" + couponDO.getCouponName() + "-该优惠券当前剩余量不够领取;");
                    list.add(couponDO.getId());
                    continue;
                }
                //查看当前优惠券是否限制每人领取
                if (couponDO.getIsLimited()) {
                    LambdaQueryWrapper<CouponUserDO> queryWrap = new LambdaQueryWrapper<>();
                    queryWrap.eq(CouponUserDO::getUid, currentAccount.getUserAccountId()).eq(CouponUserDO::getCouponId, couponDO.getId());
                    long count = this.count(queryWrap);
                    if (count >= couponDO.getRestrictedAccess()) {
                        sb.append("优惠券名称:" + couponDO.getCouponName() + "-该优惠券已领取,不可重复领取;");
                        list.add(couponDO.getId());
                        continue;
                    }
                }

                //优惠券有效期使用时间
                Integer couponDay = couponDO.getCouponDay();
                DateTime date = DateUtil.date();
                if (CouponConstants.COUPON_USE_TIME_THE_DAY.equals(couponDO.getIsFixedTime())) {
                    //领取当日起
                    couponDO.setUseStartTime(date);
                    couponDO.setUseEndTime(DateUtil.offsetDay(date, couponDay));
                } else if (CouponConstants.COUPON_USE_TIME_NEXT_DAY.equals(couponDO.getIsFixedTime())) {
                    //领取次日起
                    DateTime dateTime = DateUtil.offsetDay(date, 1);
                    couponDO.setUseStartTime(dateTime);
                    couponDO.setUseEndTime(DateUtil.offsetDay(dateTime, couponDay));
                }
                CouponUserDO couponUser = new CouponUserDO(couponDO);
                couponUser.setUid(currentAccount.getUserAccountId());
                couponUser.setUuid(currentAccount.getUid());
                couponUser.setUserPhone(currentAccount.getPhoneNum());
                //如果优惠券是活动券 则为活动领取
                if (CouponConstants.COUPON_USR_TYPE_ACTIVITY.equals(couponDO.getGetType())) {
                    couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_ACTIVITY);
                    //如果优惠券用户标签不为空 则为系统发放
                } else if (couponDO.getUserTag() != null) {
                    couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_SEND);
                } else {
                    couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_GET);
                }
                couponUser.setCreateTime(date);
                List<CouponUserDO> couponUserList = new ArrayList<>();
                //系统发放的同一张优惠券如果每人限领数量在多次以上 一次性领取多张
                if (CouponConstants.COUPON_ISSUE_TYPE_INITIATIVE.equals(couponDO.getGetType())) {
                    Integer restrictedAccess = couponDO.getRestrictedAccess();
                    for (Integer integer = 0; integer < restrictedAccess; integer++) {
                        couponUserList.add(couponUser);
                    }
                } else {
                    couponUserList.add(couponUser);
                }
                execute = transactionTemplate.execute(e -> {
                    this.saveBatch(couponUserList);
                    //扣减数量
                    couponBackService.deduction(couponDO.getId(), couponUserList.size(), couponDO.getIsLimited());
                    return Boolean.TRUE;
                });
            }
        }

        if (execute) {
            List<CouponDO> collect = couponDOS.stream().filter(e -> {
                for (Integer integer : list) {
                    if (integer.equals(e.getId())) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
            log.info("消息发送成功" + collect);
            collect.stream().forEach(t -> {
                asynSendUserAppletMsgList(currentAccount.getUserAccountId(), t);
            });
            return ResultBody.success(sb);
        } else {
            return ResultBody.error("领取失败,请稍后再试");
        }

    }


    public void asynSendUserAppletMsgList(Integer userId, CouponDO couponDO) {
        BigDecimal couponMoney = couponDO.getCouponMoney();
        MallUserDTO mallUserDTO = null;
        //mallUserClient.feignGetSimpleUserInfo(userId);
        if (Objects.nonNull(mallUserDTO)) {
            AppletMsgVO aMsg = new AppletMsgVO();
            aMsg.setTouser(mallUserDTO.getOpenId());
            aMsg.setTemplate_id(WxMsgTemplete.BOUNTY_ACCOUNT_INFORM);
            aMsg.setPage(WxMsgDataConfig.M_ORDER_STATUS_COUPON_DETAILS_PAGE);
            // 奖励类型
            JSONObject thing1 = new JSONObject();
            // 时间
            JSONObject time3 = new JSONObject();
            time3.put("value", DateUtils.format(new Date()));
            // 奖励金额
            JSONObject amount2 = new JSONObject();
            //备注
            JSONObject thing4 = new JSONObject();
            //打折券
            if (CouponType.DISCOUNT_COUPONS.equals(couponDO.getCouponType())) {
                //打折券
                // 奖励类型
                thing1.put("value", "折扣优惠券奖励");
                // 奖励金额
                amount2.put("value", null);
                // 备注
                thing4.put("value", String.format("恭喜，%s折优惠券已到账", couponDO.getCouponDiscount()));
            } else if (CouponType.REDUCTION_ROLLS.equals(couponDO.getCouponType())) {
                //满减
                // 奖励类型
                thing1.put("value", "满减优惠券奖励");
                // 奖励金额
                amount2.put("value", null);
                // 备注
                thing4.put("value", String.format("恭喜，满%s减%s优惠券已到账", couponDO.getMinPrice(), couponDO.getCouponMoney()));
            } else if (CouponType.NO_THRESHOLD.equals(couponDO.getCouponType())) {
                //无门槛
                // 奖励类型
                thing1.put("value", "奖励到账通知");
                amount2.put("value", couponMoney);
                // 备注
                String format = String.format("恭喜，%s元平台优惠券已到账", couponMoney);
                thing4.put("value", format);
            }
            JSONObject data = new JSONObject();
            data.put("thing1", thing1);
            data.put("amount2", amount2);
            data.put("time3", time3);
            data.put("thing4", thing4);
            aMsg.setData(data);
            // mallUserClient.asynSendUserAppletMsg(aMsg);
        }
    }

    @Override
    public ResultBody presentedCoupon(Integer id, String uid, BaseAccountDTO currentAccount) {
        CouponUserDO couponUser = getById(id);
        if (couponUser == null) {
            return ResultBody.error("该优惠券不存在");
        }
        if (CouponConstants.STORE_COUPON_USER_STATUS_USED.equals(couponUser.getStatus()) ||
                CouponConstants.STORE_COUPON_USER_STATUS_IN_USE.equals(couponUser.getStatus())) {
            return ResultBody.error("该优惠券已使用不能转赠");
        }
        if (CouponConstants.STORE_COUPON_USER_TYPE_ACTIVITY.equals(couponUser.getGainType())) {
            return ResultBody.error("该优惠券不能转赠");
        }
        String uuid = "UID" + uid;
        PageResult<List<MallUserDTO>> listPageResult = null;
        // mallUserClient.feignMallUserBySearchKey(uuid, 1, 10);
        if (listPageResult != null && listPageResult.getList() != null) {
            List<MallUserDTO> list = listPageResult.getList();
            MallUserDTO mallUserDTO = list.get(0);
            CouponUserDO couponUserDO = new CouponUserDO();
            BeanUtils.copyProperties(couponUser, couponUserDO);

            //修改原用户数据
            couponUser.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_PRESENTED);
            couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_PRESENTED);
            couponUser.setCreateTime(new Date());
            couponUser.setReceiveUid(uuid);
            couponUser.setTransferorTime(new Date());

            //修改获赠用户优惠券数据
            couponUserDO.setId(null);
            couponUserDO.setUid(mallUserDTO.getId());
            couponUserDO.setUuid(mallUserDTO.getUid());
            couponUserDO.setUserPhone(mallUserDTO.getPhoneNum());
            couponUserDO.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_ACQUIRE);
            couponUserDO.setCreateTime(new Date());
            couponUserDO.setTransferorUid(currentAccount.getUid());

            Boolean execute = transactionTemplate.execute(e -> {
                this.save(couponUserDO);
                this.updateById(couponUser);
                return Boolean.TRUE;
            });
            if (execute) {
                Integer useType = couponUser.getUseType();
                if (VIPCOUPON.equals(useType)) {
                    asynSendMessage(couponUser.getUid(), couponUser.getCouponMoney());
                }
                return ResultBody.success();
            } else {
                return ResultBody.error("转增失败,请稍后再试");
            }
        } else {
            return ResultBody.error("该用户不存在");
        }
    }


    public void asynSendMessage(Integer userId, BigDecimal couponMoney) {
        MallUserDTO mallUserDTO = null;
        //mallUserClient.feignGetSimpleUserInfo(userId);
        if (Objects.nonNull(mallUserDTO)) {
            WxSendMsgVO param = new WxSendMsgVO();
            param.setWxAppltAppId(FlyerSystemConstant.AppletFlyerWxAppid);
            // 对接
            param.setAppletPath("page-activity/discount-list/index");
            param.setUnionId(mallUserDTO.getUnionId());
            // 获取模板id
            param.setTemplemteId(WxMsgTemplete.BOUNTY_ACCOUNT_INFORM);
            MsgData title = new MsgData();
            title.setValue("无人机城好友转赠优惠券");
            param.setTitle(title);
            List<MsgData> data = new ArrayList<MsgData>();
            MsgData k1 = new MsgData();
            k1.setValue("VIP优惠券");
            data.add(k1);
            MsgData k2 = new MsgData();
            k2.setValue(couponMoney + "");
            data.add(k2);
            MsgData k3 = new MsgData();
            k3.setValue(TDateUtil.getCurrentDate());
            data.add(k3);
            MsgData k4 = new MsgData();
            String format = String.format("恭喜，好友赠送%s元VIP优惠券已到账", couponMoney);
            k4.setValue(format);
            data.add(k4);
            param.setData(data);
            // param.setRemark(remark);
            // userServletClient.asynSendMessage(param);
        }
    }


    @Override
    public ResultBody getList(List<Integer> priority, Integer pageNo, Integer pageSize, BaseAccountDTO currentAccount) {
        String date = DateUtil.now();
        String categoryIdStr = priority.stream().map(Object::toString).collect(Collectors.joining("|"));
        StringBuffer sb = new StringBuffer();
        sb.append(",(").append(categoryIdStr).append(")");


        //目前只有 品牌优惠券可以主动领取
        Integer pageParam = (pageNo - 1) * pageSize;
        List<CouponDO> records = couponBackDao.selectCouponList(date, sb.toString(), pageParam, pageSize);
        Integer integer = couponBackDao.selectCouponCount(date, sb.toString());


        //获取用户当前已领取未使用的优惠券
        HashMap<Integer, CouponUserDO> couponUserMap = new HashMap<>();
        Integer userId = currentAccount.getUserAccountId();
        LambdaQueryWrapper<CouponUserDO> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(CouponUserDO::getUid, userId);
        List<CouponUserDO> list = this.list(lambdaQueryWrapper);
        for (CouponUserDO couponUserDO : list) {
            couponUserMap.put(couponUserDO.getCouponId(), couponUserDO);
        }

        List<CouponListDTO> couponFrontResponseArrayList = new ArrayList<>();
        for (CouponDO coupon : records) {
            CouponListDTO couponListDTO = coupon.bilIdCouponListDTO();

            if (userId > 0) {
                if (CollUtil.isNotEmpty(couponUserMap) && couponUserMap.containsKey(coupon.getId())) {
                    couponListDTO.setIsUse(true);
                    LambdaQueryWrapper<CouponUserDO> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(CouponUserDO::getUid, userId);
                    queryWrapper.eq(CouponUserDO::getCouponId, coupon.getId());
                    int count = Math.toIntExact(this.count(queryWrapper));
                    couponListDTO.setReceivedCount(count);
                }
            }
            couponFrontResponseArrayList.add(couponListDTO);
        }

        PageResult pageResult = PageResult.buildPage(pageNo, pageSize, integer, couponFrontResponseArrayList);
        return ResultBody.success(pageResult);
    }

    @Override
    public List<CouponUserOrderDTO> getUsableCoupon(List<Integer> primaryKey, Integer uid) {
        String categoryIdStr = primaryKey.stream().map(Object::toString).collect(Collectors.joining("|"));
        String date = DateUtil.now();
        StringBuffer sb = new StringBuffer();
        sb.append(",(").append(categoryIdStr).append(")");

        //可用优惠券
        List<CouponUserDO> couponUserDOS = couponUserDao.selectCouponUserList(sb.toString(), uid, date);
        List<CouponUserOrderDTO> collect = couponUserDOS.stream().map(CouponUserDO::buildCouponUserOrderDTO)
                .collect(Collectors.toList());

        //用户全部优惠券
        LambdaQueryWrapper<CouponUserDO> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(CouponUserDO::getUid, uid);
        lambdaQueryWrapper.ge(CouponUserDO::getEndTime, new Date());
        lambdaQueryWrapper.and(i -> i.eq(CouponUserDO::getStatus, CouponConstants.STORE_COUPON_USER_STATUS_USABLE)
                .or().eq(CouponUserDO::getStatus, CouponConstants.STORE_COUPON_USER_STATUS_IN_USE));
        List<CouponUserDO> list = this.list(lambdaQueryWrapper);

        List<CouponUserOrderDTO> disable = list.stream().map(CouponUserDO::buildCouponUserOrderDTO)
                .collect(Collectors.toList());

        for (CouponUserOrderDTO couponUserOrderDTO : collect) {
            for (CouponUserOrderDTO userOrderDTO : disable) {
                if (couponUserOrderDTO.getId().equals(userOrderDTO.getId())) {
                    userOrderDTO.setValidStr("usable");
                }
            }
        }

        return disable;
    }

    @Override
    public List<CouponUserDTO> feignGetById(List<Integer> couponId) {
        List<CouponUserDO> couponUserDOS = this.listByIds(couponId);
        return couponUserDOS.stream().map(CouponUserDO::bilIdCouponDTO).collect(Collectors.toList());
    }

    @Override
    public Boolean feignUpMyCoupon(List<CouponUserVO> couponUserVO) {
        Boolean updateById = true;
        for (CouponUserVO userVO : couponUserVO) {
            userVO.setOrderUsageTime(new Date());
            CouponUserDO couponUserDO = new CouponUserDO(userVO);
            couponUserDO.setUseTime(new Date());
            Boolean execute = transactionTemplate.execute(e -> {
                couponUserDao.insertCouponUserOrder(userVO);
                this.updateById(couponUserDO);
                return Boolean.TRUE;
            });
            if (!execute) {
                updateById = false;
            }
        }
        return updateById;
    }

    @Override
    public Boolean feignExchangeCoupon(CouponUserExchangeVO couponUserExchangeVO) {
        DateTime date = DateUtil.date();
        CouponUserDO couponUserDO = new CouponUserDO(couponUserExchangeVO);
        couponUserDO.setCouponType(CouponConstants.COUPON_TYPE_NO_THRESHOLD);
        couponUserDO.setUseType(CouponConstants.COUPON_USR_TYPE_VIP);
        couponUserDO.setGainType(CouponConstants.STORE_COUPON_USER_TYPE_EXCHANGE);
        couponUserDO.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        couponUserDO.setStartTime(date);
        //兑换vip卷过期时间=+50年
        DateTime dateTime = DateUtil.offset(date, DateField.YEAR, 50);
        couponUserDO.setEndTime(dateTime);
        couponUserDO.setCreateTime(date);
        return this.save(couponUserDO);
    }

    @Override
    public void overdueTask() {
        // 查询所有状态——可用的优惠券
        LambdaQueryWrapper<CouponUserDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CouponUserDO::getStatus, CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
        List<CouponUserDO> list = this.list(queryWrapper);
        if (CollUtil.isEmpty(list)) {
            return;
        }

        List<CouponUserDO> updateList = CollUtil.newArrayList();
        list.forEach(coupon -> {
            if (ObjectUtil.isNotNull(coupon.getEndTime())) {
                if (DateUtil.date().after(coupon.getEndTime())) {
                    coupon.setStatus(2);
                    updateList.add(coupon);
                }
            }
        });

        if (CollUtil.isEmpty(updateList)) {
            return;
        }
        boolean update = this.updateBatchById(updateList);
        if (!update) {
            log.error("批量更新优惠券过期动作失败");
        }

    }

    @Override
    public List<CouponUserOrderDTO> feignListUserCouponsByIds(List<Integer> couponIds) {
        List<CouponUserDO> couponUserDOS = couponUserDao.selectBatchIds(couponIds);
        List<CouponUserOrderDTO> collect = couponUserDOS.stream().map(d -> d.buildCouponUserOrderDTO()).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<CouponUserDTO> feignOrderCoupon(String orderNumber) {
        CouponUserInfoQO couponUserInfoQO = new CouponUserInfoQO();
        couponUserInfoQO.setOrderNumber(orderNumber);
        couponUserInfoQO.setPageNo(0);
        couponUserInfoQO.setPageSize(99);
        List<CouponUserDTO> couponUserDTOS = couponUserDao.selectCouponUserInfoList(couponUserInfoQO);
        return couponUserDTOS;
    }

    @Override
    public Boolean feignRollbackCoupons(List<OrderCouponDTO> orderCouponDTOS) {
        log.info("feignRollbackCoupons优惠券回滚：{}", JSONObject.toJSON(orderCouponDTOS));
        Set<Long> orderIds = orderCouponDTOS.stream().map(d -> d.getOrderId()).collect(Collectors.toSet());
        List<Integer> ids = orderCouponDTOS.stream().map(d -> d.getCouponUserId()).collect(Collectors.toList());
        List<CouponUserDO> couponUserDOS = couponUserDao.selectBatchIds(ids);
        //批量删除该订单相关优惠券
        couponUserDao.batchRemoveByOIds(orderIds);
        couponUserDOS.forEach(d -> {
            if (d.getUseType().equals(1) || (d.getUseType().equals(2) && d.getCouponType().equals(3))) {
                //vip和无门槛券
                if (d.getVerificationType() == null || d.getVerificationType().equals(true)) {
                    //多次核销
                    for (OrderCouponDTO couponDTO : orderCouponDTOS) {
                        if (d.getId().toString().equals(couponDTO.getCouponUserId().toString())) {
                            d.setStatus(4);
                            d.setRemainingBalance(d.getRemainingBalance() == null ? couponDTO.getUseAmount() : d.getRemainingBalance().add(couponDTO.getUseAmount()));
                            break;
                        }
                    }
                } else {
                    //单次核销
                    d.setStatus(0);
                    d.setRemainingBalance(d.getCouponMoney());
                    d.setUseTime(null);
                }
            } else {
                //满减和折扣
                d.setStatus(0);
                d.setUseTime(null);
            }
            couponUserDao.updateById(d);
        });
        return true;
    }

    @Override
    public ResultBody couponMerchandise(Integer couponId, String productName, Integer useType) {
        List<AppGoodsInfoDTO> collect = null;
        List<GoodsInfoDO> goodsInfoDos = null;
        if (VIPCOUPON.equals(useType)) {
            goodsInfoDos = couponUserDao.VipCouponMerchandise(productName);
        } else if (BRAND_COUPONS.equals(useType)) {
            List<Integer> merchandise = couponUserDao.merchandise(couponId);
            if (merchandise.size() == 0) {
                return ResultBody.error("当前优惠券没有关联的商品");
            }
            goodsInfoDos = couponUserDao.couponMerchandise(merchandise, productName);
        }
        collect = goodsInfoDos.stream().map(GoodsInfoDO::buildAppGoodsInfoDTO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody couponUsageDetails(Integer uid) {
        List<CouponUsageDetailsDO> couponUsageDetailsDOS = couponUserDao.couponUsageDetails(uid);
        List<CouponUsageDetailsDTO> collect = couponUsageDetailsDOS.stream().map(CouponUsageDetailsDO::bilIdCouponUsageDetailsDTO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }
}
