package com.mmc.oms.model.vo.repo;

import com.mmc.oms.common.publicinterface.Create;
import com.mmc.oms.common.publicinterface.Refund;
import com.mmc.oms.common.publicinterface.Share;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/31 16:43
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.RepoCashVO", description = "现金变更VO")
public class RepoCashVO implements Serializable {
    private static final long serialVersionUID = 1828354753495845609L;
    @ApiModelProperty(value = "用户ID")
    @NotNull(message = "用户ID不能为空", groups = {Create.class})
    private Integer repoAccountId;
    @ApiModelProperty(value = "订单ID")
    @NotNull(message = "orderRefundId不能为空", groups = {Refund.class})
    private Integer orderRefundId;
    @ApiModelProperty(value = "返租订单ID")
    @NotNull(message = "shareOrderId不能为空", groups = {Share.class})
    private Integer shareOrderId;
    @ApiModelProperty(value = "变动金额")
    @NotNull(message = "变动金额不能为空", groups = {Create.class, Refund.class})
    private BigDecimal amtPaid;
    @ApiModelProperty(value = "凭证图片集合")
    private List<String> voucher;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "操作人员密码")
    @NotNull(message = "变动金额不能为空", groups = {Refund.class, Share.class})
    private String authPwd;
}

