package com.mmc.oms.model.qo.mall;



import com.mmc.oms.common.publicinterface.Freeze;
import com.mmc.oms.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceOrderTaskQO implements Serializable {

    private static final long serialVersionUID = -17878654L;

    @ApiModelProperty(value = "订单名称或编号")
    private String orderNameOrNo;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "订单状态：0 待分配运营")
    private Integer orderStatus;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(
            message = "页码不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(
            message = "每页显示数不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
