package com.mmc.oms.model.qo.mall;

import com.mmc.oms.common.publicinterface.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * author:zhenjie
 * Date:2023/4/26
 * time:14:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.model.qo.OrderBonusQO", description = "无人机城订单分成查询QO")
public class OrderBonusQO implements Serializable {
    private static final long serialVersionUID = -6005993162561378862L;
    @ApiModelProperty(value = "订单编号", required = false)
    private String orderNo;

    @ApiModelProperty(value = "是否已分成，0未分成， 1已分成", required = false, example = "0")
    private Integer divide;

    @ApiModelProperty(value = "关键字", required = false)
    private String keyword;

    @ApiModelProperty(value = "企业名称", required = false)
    private String entName;

    @ApiModelProperty(value = "用户id", required = false, hidden = true)
    private List<Integer> mallUserIds;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
