package com.mmc.oms.model.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelCollection;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.mmc.oms.model.dto.mall.MallGoodsInfoDTO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.dto.mall.OrderBaseDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author 23214
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ExcelTarget("operationalDataExcel")
@Builder
public class OperationalDataExcel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Excel(name = "订单编号", orderNum = "1", width = 25,  needMerge = true)
    private String orderNo;

    @Excel(name = "下单时间", orderNum = "2", width = 25, databaseFormat = "yyyyMMdd", format = "yyyy-MM-dd HH:mm:ss", isImportField = "true_st", timezone = "Asia/Shanghai", needMerge = true)
    private Date orderTime;

    @Excel(name = "买家用户", orderNum = "3", width = 25, needMerge = true)
    private String userInfo;

    @Excel(name = "公司名称", orderNum = "4", width = 25, needMerge = true)
    private String corporateName;

    @Excel(name = "分销商等级", orderNum = "5", width = 25, needMerge = true)
    private String goodsName;

    @Excel(name = "上级分销商（推荐人）", orderNum = "6", width = 25, needMerge = true)
    private String recMallUserName;

    @Excel(name = "订单金额", orderNum = "7", width = 25, needMerge = true)
    private BigDecimal orderAmount;

    @Excel(name = "实际付款金额", orderNum = "8", width = 25, needMerge = true)
    private BigDecimal realPayAmount;

    @Excel(name = "抵扣优惠券金额", orderNum = "9", width = 25, needMerge = true)
    private BigDecimal subAmount;

    @Excel(name = "折扣金额", orderNum = "10", width = 25, needMerge = true)
    private BigDecimal discountAmount;

    @Excel(name = "签单模式（线上or线下）", orderNum = "11", width = 25, needMerge = true, replace = {"线下_0", "线上_1", "无_2"})
    private Integer signBillModel;

    @Excel(name = "是否完成实名和法人认证", orderNum = "12", width = 25, needMerge = true, replace = {"否_0", "是_1"})
    private Integer realNameAuth;

    @ExcelCollection(name = "产品清单", orderNum = "13")
    private List<MallGoodsInfoDTO> productInventory;

    @Excel(name = "推荐人采购优惠总价（元）", orderNum = "14", width = 25, needMerge = true)
    private BigDecimal recDiscountTotalPrice;

    @Excel(name = "推荐人利润（元）", orderNum = "15", width = 25, needMerge = true)
    private BigDecimal recProfit;

    @Excel(name = "销售", orderNum = "16", width = 25, needMerge = true)
    private String saleName;

    @Excel(name = "运营操作人员", orderNum = "17", width = 25, needMerge = true)
    private String operationName;

    @Excel(name = "备注", orderNum = "18", width = 25, needMerge = true)
    private String memo;

    public OperationalDataExcel(MallOrderPageDTO d) {
        this.orderTime = d.getCreateTime();
        this.orderNo = d.getEntName();
        this.goodsName = d.getTagName();
        this.recMallUserName = d.getRecMallUserName();
        this.orderAmount = d.getOrderAmount();
        this.realPayAmount = d.getRealPayAmount();
        this.subAmount = d.getSubAmount();
        this.signBillModel = d.getContractSignedWay() == null ? 2 : d.getContractSignedWay();
        this.realNameAuth = d.getRealNameAuth() == null ? 0 : d.getRealNameAuth();
        this.saleName = d.getSaleName();
        this.operationName = d.getOperationName();
        this.memo = d.getRemark();
    }

    public OperationalDataExcel(OrderBaseDTO d) {
        this.orderTime = d.getOrderDate();
        this.orderNo = d.getOrderNo();
        this.userInfo = d.getUserName() == null ? d.getUserNickname() + "(" + d.getUid() + ")" : d.getUserName() + "(" + d.getUid() + ")";
        this.corporateName = d.getEntName();
        this.goodsName = d.getTagName();
        this.recMallUserName = d.getRecMallUserName()==null? null : d.getRecMallUserName() + "(" + d.getRecMallUid() + ")";
        this.orderAmount = d.getOrderAmount();
        this.realPayAmount = d.getActualPayment();
        this.subAmount = d.getDeductionAmount();
        this.discountAmount = d.getDiscountAmount();
        this.signBillModel = d.getContractSignedWay() == null ? 2 : d.getContractSignedWay();
        this.realNameAuth = d.getRealNameAuth() == null ? 0 : d.getRealNameAuth();
        this.saleName = d.getSaleName() == null ? "" : d.getSaleName() + "(" + d.getSaleUid() + ")";
        this.operationName = d.getOperationName() == null ? "" : d.getOperationName() + "(" + d.getOperationUid() + ")";
        this.memo = d.getRemark();
        this.recDiscountTotalPrice =d.getRecDiscountTotalPrice();
        this.recProfit = d.getRecProfit();
        this.productInventory = d.getMallGoodsInfoDTOS();
    }
}
