package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/2 20:57
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.iuav.mall.dto.OrderGoodsProdDTO", description = "订单商品sku信息DTO")
public class OrderGoodsProdDTO implements Serializable {
    private static final long serialVersionUID = 2066849435828937057L;
    @ApiModelProperty(value = "orderGoodsProdId")
    private Integer id;
    @ApiModelProperty(value = "订单id")
    private Integer orderId;
    @ApiModelProperty(value = "产品购物车id")
    private Integer mallProdShopCarId;
    @ApiModelProperty(value = "商品id")
    private Integer goodsInfoId;
    @ApiModelProperty(value = "商品所属类型")
    private Integer directoryId;
    @ApiModelProperty(value = "全部sku金额")
    private BigDecimal goodsAmount;
    @ApiModelProperty(value = "商品编号")
    private String goodsNo;
    @ApiModelProperty(value = "商品名称")
    private String goodsName;
    @ApiModelProperty(value = "商品主图")
    private String mainImg;
    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "是否有效")
    private Boolean valid;
    @ApiModelProperty(value = "是否上架")
    private Integer shelfStatus;
    @ApiModelProperty(value = "是否删除")
    private Integer deleted;

    @ApiModelProperty("商品服务列表")
    private List<GoodsServiceDTO> services;

    @ApiModelProperty(value = "订单详情")
    private List<OrderGoodsProdDetailDTO> orderGoodsProdDetailDTOS;
}
