package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 * @date 2022/3/24 18:27
 * 概要：
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.MallSkuDTO", description = "商品规格DTO")
public class MallSkuDTO implements Serializable {
    private static final long serialVersionUID = 7691622398702487199L;
    @ApiModelProperty(value = "id")
    private Long id;
    @ApiModelProperty(value = "pid")
    private Integer pid;
    @ApiModelProperty(value = "sku名称")
    private String specName;
    @ApiModelProperty(value = "sku描述")
    private String specDesc;
    @ApiModelProperty(value = "模板id")
    private Integer skuTemplateId;
    @ApiModelProperty(value = "类型id")
    private Integer skuTypeId;
    @ApiModelProperty(value = "图片")
    private String specPicture;
    @ApiModelProperty(value = "spu")
    private String spu;
    @ApiModelProperty(value = "产品id")
    private List<Integer> productId;
}
