package com.mmc.oms.feign;

import com.mmc.oms.model.dto.mall.*;
import com.mmc.oms.model.qo.mall.MallOrderGoodsInfoQO;
import com.mmc.oms.model.qo.mall.ProductSpecPriceQO;
//import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/5 15:18
 */
//@FeignClient(url = "${pms.url}", name = "pms-svc", fallback = PmsAppApiHystrix.class)
public interface PmsAppApi {
    @PostMapping("/pms/goods/fillGoodsInfo")
    List<MallGoodsShopCarDTO> fillGoodsInfo(@RequestBody List<MallGoodsShopCarDTO> param, @RequestHeader("token") String token);

    @PostMapping("/pms/goods/feignListProdGoodsSkuInfo")
    List<OrderGoodsProdDTO> feignListProdGoodsSkuInfo(@RequestBody MallOrderGoodsInfoQO mallOrderGoodsInfoQO, @RequestHeader("token") String token);

    @PostMapping("/pms/goods/feignListIndstGoodsSkuInfo")
    List<OrderGoodsIndstDTO> feignListIndstGoodsSkuInfo(@RequestBody MallOrderGoodsInfoQO mallOrderGoodsInfoQO, @RequestHeader("token") String token);

    @PostMapping("/pms/goods/feignListProductSpecPrice")
    List<MallProductSpecPriceDTO> feignListProductSpecPrice(@RequestBody ProductSpecPriceQO productSpecPriceQO, @RequestHeader("token") String token);

    @GetMapping("/pms/goods/feignGetUnitPriceByTag")
    public ProductSpecPriceDTO feignGetUnitPriceByTag(@RequestParam(value = "specId")Integer specId,
                                                      @RequestParam(value = "tagId")Integer tagId, @RequestHeader("token") String token);
}
