package com.mmc.oms.entity.order;

import com.mmc.oms.model.dto.order.OrderStatusDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/6/1 14:17
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderStatusDO {


    private static final long serialVersionUID = 6544149196885009444L;
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "商品标题")
    private String wareTitle;

    @ApiModelProperty(value = "商品图片")
    private String wareImg;

    @ApiModelProperty(value = "实际付款")
    private BigDecimal actualPay;

    @ApiModelProperty(value = "订单描述")
    private String wareDescription;

    @ApiModelProperty(value = "订单状态编号")
    private Integer tranStatus;

    @ApiModelProperty(value = "等待状态")
    private String waiting;

    @ApiModelProperty(value = "当前状态")
    private String doing;

    @ApiModelProperty(value = "订单状态")
    private String leaseOrderStatus;

    public OrderStatusDTO buildOrderStatusDTO() {
        return OrderStatusDTO.builder()
                .id(this.id)
                .orderNo(this.orderNo)
                .wareImg(this.wareImg)
                .actualPay(this.actualPay)
                .wareDescription(this.wareDescription)
                .tranStatus(this.tranStatus)
                .waiting(this.waiting)
                .doing(this.doing)
                .leaseOrderStatus(this.leaseOrderStatus)
                .build();
    }

}
