package com.mmc.oms.entity.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/2 20:29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="com.mmc.csf.morder.entity.OrderGoodsProdDetailBO", description="")
@NoArgsConstructor
@AllArgsConstructor
public class OrderGoodsProdDetailBO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    private Integer orderGoodsProdId;

    private Integer mallProdShopCarDetailId;

    private Integer mallProdSkuInfoSpecId;

    @ApiModelProperty(value = "商品sku的id")
    private Integer mallProdSkuInfoId;

    @ApiModelProperty(value = "产品类型名称")
    private String goodsTypeName;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "产品品牌")
    private String productBrand;

    @ApiModelProperty(value = "产品规格id")
    private Integer productSpecId;

    @ApiModelProperty(value = "规格名称-快照")
    private String prodSkuSpecName;

    @ApiModelProperty(value = "规格图片-快照")
    private String prodSkuSpecImage;

    @ApiModelProperty(value = "料号-快照")
    private String partNo;

    @ApiModelProperty(value = "版本描述-快照")
    private String versionDesc;

    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;

    @ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "总价")
    private BigDecimal skuSpecAmount;

    private Date createTime;

    private Date updateTime;

    // 关联字段
    private BigDecimal goodsAmount;
    private String goodsNo;
    private Integer goodsInfoId;

}
