package com.mmc.oms.entity.demand;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.oms.common.publicinterface.Insert;
import com.mmc.oms.common.publicinterface.Update;
import com.mmc.oms.model.vo.demand.DemandReleaseOrderVO;
import com.mmc.oms.model.vo.demand.OrderRequestParamsVO;
import com.mmc.oms.model.vo.demand.UserPayInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/25 15:51
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DemandReleaseOrderDO implements Serializable {

    private static final long serialVersionUID = -1811974173256250060L;
    private Integer id;
    private Integer requirementTypeId;
    private Integer userAccountId;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;
    private String publishName;
    private String publishPhone;
    private String requireDescription;
    private Integer deleted;
    //是否解决
    private Boolean solved;
    private Date createTime;
    private Date updateTime;
    @ApiModelProperty(value = "任务标题", example = "任务标题001", required = true)
    @NotBlank(message = "任务标题不能为空", groups = {Insert.class, Update.class})
    @Size(max = 15, message = "任务标题限制15个字")
    private String taskTitle;

    @ApiModelProperty(value = "任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "任务经度", example = "23.344324", required = true)
    @NotNull(message = "任务经度不能为空", groups = {Insert.class, Update.class})
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "44.344324", required = true)
    @NotNull(message = "任务纬度不能为空", groups = {Insert.class, Update.class})
    private Double latitude;


    @ApiModelProperty(value = "描述图片", example = "http://,http://", required = false)
    private String requireUrl;


    @ApiModelProperty(value = "类型名称",example = "航拍摄影")
    private String requirementTypeName;

    @ApiModelProperty(value = "订单编号",example = "R202307251459553408130")
    private String orderNumber;

    @ApiModelProperty(value = "应支付金额 单位元", example = "1.00")
    private BigDecimal paramMoney;

    @ApiModelProperty(value = "实际支付金额 单位元", example = "1.00")
    private BigDecimal practicalMoney;

    @ApiModelProperty(value = "发布者id", example = "1", required = true)
    private Integer publishAccountId;

    @ApiModelProperty(value = "需求发布id",required = true)
    private Integer requirementsInfoId;


    public DemandReleaseOrderDO(DemandReleaseOrderVO requirementsInfoVO) {
        this.requirementTypeId = requirementsInfoVO.getRequirementTypeId();
        this.requirementTypeName=requirementsInfoVO.getRequirementTypeName();
        this.userAccountId = requirementsInfoVO.getUserAccountId();
        this.publishName = requirementsInfoVO.getPublishName();
        this.publishPhone = requirementsInfoVO.getPublishPhone();
        this.requireDescription = requirementsInfoVO.getRequireDescription();
        this.taskStartTime = requirementsInfoVO.getTaskStartTime();
        this.taskEndTime = requirementsInfoVO.getTaskEndTime();
        this.taskTitle = requirementsInfoVO.getTaskTitle();
        this.taskAddress = requirementsInfoVO.getTaskAddress();
        this.longitude = requirementsInfoVO.getLongitude();
        this.latitude = requirementsInfoVO.getLatitude();
        this.requireUrl = requirementsInfoVO.getRequireUrl();
        this.orderNumber=requirementsInfoVO.getOrderNumber();
        this.paramMoney=requirementsInfoVO.getParamMoney();
        this.publishAccountId=requirementsInfoVO.getPublishAccountId();
        this.requirementsInfoId=requirementsInfoVO.getRequirementsInfoId();
    }

    public DemandReleaseOrderDO(UserPayInfoVO userPayInfoVO,BigDecimal divide) {
        this.orderNumber = userPayInfoVO.getOutTradeNo();
        this.practicalMoney=divide;
        this.userAccountId=userPayInfoVO.getUserAccountId();
    }



    public OrderRequestParamsVO buildOrderRequestParamsVO() {
       return  OrderRequestParamsVO.builder().orderNo(this.orderNumber).description(this.taskTitle).
               orderPort(3)
               .build();
    }



}
