package com.mmc.oms.dao.mall;
import com.mmc.oms.entity.mall.MallIndstShopCarDO;
import com.mmc.oms.entity.mall.MallProdShopCarDO;
import com.mmc.oms.model.qo.mall.MallShopCarQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Set;

/**
 * author:zhenjie
 * Date:2022/10/11
 * time:10:30
 */
@Mapper
public interface ShoppingTrolleyDao {
    List<MallProdShopCarDO> listMallProdShopCar(MallShopCarQO mallShopCarQO);

    void insertMallProdShopCar(MallProdShopCarDO mallProdShopCarDO);

    void batchInsertMallProdShopCarDetail(Integer mallProdShopCarId, Set<Integer> mallSkuSpecIds);

    void batchRemoveProd(Integer userAccountId, List<Integer> carIds);

    MallProdShopCarDO getMallProdShopCar(MallProdShopCarDO prodShopCarDO);

    void updateMallProdShopCar(MallProdShopCarDO mallProdShopCarDO1);

    List<MallIndstShopCarDO> listMallIndstShopCar(MallShopCarQO mallShopCarQO);

    void insertMallIndstShopCar(MallIndstShopCarDO mallIndstShopCarDO);

    void batchInsertMallIndstShopCarDetail(Integer mallIndstShopCarId, Set<Integer> mallSkuSpecIds);

    void batchRemoveIndst(Integer userAccountId, List<Integer> carIds);

    MallIndstShopCarDO getMallIndstShopCar(MallIndstShopCarDO mallIndstShopCarDO);

    void updateMallIndstShopCar(MallIndstShopCarDO mallIndstShopCarDO1);

    int countProdListPage(Integer userAccountId);

    List<MallProdShopCarDO> prodListPage(Integer pageNo, Integer pageSize, Integer userAccountId);

    int countIndstListPage(Integer userAccountId);

    List<MallIndstShopCarDO> indstListPage(Integer pageNo, Integer pageSize, Integer userAccountId);

    void updateProductShopCarStatus(List<MallProdShopCarDO> mallProdShopCarDOS);

    void updateIndustryShopCarStatus(List<MallIndstShopCarDO> mallIndstShopCarDOS);

    void addProdShopCarBuyNum(Integer id, Integer buyNum);

    void addIndstShopCarBuyNum(Integer id, Integer buyNum);
}
