package com.mmc.oms.controller.mall;


import com.mmc.oms.common.publicinterface.Create;
import com.mmc.oms.common.publicinterface.Page;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.mall.ServiceOrderStatusInfoDTO;
import com.mmc.oms.model.dto.mall.ServiceOrderTaskDTO;
import com.mmc.oms.model.qo.mall.ServiceOrderTaskQO;
import com.mmc.oms.model.vo.mall.ServiceOrderTaskVO;
import com.mmc.oms.service.mall.ServiceOrderStatusInfoService;
import com.mmc.oms.service.mall.ServiceOrderTaskService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 后台云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Api(tags = {"后台-云享飞作业服务订单-模块"})
@RestController
@RequestMapping("/serviceOrderTask")
public class ServiceOrderTaskController extends BaseController {

    @Autowired
    private ServiceOrderTaskService serviceOrderTaskService;
    @Autowired
    private ServiceOrderStatusInfoService serviceOrderStatusInfoService;

    @ApiOperation(value = "服务订单任务-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertOrderTask")
    public ResultBody insertOrderTask(
            @Validated(Create.class) @RequestBody ServiceOrderTaskVO param, HttpServletRequest request) {
        return serviceOrderTaskService.insertOrderTask(param, this.getCurrentAccount(request).getUserAccountId(),request);
    }

    @ApiOperation(value = "查询服务订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderTaskDTO.class)})
    @PostMapping("queryOrderTaskList")
    public ResultBody<ServiceOrderTaskDTO> queryOrderTaskList(
            @Validated(Page.class) @RequestBody ServiceOrderTaskQO param, HttpServletRequest request) {
        return ResultBody.success(serviceOrderTaskService.queryOrderTaskList(param,null,request));
    }

    @ApiOperation(value = "查询服务订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderTaskDTO.class)})
    @GetMapping("queryOrderTask")
    public ResultBody<ServiceOrderTaskDTO> queryOrderTask(@ApiParam("订单服务id") @RequestParam(value = "id") Integer id, HttpServletRequest request) {
        return serviceOrderTaskService.queryById(id,request);
    }

    @ApiOperation(value = "获取服务订单状态字典表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderStatusInfoDTO.class)})
    @PostMapping("getServiceOrderStatus")
    public ResultBody<ServiceOrderStatusInfoDTO> getServiceOrderStatus() {
        return ResultBody.success(serviceOrderStatusInfoService.getServiceOrderStatus());
    }
}

