package com.mmc.oms.controller.mall;


import com.mmc.oms.common.publicinterface.Confirm;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.mall.MallOrderDTO;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import com.mmc.oms.model.qo.mall.MallOrderQO;
import com.mmc.oms.model.vo.mall.ConfirmAfPayVO;
import com.mmc.oms.model.vo.mall.ConfirmOrderNewVO;
import com.mmc.oms.model.vo.mall.MallOrderExpressVO;
import com.mmc.oms.model.vo.mall.OrderPayVO;
import com.mmc.oms.service.mall.MallOrderService;
import com.mmc.oms.service.mall.MallOrderServiceSub;
import com.mmc.oms.service.mall.OrderExpressService;
import io.swagger.annotations.*;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.annotations.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

@Api(tags = { "平台-订单管理-接口(改版后)" })
@RestController
@RequestMapping("/pmorderVerOne/")
public class PMOrderControllerVerOne extends BaseController {

    @Autowired
    private MallOrderService mallOrderService;

    @Autowired
    private OrderExpressService orderExpressService;

    @Autowired
    private MallOrderServiceSub mallOrderServiceSub;

    @ApiOperation(value = "v1.0.0订单管理-分页查询（改版后）")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderPageDTO.class) })
    @PostMapping("listPageManagerVerOne")
    public ResultBody<MallOrderPageDTO> listPageManagerVerOne(@RequestBody MallOrderQO param, HttpServletRequest request) {
        return ResultBody.success(mallOrderService.listPageManagerVerOne(param, this.getCurrentAccount(request), request.getHeader("token")));
    }

    @ApiOperation(value = "订单管理-导出（改版后）", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("listPageManagerExportVerOne")
    public void listPageManagerExportVerOne(@RequestBody MallOrderQO param, HttpServletResponse response, HttpServletRequest request) {
        mallOrderService.listPageManagerExportVerOne(param,response,this.getCurrentAccount(request), request.getHeader("token"));
    }

    @ApiOperation(value = "v1.0.0订单管理-详情（改版后）")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class) })
    @GetMapping("getMallOrderDetailById")
    public ResultBody<MallOrderDTO> getMallOrderDetailById(@RequestParam Integer orderId, HttpServletRequest request) {
        return ResultBody.success(mallOrderService.getMallOrderDetailById(orderId,this.getCurrentAccount(request), request.getHeader("token")));
    }

//    @ApiOperation(value = "订单管理-确认订单的详情", hidden = true)
//    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderDTO.class) })
//    @GetMapping("getAffirmMallOrderDetailById")
//    public ResultBody getAffirmMallOrderDetailById(@RequestParam Long orderId, HttpServletRequest request) {
//        MallOrderDTO mallOrderDTO = mallOrderService.getMallOrderDetailById(orderId, this.getCurrentAccount(request));
//        //mallOrderDTO = mallOrderService.moneyCalculate(mallOrderDTO);
//        return ResultBody.success(mallOrderDTO);
//    }

    @ApiOperation(value = "订单管理-修改订单备注（管理员专属）", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("updateMallOrderRemark")
    public ResultBody updateMallOrderRemark(@RequestParam Integer orderId, @RequestParam(required = false) String remark, HttpServletRequest request) {
        return mallOrderService.updateMallOrderRemark(orderId, remark);
    }

    @ApiOperation(value = "确认订单（改版后）", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("confirmOrderNew")
    public ResultBody confirmOrderNew(@Validated(Update.class) @RequestBody ConfirmOrderNewVO confirmOrderNewVO, HttpServletRequest request) {
        return mallOrderService.confirmOrderNew(confirmOrderNewVO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "订单发货（改版后）", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("sendOrderGoodsNew")
    public ResultBody sendOrderGoodsNew(@RequestBody MallOrderExpressVO param, HttpServletRequest request) throws Exception {
        return mallOrderService.sendOrderGoodsNew(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "批量生产导出数据", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/exportMultiSheet")
    public void exportMultiSheet(HttpServletResponse response, @ApiParam("订单id") @RequestBody List<Integer> orderIds) throws IOException {
        mallOrderService.exportMultiSheet(response,orderIds);
    }

    @ApiOperation(value = "订单管理-运营数据导出", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("listOperationalDataExport")
    public void listOperationalDataExport(@RequestBody MallOrderQO param, HttpServletResponse response, HttpServletRequest request) throws IOException {
        mallOrderService.listOperationalDataExport(param,response,this.getCurrentAccount(request), request.getHeader("token"));
    }

    @ApiOperation(value = "订单管理-运营数据导出（改版后）", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("operationalDataExport")
    public void operationalDataExport(@ApiParam("订单id") @RequestBody List<Integer> orderIds, HttpServletResponse response, HttpServletRequest request) throws IOException {
        mallOrderService.operationalDataExport(orderIds,response,this.getCurrentAccount(request));
    }

    @ApiOperation(value = "修改订单物流信息", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateOrderExpress")
    public ResultBody updateOrderExpress(@ApiParam("物流信息") @RequestBody MallOrderExpressVO orderExpressVO){
        return orderExpressService.updateOrderExpress(orderExpressVO);
    }

    @ApiOperation(value = "逾期未打款合同作废", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("mallOrderCreditPeriodTask")
    @ApiIgnore
    public void mallOrderCreditPeriodTask(){
        mallOrderService.mallOrderCreditPeriodTask();
    }

    @ApiOperation(value = "轮询检测签收但没有确认收货的订单（自动完成）", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("feignAutoCompleteMOrder")
    @ApiIgnore
    public ResultBody feignAutoCompleteMOrder() {
        return mallOrderServiceSub.feignAutoCompleteMOrder();
    }

    @ApiOperation(value = "根据订单id查询 已经支付和未支付的订单", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("feignOrderUseCoupon")
    @ApiIgnore
    public ResultBody feignOrderUseCoupon(@RequestParam List<Integer> orderId){
        return mallOrderService.feignOrderUseCoupon(orderId);
    }

    @ApiOperation(value = "根据订单编号查询订单", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallOrderPageDTO.class) })
    @GetMapping("getOrderInfoByOrderNo")
    public ResultBody getOrderInfoByOrderNo(@RequestParam String orderNo){
        return mallOrderService.getOrderInfoByOrderNo(orderNo);
    }

    @ApiOperation(value = "分配运营", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("allocateOperation")
    public ResultBody allocateOperation(@ApiParam(value = "订单id")@RequestParam(value = "orderId") Integer orderId,
                                        @ApiParam(value = "运营id") @RequestParam(value = "operationId") Integer operationId) {
        return mallOrderService.allocateOperation(orderId,operationId);
    }

    @ApiOperation(value = "订单关闭-根据id", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("deleteById")
    public ResultBody closeMallOrder(@RequestParam Integer id, HttpServletRequest request) {
        return mallOrderService.closeMallOrder(id,this.getCurrentAccount(request));
    }

    @ApiOperation(value = "菜单红点-待处理的订单数量", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("countMenuRedPoint")
    public ResultBody countMenuRedPoint(HttpServletRequest request) {
        return ResultBody.success(mallOrderService.countMenuRedPoint(this.getCurrentAccount(request)));
    }

    @ApiOperation(value = "代工-上传尾款凭证", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("orderPayFinish")
    public ResultBody orderPayFinish(@Validated(value = { Confirm.class }) @RequestBody OrderPayVO param,
                                     HttpServletRequest request) {
        return mallOrderService.orderPayFinish(param, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "审批-首次收款（通过或不通过）[新]", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("confirmCostVerOne")
    public ResultBody confirmCostVerOne(@RequestBody @Validated ConfirmAfPayVO confirmPay, HttpServletRequest request) {
        return mallOrderService.confirmCostVerOne(confirmPay,this.getCurrentAccount(request));
    }

    @ApiOperation(value = "审批-尾款（通过或不通过）[新]", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("confirmAfPayVerOne")
    public ResultBody confirmAfPayVerOne(@RequestBody @Validated List<ConfirmAfPayVO> confirmPay, HttpServletRequest request) {
        if(CollectionUtils.isEmpty(confirmPay)){
            return ResultBody.error("参数不能为空");
        }
        for (ConfirmAfPayVO confirmAfPay : confirmPay) {
            mallOrderService.confirmAfPayVerOne(confirmAfPay, this.getCurrentAccount(request));
        }
        return ResultBody.success();
    }
}
