package com.mmc.oms.controller.demand.util;

import com.github.binarywang.java.emoji.EmojiConverter;

/**
 * @Author small
 * @Date 2023/7/27 10:32
 * @Version 1.0
 */
public class EmojiUtils {

    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();

    /**
     * 判断字符串有没有emoji字符
     * @param source
     * @return
     */
    public static boolean containsEmoji(String source) {
        int len = source.length();
        boolean isEmoji = false;
        for (int i = 0; i < len; i++) {
            char hs = source.charAt(i);
            if (0xd800 <= hs && hs <= 0xdbff) {
                if (source.length() > 1) {
                    char ls = source.charAt(i + 1);
                    int uc = ((hs - 0xd800) * 0x400) + (ls - 0xdc00) + 0x10000;
                    if (0x1d000 <= uc && uc <= 0x1f77f) {
                        return true;
                    }
                }
            } else {
                // non surrogate
                if (0x2100 <= hs && hs <= 0x27ff && hs != 0x263b) {
                    return true;
                } else if (0x2B05 <= hs && hs <= 0x2b07) {
                    return true;
                } else if (0x2934 <= hs && hs <= 0x2935) {
                    return true;
                } else if (0x3297 <= hs && hs <= 0x3299) {
                    return true;
                } else if (hs == 0xa9 || hs == 0xae || hs == 0x303d
                        || hs == 0x3030 || hs == 0x2b55 || hs == 0x2b1c
                        || hs == 0x2b1b || hs == 0x2b50 || hs == 0x231a) {
                    return true;
                }
                if (!isEmoji && source.length() > 1 && i < source.length() - 1) {
                    char ls = source.charAt(i + 1);
                    if (ls == 0x20e3) {
                        return true;
                    }
                }
            }
        }
        return isEmoji;
    }

    /**
     * 带有表情的字符串Emoji转义为unicode，类似&#128582;。
     * @param emoji
     * @return
     */
    public static String emojiConverter2Html(String emoji) {
        String result = null;
        if (null != emoji && emoji.length() > 0) {
            result = emojiConverter.toHtml(emoji);
        }
        return result;
    }

}

