package com.mmc.oms.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mmc.oms.model.dto.mall.CooperationTagVO;
import com.mmc.oms.model.dto.mall.OrderGoodsProdDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.UserAccountQO;
import com.mmc.oms.model.qo.mall.BUserAccountQO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/8 10:16
 */
@Component
public class UserClient {

    @Value("${userapp.url}")
    private String userAppUri;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 根据用户id获取基本信息
     * @param userAccountId
     * @return
     */
    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<UserAccountSimpleDTO> responseEntity = restTemplate.exchange(userAppUri + "user-account/feignGetUserSimpleInfo" + "?userAccountId=" + userAccountId, HttpMethod.GET, entity, UserAccountSimpleDTO.class);
        return responseEntity.getBody();
    }

    /**
     * 根据地区信息查询用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    public List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode,
                                          Integer districtCode, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        String param = "";
        if (provinceCode != null){
            param = "provinceCode=" + provinceCode;
        }
        if (cityCode != null){
            param += "&cityCode=" + cityCode;
        }
        if (districtCode != null){
            param += "&districtCode=" + districtCode;
        }
        ResponseEntity<List> exchange = restTemplate.exchange(userAppUri + "user-account/feignListUserAccountIds?" + param, HttpMethod.GET, entity, List.class);
        List<Integer> ids = exchange.getBody();
        return ids;
    }

    /**
     * 获取后台用户集合列表页面
     *
     * @param bUserAccountQO 问:b用户帐户
     * @return {@link List}<{@link UserAccountSimpleDTO}>
     */
    public List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(bUserAccountQO), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(userAppUri + "back-user/feignListBAccountPage", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<UserAccountSimpleDTO> users = (List<UserAccountSimpleDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,UserAccountSimpleDTO.class)).collect(Collectors.toList());
        return users;
    }

    /**
     * 根据用户id查询用户信息
     * @param ids
     * @param token
     * @return
     */
    public List<UserAccountSimpleDTO> feignListUserAccountByIds(List<Integer> ids, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(ids), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(userAppUri + "user-account/feignListUserAccountByIds", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<UserAccountSimpleDTO> users = (List<UserAccountSimpleDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,UserAccountSimpleDTO.class)).collect(Collectors.toList());
        return users;
    }

    /**
     * 查询推荐人信息
     * @param userIds
     * @return
     */
    public List<UserAccountSimpleDTO> feignListRcdUserInfo(List<Integer> userIds, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userIds), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(userAppUri + "user-account/feignListRcdUserInfo", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<UserAccountSimpleDTO> users = (List<UserAccountSimpleDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,UserAccountSimpleDTO.class)).collect(Collectors.toList());
        return users;
    }

    /**
     * 查询上级id
     * @param userAccountId
     * @return
     */
    public Integer feignGetSuperiorRef(Integer userAccountId, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<Integer> responseEntity = restTemplate.exchange(userAppUri + "user-account/feignGetSuperiorRef" + "?userAccountId=" + userAccountId, HttpMethod.GET, entity, Integer.class);
        return responseEntity.getBody();
    }

    /**
     * 查询上级推荐人信息
     * @param userAccountId
     * @return
     */
    public UserAccountSimpleDTO feignGetUserRcdInfo(Integer userAccountId, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<UserAccountSimpleDTO> responseEntity = restTemplate.exchange(userAppUri + "user-account/feignGetUserRcdInfo" + "?userAccountId=" + userAccountId, HttpMethod.GET, entity, UserAccountSimpleDTO.class);
        return responseEntity.getBody();
    }

    /**
     * 用户合作标签
     * @return
     */
    public List<CooperationTagVO> feignListCooperationTag(){
        //ResponseEntity<List> responseEntity = restTemplate.getForEntity(userAppUri + "cooperation/feignListCooperationTag", List.class);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<String> responseEntity = restTemplate.exchange(userAppUri + "cooperation/feignListCooperationTag", HttpMethod.GET, entity, String.class);
        List<CooperationTagVO> cooperationTagVOS = JSONArray.parseArray(responseEntity.getBody(), CooperationTagVO.class);
        return cooperationTagVOS;
    }

    /**
     * 获取小程序用户集合列表
     *
     * @param userAccountQO 问:b用户帐户
     * @return {@link List}<{@link UserAccountSimpleDTO}>
     */
    public List<UserAccountSimpleDTO> feignListAppUserAccount(UserAccountQO userAccountQO, String token){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountQO), headers);
        ResponseEntity<List> responseEntity = restTemplate.exchange(userAppUri + "user-account/feignListAppUserAccount", HttpMethod.POST, entity, List.class);
        if (CollectionUtils.isEmpty(responseEntity.getBody())) {
            return null;
        }
        List<UserAccountSimpleDTO> users = (List<UserAccountSimpleDTO>) responseEntity.getBody().stream().map(it->new ObjectMapper().convertValue(it,UserAccountSimpleDTO.class)).collect(Collectors.toList());
        return users;
    }

}
