package com.mmc.oms.model.dto.repo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * @Author small
 * @Date 2023/5/24 14:58
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.RepoAccountDTO", description = "云仓账号信息DTO")
public class RepoAccountDTO implements Serializable {
    private static final long serialVersionUID = 1433562781546856233L;
    @ApiModelProperty(value = "用户id")
    private Integer id;
    @ApiModelProperty(value = "用户uid")
    private String uid;
    @ApiModelProperty(value = "账号名称")
    private String accountName;
    @ApiModelProperty(value = "账号类型")
    private Integer accountType;
    @ApiModelProperty(value = "联系电话")
    private String phoneNum;
    @ApiModelProperty(value = "实名认证状态")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "企业认证状态")
    private Integer entAuthStatus;
    @ApiModelProperty(value = "渠道认证状态")
    private Integer channelAuthStatus;
    @ApiModelProperty(value = "渠道等级")
    private Integer channelClass;
    @ApiModelProperty(value = "常驻城市")
    private String resAddress;
    @ApiModelProperty(value = "昵称")
    private String nickName;
    @ApiModelProperty(value = "头像url")
    private String headerImg;
    @ApiModelProperty(value = "经度")
    private BigDecimal lon;
    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "删除状态，0未删除，1删除")
    private Integer deleted;
    @ApiModelProperty(value = "企业名称")
    private String entName;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "企业认证时间")
    private Date entAuthTime;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "现金余额")
    private BigDecimal cashAmt;
    private String unionId;
    private String openId;
    @ApiModelProperty(value = "多端用户，USER_PORT(云享飞)-FLYER_PORT(云飞手)-REPO_PORT(云仓)")
    private Set<String> ports;
    @ApiModelProperty(value = "用户推荐人数量")
    private Integer rcdRepoTeamNum;
    @ApiModelProperty(value = "推荐人Uid")
    private String rcdUid;
    @ApiModelProperty(value = "推荐人账户名称")
    private String rcdAccountName;
    @ApiModelProperty(value = "推荐人昵称")
    private String rcdNickName;
    @ApiModelProperty(value = "推荐人id")
    private Integer rcdAccountId;
    @ApiModelProperty(value = "是否销售")
    private Integer sale;
    @ApiModelProperty(value = "是否白名单")
    private Integer white;
    @ApiModelProperty(value = "用户来源：0自然流，1海报，2抖音，3公众号，4社群，5招投标，默认0")
    private Integer source;
    @ApiModelProperty(value = "推荐单位")
    private String company;
    @ApiModelProperty(value = "推荐单位ID", hidden = true)
    private Integer rcdCompanyId;
}
