package com.mmc.oms.entity.demand;

import com.mmc.oms.model.vo.demand.OrderRequestParamsVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/19 17:03
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GetOrderNumberDO {

    private Integer id;

    private static final long serialVersionUID = 75097833899496576L;
    @ApiModelProperty(value = "支付订单编号", example = "dadasdas")
    private String paymentOrderNumber;

    @ApiModelProperty(value = "微信需要支付金额", example = "100")
    private BigDecimal weChatPay;

    @ApiModelProperty(value = "用户id", example = "100", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "服务id")
    private Integer requirementsInfoId;

    public GetOrderNumberDO(GetOrderNumberDTO getOrderNumberDTO){
        this.paymentOrderNumber=getOrderNumberDTO.getPaymentOrderNumber();
        this.weChatPay=getOrderNumberDTO.getWeChatPay();
        this.userAccountId=getOrderNumberDTO.getUserAccountId();
        this.requirementsInfoId= getOrderNumberDTO.getRequirementsInfoId();
    }

    public OrderRequestParamsVO orderRequestParamsVO() {
        return  OrderRequestParamsVO.builder().orderNo(this.paymentOrderNumber)
                .description("发布服务需求支付").
                orderPort(4)
                .build();
    }
}
