package com.mmc.oms.controller.uav;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.uav.UavCartDTO;
import com.mmc.oms.model.dto.uav.UavOrderDTO;
import com.mmc.oms.model.vo.uav.UavCartVO;
import com.mmc.oms.service.uav.UavCartService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/9/16 14:37
 */
@Api(tags = { "最新版-购物车接口" })
@RestController
@RequestMapping("/uav-cart/")
public class UavCartController extends BaseController {
    @Autowired
    private UavCartService uavCartService;

    @ApiOperation(value = "加入购物车")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("add")
    public ResultBody addCart(@RequestBody UavCartVO uavCartVO) {
        return uavCartService.addCart(uavCartVO);
    }

    @ApiOperation(value = "移除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("remove")
    public ResultBody remove(@RequestParam Integer id) {
        return uavCartService.remove(id);
    }

    @ApiOperation(value = "修改数量")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("updateNum")
    public ResultBody updateNum(@RequestParam(required = true) Integer id,
                             @ApiParam("改变的数量（正加负减）") @RequestParam(required = true) Integer buyNum, HttpServletRequest request) {
        return uavCartService.updateNum(id, buyNum);
    }

    @ApiOperation(value = "购物车列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavCartDTO.class)})
    @GetMapping("list")
    public ResultBody list(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                           HttpServletRequest request) {
        return uavCartService.list(pageNo, pageSize);
    }
}
