package com.mmc.oms.model.dto.uav;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/16 14:08
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UavCartDTO implements Serializable {
    private static final long serialVersionUID = 4386011514861211847L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "用户ID")
    private Integer userAccountId;
    @ApiModelProperty(value = "商家id")
    private Integer thirdBackUserAccountId;
    @ApiModelProperty(value = "商家名称")
    private String companyName;
    @ApiModelProperty(value = "商品id")
    private Integer mallGoodsId;
    @ApiModelProperty(value = "商品名称")
    private String tradeName;
    @ApiModelProperty(value = "商品规格id")
    private Integer priceStockId;
    @ApiModelProperty(value = "商品规格名称")
    private String productSpec;
    @ApiModelProperty(value = "数量")
    private Integer orderNum;
    @ApiModelProperty(value = "售卖价")
    private BigDecimal salePrice;
    @ApiModelProperty(value = "主图或规格图")
    private String skuImage;
    @ApiModelProperty(value = "规格编号")
    private String skuNo;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "是否展示价格，0 不显示  1显示")
    private Integer priceShow;
    @ApiModelProperty(value = "是否删除")
    private Integer deleted;
    @ApiModelProperty(value = "是否上架状态：0: 下架 1:上架")
    private Integer shelfStatus;
}
