package com.mmc.oms.model.dto.mall;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2022/12/21 17:32
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@ExcelTarget("mallGoodsInfo")
public class MallGoodsInfoDTO implements Serializable {
    private static final long serialVersionUID = -3066818201671524986L;
    @Excel(name = "产品名称",width = 25)
    private String productName;

    @Excel(name = "数量",width = 25)
    private Integer count;

    @Excel(name = "单价（元/件）",width = 25)
    private BigDecimal unitPrice;

    @Excel(name = "推荐人采购优惠单价（元/件）",width = 25)
    private BigDecimal recPrice;
}
