package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.OrderGoodsIndstDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * author:zhenjie
 * Date:2022/10/21
 * time:16:32
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderGoodsIndstDO implements Serializable {
    private static final long serialVersionUID = -3279631619974911234L;
    private Integer id;
    private Integer orderId;
    private Integer mallIndstShopCarId;
    private Integer goodsInfoId;
    private Integer directoryId;
    private BigDecimal goodsAmount;
    private String goodsNo;
    private String goodsName;
    private String mainImg;
    private Integer buyNum;
    private Date createTime;
    private Date updateTime;

    private List<OrderGoodsIndstDetailDO> orderGoodsIndstDetailDOS;

    public OrderGoodsIndstDTO buildOrderGoodsIndstDTO(){
        return OrderGoodsIndstDTO.builder().id(this.id).orderId(this.orderId).mallIndstShopCarId(this.mallIndstShopCarId).goodsInfoId(this.goodsInfoId).directoryId(this.directoryId)
                .goodsAmount(this.goodsAmount).goodsNo(this.goodsNo).goodsName(this.goodsName).mainImg(this.mainImg).buyNum(this.buyNum).build();
    }

    public OrderGoodsIndstDO(OrderGoodsIndstDTO orderGoodsIndstDTO){
        this.id = orderGoodsIndstDTO.getId();
        this.orderId = orderGoodsIndstDTO.getOrderId();
        this.mallIndstShopCarId = orderGoodsIndstDTO.getMallIndstShopCarId();
        this.goodsInfoId = orderGoodsIndstDTO.getGoodsInfoId();
        this.directoryId = orderGoodsIndstDTO.getDirectoryId();
        this.goodsAmount = orderGoodsIndstDTO.getGoodsAmount();
        this.goodsNo = orderGoodsIndstDTO.getGoodsNo();
        this.goodsName = orderGoodsIndstDTO.getGoodsName();
        this.mainImg = orderGoodsIndstDTO.getMainImg();
        this.buyNum = orderGoodsIndstDTO.getBuyNum();
    }

}
