package com.mmc.oms.service.lease.impl;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.constant.UavOrderProportion;
import com.mmc.oms.common.json.JsonUtil;
import com.mmc.oms.common.result.PageResult;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.CodeUtil;
import com.mmc.oms.common.util.KdnExpressUtil;
import com.mmc.oms.dao.UserAddressDao;
import com.mmc.oms.dao.lease.LeaseOrderDao;
import com.mmc.oms.entity.lease.LeaseOrderDO;
import com.mmc.oms.entity.lease.LeaseOrderExpressDO;
import com.mmc.oms.entity.lease.LeaseRefundOrderDO;
import com.mmc.oms.entity.mall.UserAddressDO;
import com.mmc.oms.entity.transtatus.TranStatusDicDO;
import com.mmc.oms.enums.LeaseOrderStatus;
import com.mmc.oms.enums.LeaseTermInfo;
import com.mmc.oms.enums.OrderType;
import com.mmc.oms.feign.PaymentAppApi;
import com.mmc.oms.feign.PmsAppApi;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.dto.kdn.KdnExpDTO;
import com.mmc.oms.model.dto.lease.LeaseOrderDTO;
import com.mmc.oms.model.dto.lease.LeaseRefundOrderDTO;
import com.mmc.oms.model.dto.order.ExpStationsDTO;
import com.mmc.oms.model.dto.transtatus.TranStatusDicDTO;
import com.mmc.oms.model.dto.uav.PayWalletDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.dto.user.UserAccountSimpleDTO;
import com.mmc.oms.model.qo.UserAccountQO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.ApplyRefundVO;
import com.mmc.oms.model.vo.demand.CommonPaymentVO;
import com.mmc.oms.model.vo.lease.AddLeaseOrderVO;
import com.mmc.oms.model.vo.lease.LeaseGoodsVO;
import com.mmc.oms.model.vo.lease.LeaseOrderRefundVO;
import com.mmc.oms.model.vo.lease.LeasePriceStockVO;
import com.mmc.oms.model.vo.uav.GoodsResourcesVO;
import com.mmc.oms.model.vo.uav.PayUavWalletVO;
import com.mmc.oms.model.vo.uav.UavOrderExpressVO;
import com.mmc.oms.service.demand.DemandReleaseOrderService;
import com.mmc.oms.service.lease.LeaseOrderService;
import com.mmc.oms.service.uav.UavOrderService;
import com.mmc.oms.util.TDateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/9/21 16:46
 * 概要：
 */
@Service
@Slf4j
public class LeaseOrderServiceImpl implements LeaseOrderService {
    @Resource
    private PmsAppApi pmsAppApi;
    @Resource
    private UavOrderService uavOrderService;
    @Resource
    private LeaseOrderDao leaseOrderDao;
    @Resource
    private UserAddressDao userAddressDao;
    @Resource
    private UserAppApi userAppApi;
    @Resource
    private PaymentAppApi paymentAppApi;
    @Resource
    DemandReleaseOrderService demandReleaseOrderService;

    @Override
    @Transactional
    public ResultBody addLeaseOrder(AddLeaseOrderVO param, BaseAccountDTO currentAccount) {
        log.info("user:{},addOrder param:{}", currentAccount.getUserAccountId(), param);
        if (StringUtils.isEmpty(param.getSku())) {
            return ResultBody.error("至少选择一个规格！");
        }
        if (param.getWareNum() <= 0) {
            return ResultBody.error("购买数量不得少于1");
        }
        LeaseGoodsVO leaseGoodsVO;
        LeasePriceStockVO priceStock = null;
        try {
            leaseGoodsVO = pmsAppApi.leaseGoodsDetails(param.getLeaseGoodsId()).getResult();
            // 检验商品是否在卖
            if (leaseGoodsVO == null || !leaseGoodsVO.getShelfStatus().equals(1)) {
                return ResultBody.error("商品已下架");
            }
            // 判断租赁时间是否超出当前商品的最长租期或小于最短租期
            int distanceDays = TDateUtil.distanceDays(param.getStartDate(), param.getEndDate());
            param.setLeaseTerm(distanceDays);
            // 获取租赁商品的最低租期
            Integer minLeaseTerm = getLeaseTerm(leaseGoodsVO.getMinLeaseTerm());
            // 获取租赁商品的最大租期
            Integer maxLeaseTerm = getLeaseTerm(leaseGoodsVO.getMaxLeaseTerm());
            if (distanceDays < minLeaseTerm || distanceDays > maxLeaseTerm) {
                return ResultBody.error("商品信息发生变更，刷新后重试!");
            }
            // 判断该租期在那个价格区间
            Integer priceSection = getPriceSection(distanceDays);
            // 找到对应的规格
            boolean flag = false;
            for (LeasePriceStockVO priceStockVO : leaseGoodsVO.getPriceStock()) {
                if (param.getSku().equals(priceStockVO.getProductSpec())) {
                    priceStock = priceStockVO;
                    // 获取最新的规格单价
                    param.setUnitPrice(getUnitPrice(priceSection, priceStockVO));
                    param.setDeposit(priceStockVO.getCashPledge());
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                return ResultBody.error("选择规格不存在");
            }
        } catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return ResultBody.error(e.getMessage());
        }

        String orderNo = CodeUtil.generateOrderId();
        // 计算订单总金额
        BigDecimal orderTotalAmount = param.getUnitPrice().multiply(BigDecimal.valueOf(param.getLeaseTerm()))
                .multiply(BigDecimal.valueOf(param.getWareNum())).add(param.getDeposit().multiply(BigDecimal.valueOf(param.getWareNum())));
        BigDecimal otherAmount = BigDecimal.ZERO;
        // 用来进行操作的总金额
        otherAmount = otherAmount.add(orderTotalAmount);
        // 总押金金额
        BigDecimal totalDeposit = param.getDeposit().multiply(BigDecimal.valueOf(param.getWareNum()));
        // 用来操作的总押金
        BigDecimal otherCashPledge = BigDecimal.ZERO;
        otherCashPledge = otherCashPledge.add(totalDeposit);
        // 云享金押金金额,余额押金金额
        BigDecimal shareCashPledge = BigDecimal.ZERO;
        BigDecimal salaryCashPledge = BigDecimal.ZERO;
        // 校验云享金、钱包余额是否足够抵扣
        BigDecimal shareAmount = BigDecimal.ZERO;
        BigDecimal salaryAmount = BigDecimal.ZERO;
        Integer statusCode = null;
        // 获取用户钱包信息
        if (param.getDeductSalaryAmount().equals(1) || param.getDeductShareAmount().equals(1)) {
            ResultBody<PayWalletDTO> payResInfo = userAppApi.getCurrentUserPayWalletInfo(currentAccount.getToken());
            if (!payResInfo.getCode().equals(ResultEnum.SUCCESS.getResultCode()) || payResInfo.getResult() == null) {
                return payResInfo;
            }
            PayWalletDTO payWalletDTO = payResInfo.getResult();
            // 先使用云享金来扣减押金
            if (param.getDeductShareAmount().equals(1)) {
                if (otherCashPledge.compareTo(payWalletDTO.getCashAmt()) >= 0) {
                    // 不够抵扣押金
                    shareCashPledge = payWalletDTO.getCashAmt();
                } else {
                    // 够抵扣押金
                    shareCashPledge = otherCashPledge;
                }
                otherCashPledge = otherCashPledge.subtract(shareCashPledge);
                if (otherCashPledge.compareTo(BigDecimal.ZERO) == 0) {
                    otherAmount = otherAmount.subtract(shareCashPledge);
                } else {
                    if (param.getDeductSalaryAmount().equals(1)) {
                        if (otherCashPledge.compareTo(payWalletDTO.getSalaryAmt()) >= 0) {
                            salaryCashPledge = payWalletDTO.getSalaryAmt();
                        } else {
                            salaryCashPledge = otherCashPledge;
                        }
                        otherCashPledge = otherCashPledge.subtract(salaryCashPledge);
                        if (otherCashPledge.compareTo(BigDecimal.ZERO) == 0) {
                            otherAmount = otherAmount.subtract(salaryCashPledge.add(shareCashPledge));
                        }
                    }
                }

            }
            // 抵扣完后当押金为0的时候 继续抵扣其余金额
            if (otherCashPledge.compareTo(BigDecimal.ZERO) == 0) {
                if (param.getDeductShareAmount().equals(1)) {
                    if (otherAmount.compareTo(payWalletDTO.getCashAmt().subtract(shareCashPledge)) >= 0) {
                        // 抵扣云享金小于等于订单总额时，直接使用云享金
                        shareAmount = payWalletDTO.getCashAmt().subtract(shareCashPledge);
                    } else {
                        // 余额超过订单金额时，订单总额使用余额支付
                        shareAmount = otherAmount;
                    }
                }
                otherAmount = otherAmount.subtract(shareAmount);
                // 支付完成
                if (otherAmount.compareTo(BigDecimal.ZERO) == 0) {
                    statusCode = LeaseOrderStatus.PAID.getCode();
                } else {
                    if (param.getDeductSalaryAmount().equals(1)) {
                        if (otherAmount.compareTo(payWalletDTO.getSalaryAmt().subtract(salaryCashPledge)) >= 0) {
                            // 抵扣余额小于等于订单总额时，直接使用余额
                            salaryAmount = payWalletDTO.getSalaryAmt().subtract(salaryCashPledge);
                        } else {
                            // 余额超过订单金额时，订单总额使用余额支付
                            salaryAmount = otherAmount;
                        }
                    }
                    otherAmount = otherAmount.subtract(salaryAmount);
                    if (otherAmount.compareTo(BigDecimal.ZERO) == 0) {
                        statusCode = LeaseOrderStatus.PAID.getCode();
                    }
                }
            }
            // 抵扣余额
            uavOrderService.deductWallet(shareAmount.add(shareCashPledge), salaryAmount.add(salaryCashPledge), currentAccount);
        }
        // 获取商品主图
        String url = null;
        for (GoodsResourcesVO goodsResourcesVO : leaseGoodsVO.getResourcesList()) {
            if (goodsResourcesVO.getType().equals(0)) {
                url = goodsResourcesVO.getUrl();
                break;
            }
        }
        // 添加总订单表
        LeaseOrderDO leaseOrderDO = new LeaseOrderDO();
        leaseOrderDO.setOrderNo(orderNo);
        leaseOrderDO.setOrderTotalAmount(orderTotalAmount);
        leaseOrderDO.setStatusCode(otherAmount.compareTo(BigDecimal.ZERO) > 0 ? LeaseOrderStatus.PLACED_AN_ORDER.getCode() : statusCode);
        leaseOrderDO.setUserAccountId(currentAccount.getUserAccountId());
        leaseOrderDO.setLeaseGoodsId(param.getLeaseGoodsId());
        leaseOrderDO.setCompanyName(param.getCompanyName());
        leaseOrderDO.setThirdBackUserAccountId(param.getThirdBackUserAccountId());
        leaseOrderDO.setOrderName(leaseGoodsVO.getTradeName());
        leaseOrderDO.setModeOfDeliveryInfo(leaseGoodsVO.getModeOfDeliveryInfo());
        if (priceStock.getSkuImage() != null) {
            leaseOrderDO.setSkuImg(priceStock.getSkuImage());
        } else {
            leaseOrderDO.setSkuImg(url);
        }
        leaseOrderDO.setSalaryAmount(salaryAmount);
        leaseOrderDO.setSku(param.getSku());
        leaseOrderDO.setSalaryCashPledge(salaryCashPledge);
        leaseOrderDO.setShareCashPledge(shareCashPledge);
        leaseOrderDO.setShareAmount(shareAmount);
        leaseOrderDO.setOtherAmount(otherAmount);
        leaseOrderDO.setUserAddressId(param.getUserAddressId());
        leaseOrderDO.setUserRemark(param.getUserRemark());
        leaseOrderDO.setUnitPrice(param.getUnitPrice());
        leaseOrderDO.setWareNum(param.getWareNum());
        leaseOrderDO.setDeposit(param.getDeposit());
        leaseOrderDO.setStartDate(param.getStartDate());
        if (null != statusCode && statusCode.equals(LeaseOrderStatus.PAID.getCode())) {
            leaseOrderDO.setPayTime(new Date());
        }
        leaseOrderDO.setEndDate(param.getEndDate());
        leaseOrderDao.addOrder(leaseOrderDO);
        // 添加收货地址
        UserAddressDO userAddressDO = userAddressDao.selectById(param.getUserAddressId());
        LeaseOrderExpressDO leaseOrderExpressDO = new LeaseOrderExpressDO(userAddressDO);
        leaseOrderExpressDO.setLeaseOrderId(leaseOrderDO.getId());
        leaseOrderDao.addAddress(leaseOrderExpressDO);
        LeaseOrderDTO leaseOrderDTO = leaseOrderDO.buildLeaseOrderDTO();
        leaseOrderDTO.setModeOfDeliveryInfo(leaseGoodsVO.getModeOfDeliveryInfo());
        return ResultBody.success(leaseOrderDTO);
    }

    private Integer getLeaseTerm(Integer leaseTermId) {
        if (leaseTermId.equals(LeaseTermInfo.THREE_DAY.getId())) {
            return LeaseTermInfo.THREE_DAY.getDays();
        } else if (leaseTermId.equals(LeaseTermInfo.SEVEN_DAY.getId())) {
            return LeaseTermInfo.SEVEN_DAY.getDays();
        } else if (leaseTermId.equals(LeaseTermInfo.THIRTY_DAY.getId())) {
            return LeaseTermInfo.THIRTY_DAY.getDays();
        } else if (leaseTermId.equals(LeaseTermInfo.NINETY_DAY.getId())) {
            return LeaseTermInfo.NINETY_DAY.getDays();
        } else {
            return LeaseTermInfo.ONE_HUNDRED_AND_EIGHTY_DAY.getDays();
        }
    }


    private BigDecimal getUnitPrice(Integer priceSection, LeasePriceStockVO priceStockVO) {
        if (priceSection.equals(LeaseTermInfo.THREE_DAY.getDays())) {
            return priceStockVO.getThreeDaysRental();
        } else if (priceSection.equals(LeaseTermInfo.SEVEN_DAY.getDays())) {
            return priceStockVO.getSevenDaysRental();
        } else if (priceSection.equals(LeaseTermInfo.THIRTY_DAY.getDays())) {
            return priceStockVO.getThirtyDaysRental();
        } else if (priceSection.equals(LeaseTermInfo.NINETY_DAY.getDays())) {
            return priceStockVO.getNinetyDaysRental();
        } else {
            return priceStockVO.getMaxDaysRental();
        }
    }

    private Integer getPriceSection(int distanceDays) {
        if (distanceDays >= LeaseTermInfo.THREE_DAY.getDays() && distanceDays < LeaseTermInfo.SEVEN_DAY.getDays()) {
            return LeaseTermInfo.THREE_DAY.getDays();
        } else if (distanceDays >= LeaseTermInfo.SEVEN_DAY.getDays() && distanceDays < LeaseTermInfo.THIRTY_DAY.getDays()) {
            return LeaseTermInfo.SEVEN_DAY.getDays();
        } else if (distanceDays >= LeaseTermInfo.THIRTY_DAY.getDays() && distanceDays < LeaseTermInfo.NINETY_DAY.getDays()) {
            return LeaseTermInfo.THIRTY_DAY.getDays();
        } else if (distanceDays >= LeaseTermInfo.NINETY_DAY.getDays() && distanceDays < LeaseTermInfo.ONE_HUNDRED_AND_EIGHTY_DAY.getDays()) {
            return LeaseTermInfo.NINETY_DAY.getDays();
        } else {
            return LeaseTermInfo.ONE_HUNDRED_AND_EIGHTY_DAY.getDays();
        }
    }

    @Override
    public ResultBody detail(Integer id, BaseAccountDTO currentAccount) throws Exception {
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(id);
        if (leaseOrderDO == null) {
            return ResultBody.error("订单信息不存在！");
        }
        LeaseOrderDTO leaseOrderDTO = leaseOrderDO.buildLeaseOrderDTO();
        if (leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.PLACED_AN_ORDER.getCode())) {
            leaseOrderDTO.setNeedPayAmount(leaseOrderDO.getOtherAmount());
        }
        // 收货信息、付款信息、规格信息、快递信息、签署信息
        LeaseOrderExpressDO leaseOrderExpressDO = leaseOrderDao.getLeaseOrderExpress(id);
        if (leaseOrderExpressDO != null) {
            leaseOrderDTO.setUavOrderExpressDTO(leaseOrderExpressDO.buildUavOrderExpressDTO());
            // 快递信息
            KdnExpDTO kdnExpDTO = this.getOrderExpInfo(leaseOrderExpressDO);
            leaseOrderDTO.setKdnExpDTO(kdnExpDTO);
        }
        // 设置个人信息
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(leaseOrderDO.getUserAccountId(), currentAccount.getToken());
        if (userAccountSimpleDTO != null) {
            leaseOrderDTO.setUserName(userAccountSimpleDTO.getUserName());
            leaseOrderDTO.setNickname(userAccountSimpleDTO.getNickName());
            leaseOrderDTO.setPhoneNum(userAccountSimpleDTO.getPhoneNum());
        }
        return ResultBody.success(leaseOrderDTO);
    }

    private KdnExpDTO getOrderExpInfo(LeaseOrderExpressDO exp) throws Exception {
        String json = "";
        if ("SF".equals(exp.getSendExpCode())) {
            json = KdnExpressUtil.SF(exp.getTakePhone(), exp.getSendExpNo());
        } else if ("JD".equals(exp.getSendExpCode())) {
            json = KdnExpressUtil.JD("", exp.getSendExpNo());
        } else {
            json = KdnExpressUtil.others(exp.getSendExpCode(), exp.getSendExpNo());
        }
        KdnExpDTO kdn = JsonUtil.parseJsonToObj(json, KdnExpDTO.class);
        kdn.setLogisticCode(exp.getSendExpNo());
        if (!org.springframework.util.CollectionUtils.isEmpty(kdn.getTraces())) {
            Collections.sort(kdn.getTraces(), Comparator.comparing(ExpStationsDTO::getAcceptTime).reversed());// 升序
        }
        return kdn;
    }

    @Override
    @Transactional
    public ResultBody close(LeaseOrderRefundVO leaseOrderRefundVO, String token) {
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(leaseOrderRefundVO.getOrderId());
        if (leaseOrderDO == null) {
            return ResultBody.error("订单信息不存在！");
        }
        // 判断订单状态
        if (leaseOrderDO.getStatusCode().compareTo(LeaseOrderStatus.PAID.getCode()) > 0) {
            if (leaseOrderDO.getStatusCode().compareTo(LeaseOrderStatus.TO_BE_RETURNED.getCode()) == 0) {
                return ResultBody.error("当前状态不可申请退款");
            }
            // 判断商品是否需要归还
            if (leaseOrderRefundVO.getStatus().equals(0)) {
                if (leaseOrderRefundVO.getExpressCode() == null || leaseOrderRefundVO.getExpressNum() == null) {
                    return ResultBody.error("请完善物流信息");
                }
            }
            // 插入退货地址信息
            LeaseOrderExpressDO leaseOrderExpressDO = new LeaseOrderExpressDO();
            leaseOrderExpressDO.setLeaseOrderId(leaseOrderRefundVO.getOrderId());
            leaseOrderExpressDO.setReturnExpCode(leaseOrderRefundVO.getExpressCode());
            leaseOrderExpressDO.setReturnExpNo(leaseOrderRefundVO.getExpressNum());
            leaseOrderExpressDO.setReturnTime(new Date());
            leaseOrderDao.updateLeaseOrderExpress(leaseOrderExpressDO);
            // 插入退款订单信息
            LeaseRefundOrderDO leaseRefundOrderDO = new LeaseRefundOrderDO(leaseOrderRefundVO);
            leaseRefundOrderDO.setLeaseOrderExpressId(leaseOrderExpressDO.getId());
            leaseRefundOrderDO.setType(OrderType.RETREAT.getCode());
            leaseOrderDao.addLeaseRefundOrder(leaseRefundOrderDO);
            // 修改订单状态
            leaseOrderDao.updateUavOrderStatus(leaseOrderRefundVO.getStatus(), LeaseOrderStatus.APPLY_REFUND.getCode());
            return ResultBody.success();
        } else {
            // 退云享金、佣金
            if (leaseOrderDO.getShareAmount().compareTo(BigDecimal.ZERO) > 0 || leaseOrderDO.getSalaryAmount().compareTo(BigDecimal.ZERO) > 0) {
                PayUavWalletVO payUavWalletVO = new PayUavWalletVO();
                payUavWalletVO.setCashAmount(leaseOrderDO.getShareAmount());
                payUavWalletVO.setSalaryAmount(leaseOrderDO.getSalaryAmount());
                payUavWalletVO.setOrderStatus(1400);
                payUavWalletVO.setUserAccountId(leaseOrderDO.getUserAccountId());
                ResultBody resultBody = userAppApi.feignPayUavWallet(payUavWalletVO, token);
                if (!resultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                    return resultBody;
                }
            }
            // 微信退款
            if ("wechatpay".equals(leaseOrderDO.getPayType())) {
                ApplyRefundVO applyRefundVO = new ApplyRefundVO();
                applyRefundVO.setOutTradeNo(leaseOrderDO.getOrderNo());
                applyRefundVO.setReason("关闭租赁订单");
                applyRefundVO.setRefund(leaseOrderDO.getOtherAmount().multiply(BigDecimal.valueOf(100)).longValue());
                ResultBody applyRefund = paymentAppApi.applyRefund(applyRefundVO, token);
                log.info("applyRefund res：{}", applyRefund);
                if (!applyRefund.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return ResultBody.error("关闭订单失败！");
                }
            }
            // 修改订单状态
            this.updateLeaseOrderStatus(leaseOrderRefundVO.getOrderId(), LeaseOrderStatus.CLOSE);
            return ResultBody.success();
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateLeaseOrderStatus(Integer id, LeaseOrderStatus leaseOrderStatus) {
        leaseOrderDao.updateUavOrderStatus(id, leaseOrderStatus.getCode());
    }

    @Override
    public ResultBody<LeaseOrderDTO> list(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount) {
        if (!currentAccount.getRoleInfo().getSuperAdmin().equals(1)) {
            uavOrderQO.setThirdBackUserAccountId(currentAccount.getUserAccountId());
        }
        int count = leaseOrderDao.countList(uavOrderQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(uavOrderQO.getPageNo(), uavOrderQO.getPageSize(), count));
        }
        Integer pageNo = uavOrderQO.getPageNo();
        uavOrderQO.buildCurrentPage();
        List<LeaseOrderDO> leaseOrderDOS = leaseOrderDao.list(uavOrderQO);

        Map<Integer, LeaseOrderDTO> leaseOrderDTOMap = new HashMap<>();
        List<Integer> ids = new ArrayList<>();
        List<Integer> userIds = new ArrayList<>();

        for (LeaseOrderDO leaseOrderDO : leaseOrderDOS) {
            LeaseOrderDTO leaseOrderDTO = leaseOrderDO.buildLeaseOrderDTO();
            leaseOrderDTOMap.put(leaseOrderDO.getId(), leaseOrderDTO);
            if (leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.APPLY_REFUND.getCode()) || leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.WAITING_MERCHANT_CONFIRM.getCode())) {
                ids.add(leaseOrderDO.getId());
            }

            userIds.add(leaseOrderDTO.getUserAccountId());
        }

        buildRefundOrder(leaseOrderDTOMap, ids);

        UserAccountQO userAccountQO = new UserAccountQO();
        userAccountQO.setUserIds(userIds);
        List<UserAccountSimpleDTO> userDTOS = userAppApi.feignListAppUserAccount(userAccountQO, currentAccount.getToken());

        if (CollectionUtils.isNotEmpty(userDTOS)) {
            Map<Integer, UserAccountSimpleDTO> userDTOMap = userDTOS.stream().collect(Collectors.toMap(UserAccountSimpleDTO::getId, user -> user, (k1, k2) -> k2));
            for (LeaseOrderDTO leaseOrderDTO : leaseOrderDTOMap.values()) {
                UserAccountSimpleDTO user = userDTOMap.get(leaseOrderDTO.getUserAccountId());
                if (user != null) {
                    leaseOrderDTO.setPhoneNum(user.getPhoneNum());
                    leaseOrderDTO.setNickname(user.getNickName());
                    leaseOrderDTO.setUserName(user.getUserName());
                }
            }
        }

        return ResultBody.success(PageResult.buildPage(pageNo, uavOrderQO.getPageSize(), count, new ArrayList<>(leaseOrderDTOMap.values())));
    }


    @Override
    public ResultBody<LeaseOrderDTO> listByUid(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount) {
        uavOrderQO.setUserAccountId(currentAccount.getUserAccountId());
        uavOrderQO.setShowUserPort(1);
        int count = leaseOrderDao.countList(uavOrderQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(uavOrderQO.getPageNo(), uavOrderQO.getPageSize(), count));
        }
        Integer pageNo = uavOrderQO.getPageNo();
        uavOrderQO.buildCurrentPage();
        List<LeaseOrderDO> leaseOrderDOS = leaseOrderDao.list(uavOrderQO);
        Map<Integer, LeaseOrderDTO> leaseOrderDTOMap = new HashMap<>();
        List<Integer> ids = new ArrayList<>();
        for (LeaseOrderDO leaseOrderDO : leaseOrderDOS) {
            LeaseOrderDTO leaseOrderDTO = leaseOrderDO.buildLeaseOrderDTO();
            leaseOrderDTOMap.put(leaseOrderDO.getId(), leaseOrderDTO);
            if (leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.APPLY_REFUND.getCode())) {
                ids.add(leaseOrderDO.getId());
            }
        }
        buildRefundOrder(leaseOrderDTOMap, ids);
        return ResultBody.success(PageResult.buildPage(pageNo, uavOrderQO.getPageSize(), count, new ArrayList<>(leaseOrderDTOMap.values())));
    }

    private void buildRefundOrder(Map<Integer, LeaseOrderDTO> leaseOrderDTOMap, List<Integer> ids) {
        if (ids.size() > 0) {
            List<LeaseRefundOrderDO> leaseRefundOrderDO = leaseOrderDao.getLeaseRefundOrder(ids);
            List<Integer> expressIds = leaseRefundOrderDO.stream().map(LeaseRefundOrderDO::getLeaseOrderExpressId).collect(Collectors.toList());
            List<LeaseOrderExpressDO> expressDOS = leaseOrderDao.listLeaseOrderExpress(expressIds);

            Map<Integer, LeaseOrderExpressDO> expressDOMap = expressDOS.stream().collect(Collectors.toMap(LeaseOrderExpressDO::getId, Function.identity()));

            for (LeaseRefundOrderDO refundOrderDO : leaseRefundOrderDO) {
                LeaseRefundOrderDTO refundOrderDTO = refundOrderDO.buildLeaseRefundOrderDTO();
                LeaseOrderExpressDO expressDO = expressDOMap.get(refundOrderDO.getLeaseOrderExpressId());
                if (expressDO != null) {
                    refundOrderDTO.setExpressCode(expressDO.getReturnExpCode());
                    refundOrderDTO.setExpressNum(expressDO.getReturnExpNo());
                }
                LeaseOrderDTO correspondingLeaseOrderDTO = leaseOrderDTOMap.get(refundOrderDTO.getLeaseOrderId());
                if (correspondingLeaseOrderDTO != null) {
                    if (refundOrderDO.getType().equals(OrderType.RETREAT.getCode())) {
                        correspondingLeaseOrderDTO.setLeaseRefundOrder(refundOrderDTO);
                    } else {
                        correspondingLeaseOrderDTO.setStoreReceiveOrder(refundOrderDTO);
                    }
                }
            }
        }
    }


    @Override
    public ResultBody pay(Integer id, BaseAccountDTO currentAccount, HttpServletRequest request) {
        // 发起微信支付
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(id);
        if (!leaseOrderDO.getStatusCode().toString().equals(LeaseOrderStatus.PLACED_AN_ORDER.getCode().toString())) {
            return ResultBody.error("操作有误，请重试！");
        }
        CommonPaymentVO commonPaymentVO = new CommonPaymentVO();
        int shouldPay = leaseOrderDO.getOtherAmount().multiply(BigDecimal.valueOf(100)).intValue();
        if (shouldPay <= 0) {
            return ResultBody.success("已支付完成");
        }
        commonPaymentVO.setAmount(shouldPay);
        commonPaymentVO.setDescription(leaseOrderDO.getOrderName());
        commonPaymentVO.setOrderNumber(leaseOrderDO.getOrderNo());
        commonPaymentVO.setOrderPort(1);
        ResultBody resultBody = demandReleaseOrderService.orderPayment(commonPaymentVO, request, currentAccount.getUserAccountId());
        return resultBody;
    }


    @Override
    public ResultBody send(UavOrderExpressVO param) {
        // 修改订单状态
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(param.getUavOrderId());
        if (!leaseOrderDO.getStatusCode().toString().equals(LeaseOrderStatus.PAID.getCode().toString())) {
            return ResultBody.error("状态流程有误，请重试！");
        }
        this.updateLeaseOrderStatus(param.getUavOrderId(), LeaseOrderStatus.SHIPPED);
        // 修改收货信息
        LeaseOrderExpressDO leaseOrderExpressDO = new LeaseOrderExpressDO(param);
        leaseOrderExpressDO.setSendTime(new Date());
        leaseOrderDao.updateLeaseOrderExpress(leaseOrderExpressDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody receive(Integer id, BaseAccountDTO currentAccount) {
        // 修改订单状态
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(id);
        if (!leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.SHIPPED.getCode())) {
            return ResultBody.error("状态流程有误，请重试！");
        }
        // 修改收货信息
        LeaseOrderExpressDO leaseOrderExpress = leaseOrderDao.getLeaseOrderExpress(id);
        leaseOrderExpress.setReceive(1);
        leaseOrderExpress.setReceiveTime(new Date());
        leaseOrderDao.updateLeaseOrderExpress(leaseOrderExpress);
        this.updateLeaseOrderStatus(id, LeaseOrderStatus.TO_BE_RETURNED);
        return ResultBody.success();
    }

    @Override
    public ResultBody statusList() {
        List<TranStatusDicDO> statusDOS = leaseOrderDao.statusList();
        List<TranStatusDicDTO> uavOrderStatusDTOS = statusDOS.stream().map(TranStatusDicDO::buildTranStatusDicDTO).collect(Collectors.toList());
        return ResultBody.success(uavOrderStatusDTOS);
    }


    @Override
    public ResultBody removeLeaseOrder(Integer id) {
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(id);
        log.info("leaseOrderDO:{}", JSONObject.toJSONString(leaseOrderDO));
        if (leaseOrderDO.getStatusCode().compareTo(LeaseOrderStatus.COMPLETE_TRANSACTION.getCode()) < 0) {
            return ResultBody.error("该订单状态不可删除！");
        }
        leaseOrderDao.closeShowLeaseOrder(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody giveBack(LeaseOrderRefundVO leaseOrderRefundVO, BaseAccountDTO currentAccount) {
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(leaseOrderRefundVO.getOrderId());
        log.info("leaseOrderDO:{}", JSONObject.toJSONString(leaseOrderDO));
        if (!leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.TO_BE_RETURNED.getCode())) {
            return ResultBody.error("状态流程有误，请重试！");
        }
        LeaseOrderExpressDO leaseOrderExpressDO = new LeaseOrderExpressDO(leaseOrderRefundVO);
        leaseOrderDao.updateLeaseOrderExpress(leaseOrderExpressDO);
        this.updateLeaseOrderStatus(leaseOrderRefundVO.getOrderId(), LeaseOrderStatus.WAITING_MERCHANT_CONFIRM);
        return ResultBody.success();
    }

    @Override
    @Transactional
    public ResultBody pfConfirmOrderWare(BaseAccountDTO currentAccount, LeaseOrderRefundVO param) {
        LeaseOrderDO leaseOrderDO = leaseOrderDao.detail(param.getOrderId());
        log.info("leaseOrderDO:{}", JSONObject.toJSONString(leaseOrderDO));
        if (leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.WAITING_MERCHANT_CONFIRM.getCode()) || leaseOrderDO.getStatusCode().equals(LeaseOrderStatus.APPLY_REFUND.getCode())) {
            if (param.getDamage().equals(0)) {
                // 解冻用户钱包金额
                if (leaseOrderDO.getShareAmount().compareTo(BigDecimal.ZERO) > 0 || leaseOrderDO.getSalaryAmount().compareTo(BigDecimal.ZERO) > 0) {
                    PayUavWalletVO userPayUavWalletVO = new PayUavWalletVO();
                    userPayUavWalletVO.setRemark("租赁订单金额解冻");
                    userPayUavWalletVO.setCashAmount(leaseOrderDO.getShareAmount());
                    userPayUavWalletVO.setSalaryAmount(leaseOrderDO.getSalaryAmount());
                    userPayUavWalletVO.setUserAccountId(leaseOrderDO.getUserAccountId());
                    userPayUavWalletVO.setOrderStatus(999);
                    ResultBody resultBody = userAppApi.feignPayUavWallet(userPayUavWalletVO, currentAccount.getToken());
                    if (!resultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return resultBody;
                    }
                }
                BigDecimal thirdAmount = leaseOrderDO.getOrderTotalAmount().multiply(
                        BigDecimal.valueOf(100).subtract(UavOrderProportion.PROPORTION).divide(BigDecimal.valueOf(100)));
                PayUavWalletVO payUavWalletVO = new PayUavWalletVO();
                payUavWalletVO.setSalaryAmount(thirdAmount);
                payUavWalletVO.setCashAmount(BigDecimal.ZERO);
                payUavWalletVO.setRemark("租赁订单收入，订单编号" + leaseOrderDO.getOrderNo());
                payUavWalletVO.setOrderStatus(1500);
                // 拿到商家管理员的用户id
                ResultBody managerRes = userAppApi.getManagerIdByBackUserId(leaseOrderDO.getThirdBackUserAccountId(), null);
                if (!managerRes.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return managerRes;
                }
                payUavWalletVO.setUserAccountId((Integer) managerRes.getResult());
                ResultBody resultBody = userAppApi.feignPayUavWallet(payUavWalletVO, currentAccount.getToken());
                if (!resultBody.getCode().equals(ResultEnum.SUCCESS.getResultCode())) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return resultBody;
                }
                leaseOrderDao.updateLeaseOrderProportion(leaseOrderDO.getId(), UavOrderProportion.PROPORTION.intValue());
                if (leaseOrderDO.equals(LeaseOrderStatus.WAITING_MERCHANT_CONFIRM.getCode())) {
                    this.updateLeaseOrderStatus(param.getOrderId(), LeaseOrderStatus.REMAIN_TO_BE_EVALUATED);
                } else {
                    this.updateLeaseOrderStatus(param.getOrderId(), LeaseOrderStatus.CLOSE);
                }
            } else {
                // todo 进行相应赔偿
            }
        } else {
            return ResultBody.error("状态流程有误，请重试！");
        }
        return ResultBody.success();
    }
}
