package com.mmc.oms.model.dto.mall;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/4 10:17
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class OrderBaseDTO implements Serializable {
    private static final long serialVersionUID = -6909778331393779181L;
    private Long id;
    private String orderNo;
    private Date orderDate;
    private BigDecimal orderAmount;
    @ApiModelProperty(value = "实际付款")
    private BigDecimal actualPayment;
    @ApiModelProperty(value = "抵扣优惠券金额")
    private BigDecimal deductionAmount;
    @ApiModelProperty(value = "折扣金额")
    private BigDecimal discountAmount;
    @ApiModelProperty(value = "合同签署方式,1:线上,0:线下")
    private Integer contractSignedWay;
    private String remark;
    @ApiModelProperty("下单用户id")
    private Integer userAccountId;
    @ApiModelProperty("买家uid")
    private String uid;
    @ApiModelProperty("买家姓名")
    private String userName;
    @ApiModelProperty("买家昵称")
    private String userNickname;
    @ApiModelProperty(value = "买家认证企业")
    private String entName;
    @ApiModelProperty(value = "是否完成实名认证和法人认证")
    private Integer realNameAuth;
    @ApiModelProperty(value = "分销商等级")
    private String tagName;
    @ApiModelProperty(value = "推荐人")
    private String recMallUserName;
    @ApiModelProperty(value = "推荐人uid")
    private String recMallUid;
    @ApiModelProperty(value = "销售名称")
    private String saleName;
    @ApiModelProperty(value = "销售uid")
    private String saleUid;
    @ApiModelProperty(value = "运营人员名称")
    private String operationName;
    @ApiModelProperty(value = "运营人员uid")
    private String operationUid;
    @ApiModelProperty(value = "商品清单")
    List<MallGoodsInfoDTO> mallGoodsInfoDTOS;
    @Excel(name = "推荐人采购优惠总价（元）", orderNum = "14", width = 25, needMerge = true)
    private BigDecimal recDiscountTotalPrice;
    @Excel(name = "推荐人利润（元）", orderNum = "15", width = 25, needMerge = true)
    private BigDecimal recProfit;
}
